/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.drools.guvnor.importgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.drools.compiler.DroolsParserException;
import org.jboss.drools.guvnor.importgenerator.CmdArgsParser;
import org.jboss.drools.guvnor.importgenerator.Constants;
import org.jboss.drools.guvnor.importgenerator.GeneratedData;
import org.jboss.drools.guvnor.importgenerator.PackageFile;
import org.jboss.drools.guvnor.importgenerator.Rule;
import org.jboss.drools.guvnor.importgenerator.utils.FileIO;
import org.jboss.drools.guvnor.importgenerator.utils.Logger;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFileGenerator
implements Constants {
    private Logger logger = null;
    private CmdArgsParser options = null;
    private String BASE_DIR = System.getProperty("user.dir");

    public String generateImportFile(Map<String, PackageFile> packages) throws Exception {
        String draftStateReferenceUUID = GeneratedData.generateUUID();
        String categoryReferenceUUID = GeneratedData.generateUUID();
        int cok = 0;
        int cerror = 0;
        int derror = 0;
        int terror = 0;
        int total = 0;
        StringBuffer packageContents = new StringBuffer();
        StringBuffer snapshotContents = new StringBuffer();
        double i = 0.0;
        double pct = 0.0;
        Iterator<String> it = packages.keySet().iterator();
        while (it.hasNext()) {
            double newPct;
            pct = newPct = (double)((int)((i += 1.0) / (double)packages.size() * 100.0));
            String packageName = it.next();
            this.logger.debug(new DecimalFormat("##0").format(pct) + "% - " + packageName);
            PackageFile packageFile = packages.get(packageName);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("file", packageFile.getFile());
            context.put("draftStateReferenceUUID", draftStateReferenceUUID);
            context.put("categoryReferenceUUID", categoryReferenceUUID);
            context.put("packageFile", packageFile);
            StringBuffer ruleContents = new StringBuffer();
            StringBuffer snapshotRuleContents = new StringBuffer();
            Map<String, Rule> rules = packageFile.getRules();
            packageFile.buildPackage();
            for (String ruleName : rules.keySet()) {
                Rule rule = rules.get(ruleName);
                context.put("rule", rule);
                ruleContents.append(MessageFormat.format(this.readTemplate(MessageFormat.format("template_rule_{0}.xml", packageFile.getFormat())), this.getRuleObjects(context)));
                snapshotRuleContents.append(MessageFormat.format(this.readTemplate(MessageFormat.format("template_snapshot_rule_{0}.xml", packageFile.getFormat())), this.getRuleObjects(context)));
            }
            String packageTemplate = this.readTemplate("template_package.xml");
            packageContents.append(MessageFormat.format(packageTemplate, this.getPackageObjects(context, ruleContents, PackageObjectType.PACKAGE)));
            if (this.options.getOption(CmdArgsParser.Parameters.OPTIONS_SNAPSHOT_NAME) != null) {
                snapshotContents.append(MessageFormat.format(this.readTemplate("template_snapshot.xml"), this.getPackageObjects(context, snapshotRuleContents, PackageObjectType.PACKAGE_SNAPSHOT)));
            }
            ++total;
            if (packageFile.hasErrors()) {
                ++terror;
                if (packageFile.hasCompilationErrors()) {
                    ++cerror;
                    this.logger.debugln(" - [COMPILATION/DEPENDENCY ERRORS]");
                    if (!"true".equals(this.options.getOption(CmdArgsParser.Parameters.OPTIONS_VERY_VERBOSE))) continue;
                    this.logger.debugln(packageFile.getCompilationErrors().trim());
                    this.logger.debugln(packageFile.getDependencyErrors().trim());
                    continue;
                }
                if (!packageFile.hasDependencyErrors()) continue;
                ++derror;
                this.logger.debugln(" - [DEPENDENCY ERRORS]");
                if (!"true".equals(this.options.getOption(CmdArgsParser.Parameters.OPTIONS_VERY_VERBOSE))) continue;
                this.logger.debugln(packageFile.getDependencyErrors().trim());
                continue;
            }
            ++cok;
            this.logger.debugln(" - [OK]");
        }
        String parentContents = MessageFormat.format(this.readTemplate("template_parent.xml"), packageContents, categoryReferenceUUID, draftStateReferenceUUID, GeneratedData.getTimestamp(), this.getSnapshotContents(snapshotContents));
        this.logger.debugln("==========================");
        this.logger.debugln("===  PACKAGE SUMMARY   ===");
        this.logger.debugln("==========================");
        this.logger.debugln(" Rules compiled OK:   " + NumberFormat.getInstance().format(cok));
        this.logger.debugln(" Errors:              " + NumberFormat.getInstance().format(terror));
        this.logger.debugln("                      ____");
        this.logger.debugln(" Total:               " + NumberFormat.getInstance().format(total));
        this.logger.debugln("==========================");
        return parentContents;
    }

    public String generateKnowledgeAgentInitFile(Map<String, PackageFile> packages) throws Exception {
        StringBuffer kagentInitContents = new StringBuffer();
        String kagentChildTemplate = this.readTemplate("template_change_set_child.xml");
        StringBuffer kagentChildContents = new StringBuffer();
        for (String packageName : packages.keySet()) {
            PackageFile packageFile = packages.get(packageName);
            kagentChildContents.append(MessageFormat.format(kagentChildTemplate, this.options.getOption(CmdArgsParser.Parameters.OPTIONS_KAGENT_CHANGE_SET_SERVER), packageFile.getName() + "/" + this.options.getOption(CmdArgsParser.Parameters.OPTIONS_SNAPSHOT_NAME), "PKG"));
        }
        String kagentParentTemplate = this.readTemplate("template_change_set_parent.xml");
        kagentInitContents.append(MessageFormat.format(kagentParentTemplate, kagentChildContents.toString()));
        return kagentInitContents.toString();
    }

    private StringBuffer getSnapshotContents(StringBuffer snapshotContents) {
        if (this.options.getOption(CmdArgsParser.Parameters.OPTIONS_SNAPSHOT_NAME) != null) {
            return snapshotContents;
        }
        return new StringBuffer("");
    }

    private String readTemplate(String templateConst) throws FileNotFoundException {
        return FileIO.readAll(new FileInputStream(new File(new File(this.BASE_DIR, "templates"), templateConst)));
    }

    private Object[] getPackageObjects(Map<String, Object> context, StringBuffer ruleContents, PackageObjectType type) throws UnsupportedEncodingException, DroolsParserException, IOException {
        LinkedList<String> objects = new LinkedList<String>();
        PackageFile packageFile = (PackageFile)context.get("packageFile");
        switch (type) {
            case PACKAGE: {
                objects.add(packageFile.getName());
                objects.add(this.getCreator());
                objects.add(packageFile.getImports());
                objects.add(ruleContents.toString());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add((String)context.get("draftStateReferenceUUID"));
                objects.add(GeneratedData.getTimestamp());
                break;
            }
            case PACKAGE_SNAPSHOT: {
                objects.add(packageFile.getName());
                objects.add(packageFile.getName().substring(packageFile.getName().lastIndexOf(".") + 1));
                objects.add(this.options.getOption(CmdArgsParser.Parameters.OPTIONS_SNAPSHOT_NAME));
                objects.add(this.getCreator());
                objects.add(packageFile.getImports());
                objects.add(ruleContents.toString());
                objects.add((String)context.get("draftStateReferenceUUID"));
                objects.add(GeneratedData.getTimestamp());
                objects.add(FileIO.toBase64(packageFile.toByteArray()));
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
                objects.add(GeneratedData.generateUUID());
            }
        }
        return objects.toArray(new Object[objects.size()]);
    }

    private Object[] getRuleObjects(Map<String, Object> context) {
        LinkedList<String> objects = new LinkedList<String>();
        PackageFile packageFile = (PackageFile)context.get("packageFile");
        Rule rule = (Rule)context.get("rule");
        objects.add(rule.getRuleName());
        objects.add(packageFile.getName());
        objects.add(rule.getContent());
        objects.add(GeneratedData.generateUUID());
        objects.add((String)context.get("draftStateReferenceUUID"));
        objects.add((String)context.get("categoryReferenceUUID"));
        objects.add(this.getCreator());
        objects.add(GeneratedData.getTimestamp());
        objects.add(packageFile.getFormat());
        objects.add(GeneratedData.generateUUID());
        if (packageFile.getFormat().equals("xls")) {
            objects.add(((File)context.get("file")).getName());
        }
        return objects.toArray(new Object[0]);
    }

    private String getCreator() {
        if (this.options.getOption(CmdArgsParser.Parameters.OPTIONS_CREATOR) != null) {
            return this.options.getOption(CmdArgsParser.Parameters.OPTIONS_CREATOR);
        }
        return "generated";
    }

    public void run(CmdArgsParser options) throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date startd = new Date();
        DateTime start = new DateTime((Object)startd);
        this.options = options;
        this.BASE_DIR = options.getOption(CmdArgsParser.Parameters.OPTIONS_BASE_DIR);
        this.logger = Logger.getLogger(ImportFileGenerator.class, options);
        this.logger.debugln("Running BRMS Import Generator (started " + fmt.format(startd) + "):");
        this.logger.debugln("Scanning directories...");
        Map<String, PackageFile> details = PackageFile.buildPackages(options);
        this.logger.debugln("Generating 'Guvnor import data'...");
        String guvnorImport = this.generateImportFile(details);
        File guvnorImportFile = this.getFile(options.getOption(CmdArgsParser.Parameters.OPTIONS_OUTPUT_FILE));
        this.logger.debugln("Writing 'Guvnor import data to disk' (" + guvnorImportFile.getAbsolutePath() + ")");
        FileIO.write(guvnorImport, guvnorImportFile);
        if (options.getOption(CmdArgsParser.Parameters.OPTIONS_KAGENT_CHANGE_SET_FILE) != null) {
            this.logger.debugln("Generating 'Knowledge agent changeset' data...");
            String kagentChangeSet = this.generateKnowledgeAgentInitFile(details);
            File kagentChangeSetFile = this.getFile(options.getOption(CmdArgsParser.Parameters.OPTIONS_KAGENT_CHANGE_SET_FILE));
            this.logger.debugln("Writing 'Knowledge agent changeset' to disk (" + kagentChangeSetFile.getAbsolutePath() + ")");
            FileIO.write(kagentChangeSet, kagentChangeSetFile);
        }
        DateTime end = new DateTime(System.currentTimeMillis());
        int m = Minutes.minutesBetween((ReadableInstant)start, (ReadableInstant)end).getMinutes();
        int s = Seconds.secondsBetween((ReadableInstant)start, (ReadableInstant)end).getSeconds() - m * 60;
        this.logger.debugln("Finished in (" + m + "m" + s + "s)");
    }

    private File getFile(String fileLoc) {
        if (fileLoc.startsWith("/") || fileLoc.startsWith("~")) {
            return new File(fileLoc);
        }
        return new File(this.BASE_DIR, fileLoc);
    }

    public static void main(String[] args) {
        ImportFileGenerator i = new ImportFileGenerator();
        try {
            CmdArgsParser cmd = new CmdArgsParser();
            cmd.parse(args);
            i.run(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RuleObjectType {
        RULE,
        SNAPSHOT_RULE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackageObjectType {
        PACKAGE,
        PACKAGE_SNAPSHOT;

    }
}

