/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ToStringUtils;

public class NameRangeQuery
extends Query {
    private final Name lowerName;
    private final Name upperName;
    private final boolean inclusive;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private final PerQueryCache cache;

    public NameRangeQuery(Name lowerName, Name upperName, boolean inclusive, IndexFormatVersion version, NamespaceMappings nsMappings, PerQueryCache cache) {
        if (lowerName == null && upperName == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerName != null && upperName != null && !lowerName.getNamespaceURI().equals(upperName.getNamespaceURI())) {
            throw new IllegalArgumentException("Both names must have the same namespace URI");
        }
        this.lowerName = lowerName;
        this.upperName = upperName;
        this.inclusive = inclusive;
        this.version = version;
        this.nsMappings = nsMappings;
        this.cache = cache;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query q;
        if (this.version.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            RangeQuery localNames = new RangeQuery(this.getLowerLocalNameTerm(), this.getUpperLocalNameTerm(), this.inclusive, this.cache);
            BooleanQuery query = new BooleanQuery();
            query.add(new JackrabbitTermQuery(new Term(FieldNames.NAMESPACE_URI, this.getNamespaceURI())), BooleanClause.Occur.MUST);
            query.add(localNames, BooleanClause.Occur.MUST);
            q = query;
        } else {
            q = new RangeQuery(this.getLowerTerm(), this.getUpperTerm(), this.inclusive, this.cache);
        }
        return ((Query)q).rewrite(reader);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("name():");
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerName != null ? this.lowerName.toString() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperName != null ? this.upperName.toString() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    private String getNamespaceURI() {
        return this.lowerName != null ? this.lowerName.getNamespaceURI() : this.upperName.getNamespaceURI();
    }

    private Term getLowerLocalNameTerm() {
        if (this.lowerName == null) {
            return null;
        }
        return new Term(FieldNames.LOCAL_NAME, this.lowerName.getLocalName());
    }

    private Term getUpperLocalNameTerm() {
        if (this.upperName == null) {
            return null;
        }
        return new Term(FieldNames.LOCAL_NAME, this.upperName.getLocalName());
    }

    private Term getLowerTerm() throws IOException {
        try {
            String text = this.lowerName == null ? this.nsMappings.getPrefix(this.upperName.getNamespaceURI()) + ":" : this.nsMappings.translateName(this.lowerName);
            return new Term(FieldNames.LABEL, text);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }

    private Term getUpperTerm() throws IOException {
        try {
            String text = this.upperName == null ? this.nsMappings.getPrefix(this.lowerName.getNamespaceURI()) + ":\uffff" : this.nsMappings.translateName(this.upperName);
            return new Term(FieldNames.LABEL, text);
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }
}

