/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.RAMDirectory;

class VolatileIndex
extends AbstractIndex {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private final Map pending = new LinkedMap();
    private int bufferSize = 10;
    private int numDocs = 0;

    VolatileIndex(Analyzer analyzer, Similarity similarity, IndexingQueue indexingQueue) throws IOException {
        super(analyzer, similarity, new RAMDirectory(), null, indexingQueue);
    }

    void addDocuments(Document[] docs) throws IOException {
        for (int i = 0; i < docs.length; ++i) {
            Document old = this.pending.put(docs[i].get(FieldNames.UUID), docs[i]);
            if (old != null) {
                Util.disposeDocument(old);
            }
            if (this.pending.size() >= this.bufferSize) {
                this.commitPending();
            }
            ++this.numDocs;
        }
        this.invalidateSharedReader();
    }

    int removeDocument(Term idTerm) throws IOException {
        int num;
        Document doc = (Document)this.pending.remove(idTerm.text());
        if (doc != null) {
            Util.disposeDocument(doc);
            num = 1;
        } else {
            num = super.getIndexReader().deleteDocuments(idTerm);
        }
        this.numDocs -= num;
        return num;
    }

    int getNumDocuments() {
        return this.numDocs;
    }

    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        this.commitPending();
        return super.getIndexReader();
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        this.commitPending();
        super.commit(optimize);
    }

    long getRamSizeInBytes() {
        return super.getRamSizeInBytes() + ((RAMDirectory)this.getDirectory()).sizeInBytes();
    }

    void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private void commitPending() throws IOException {
        if (this.pending.isEmpty()) {
            return;
        }
        super.addDocuments(this.pending.values().toArray(new Document[this.pending.size()]));
        this.pending.clear();
    }
}

