/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.value;

import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefCountingBLOBFileValue
extends BLOBFileValue {
    private static final Logger log = LoggerFactory.getLogger(RefCountingBLOBFileValue.class);
    private final BLOBFileValue value;
    private int refCount = 1;
    private boolean disposed = false;

    public RefCountingBLOBFileValue(BLOBFileValue value) {
        this.value = value;
    }

    public synchronized void dispose() {
        if (this.refCount > 0) {
            if (--this.refCount == 0) {
                log.debug("{}@refCount={}, discarding value...", System.identityHashCode(this), (Object)this.refCount);
                this.value.dispose();
                this.disposed = true;
            } else {
                log.debug("{}@refCount={}", System.identityHashCode(this), (Object)this.refCount);
            }
        }
    }

    void delete(boolean pruneEmptyParentDirs) {
        this.value.delete(pruneEmptyParentDirs);
    }

    synchronized BLOBFileValue copy() throws RepositoryException {
        if (this.refCount <= 0) {
            throw new RepositoryException("this BLOBFileValue has been disposed");
        }
        RefCountBinary bin = new RefCountBinary();
        ++this.refCount;
        log.debug("{}@refCount={}", System.identityHashCode(this), (Object)this.refCount);
        return bin;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RefCountingBLOBFileValue) {
            RefCountingBLOBFileValue val = (RefCountingBLOBFileValue)obj;
            return this.value.equals(val.value);
        }
        return false;
    }

    public String toString() {
        return this.value.toString();
    }

    public int hashCode() {
        return 0;
    }

    public long getSize() throws RepositoryException {
        return this.value.getSize();
    }

    public InputStream getStream() throws RepositoryException {
        return this.value.getStream();
    }

    protected void finalize() throws Throwable {
        if (!this.disposed) {
            this.dispose();
        }
        super.finalize();
    }

    private final class RefCountBinary
    extends BLOBFileValue {
        private boolean disposed;

        private RefCountBinary() {
        }

        public InputStream getStream() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().getStream();
        }

        public long getSize() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().getSize();
        }

        public void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.getInternalValue().dispose();
            }
        }

        void delete(boolean pruneEmptyParentDirs) {
            this.getInternalValue().delete(pruneEmptyParentDirs);
        }

        BLOBFileValue copy() throws RepositoryException {
            this.checkDisposed();
            return this.getInternalValue().copy();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RefCountBinary) {
                RefCountBinary other = (RefCountBinary)obj;
                return this.getInternalValue().equals(other.getInternalValue());
            }
            return false;
        }

        public String toString() {
            return this.getInternalValue().toString();
        }

        public int hashCode() {
            return 0;
        }

        protected void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }

        private BLOBFileValue getInternalValue() {
            return RefCountingBLOBFileValue.this;
        }

        private void checkDisposed() throws RepositoryException {
            if (this.disposed) {
                throw new RepositoryException("this BLOBFileValue is disposed");
            }
        }
    }
}

