/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.presentationml.x2006.main.CTComment;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideIdListEntry;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    public XSLFPowerPointExtractorDecorator(XSLFPowerPointExtractor extractor) {
        super(extractor, "application/vnd.openxmlformats-officedocument.presentationml.presentation");
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSLFSlide[] slides;
        XSLFSlideShow slideShow = (XSLFSlideShow)this.extractor.getDocument();
        XMLSlideShow xmlSlideShow = new XMLSlideShow(slideShow);
        for (XSLFSlide slide : slides = xmlSlideShow.getSlides()) {
            CTSlide rawSlide = slide._getCTSlide();
            CTSlideIdListEntry slideId = slide._getCTSlideId();
            CTNotesSlide notes = xmlSlideShow._getXSLFSlideShow().getNotes(slideId);
            CTCommentList comments = xmlSlideShow._getXSLFSlideShow().getSlideComments(slideId);
            xhtml.startElement("div");
            this.extractShapeContent(rawSlide.getCSld().getSpTree(), xhtml);
            if (comments != null) {
                for (CTComment comment : comments.getCmArray()) {
                    xhtml.element("p", comment.getText());
                }
            }
            if (notes != null) {
                this.extractShapeContent(notes.getCSld().getSpTree(), xhtml);
            }
            xhtml.endElement("div");
        }
    }

    private void extractShapeContent(CTGroupShape gs, XHTMLContentHandler xhtml) throws SAXException {
        CTShape[] shapes;
        for (CTShape shape : shapes = gs.getSpArray()) {
            CTTextParagraph[] paras;
            CTTextBody textBody = shape.getTxBody();
            if (textBody == null) continue;
            for (CTTextParagraph textParagraph : paras = textBody.getPArray()) {
                CTRegularTextRun[] textRuns;
                for (CTRegularTextRun textRun : textRuns = textParagraph.getRArray()) {
                    xhtml.element("p", textRun.getT());
                }
            }
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() throws TikaException {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        XSLFSlideShow document = (XSLFSlideShow)this.extractor.getDocument();
        for (CTSlideIdListEntry ctSlide : document.getSlideReferences().getSldIdList()) {
            PackagePart slidePart;
            try {
                slidePart = document.getSlidePart(ctSlide);
            }
            catch (IOException e) {
                throw new TikaException("Broken OOXML file", e);
            }
            catch (XmlException xe) {
                throw new TikaException("Broken OOXML file", xe);
            }
            parts.add(slidePart);
            try {
                for (PackageRelationship rel : slidePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing")) {
                    if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
                    parts.add(rel.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                throw new TikaException("Broken OOXML file", e);
            }
        }
        return parts;
    }
}

