/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.base.SequentialKnowledgeHelper;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.ActivationGroupImpl;
import org.drools.common.ActivationGroupNode;
import org.drools.common.ActivationNode;
import org.drools.common.ActivationsFilter;
import org.drools.common.AgendaGroupFactory;
import org.drools.common.AgendaItem;
import org.drools.common.EventFactHandle;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.common.RuleFlowGroupListener;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.Scheduler;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.Declaration;
import org.drools.rule.EntryPoint;
import org.drools.rule.Rule;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.ConsequenceExceptionHandler;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleFlowGroup;
import org.drools.time.impl.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAgenda
implements Externalizable,
InternalAgenda {
    private static final long serialVersionUID = 510L;
    private InternalWorkingMemory workingMemory;
    private LinkedList scheduledActivations;
    private Map<String, InternalAgendaGroup> agendaGroups;
    private Map<String, ActivationGroup> activationGroups;
    private Map<String, RuleFlowGroup> ruleFlowGroups;
    private java.util.LinkedList<AgendaGroup> focusStack;
    private InternalAgendaGroup currentModule;
    private InternalAgendaGroup main;
    private AgendaGroupFactory agendaGroupFactory;
    private KnowledgeHelper knowledgeHelper;
    public int activeActivations;
    public int dormantActivations;
    private org.drools.spi.ConsequenceExceptionHandler legacyConsequenceExceptionHandler;
    private ConsequenceExceptionHandler consequenceExceptionHandler;
    protected volatile AtomicBoolean halt = new AtomicBoolean(false);
    private int activationCounter;
    private boolean declarativeAgenda;
    private ObjectTypeConf activationObjectTypeConf;
    private ActivationsFilter activationsFilter;
    private volatile boolean isFiringActivation = false;
    private volatile boolean mustNotifyHalt = false;
    private ActivationGroup stagedActivations;

    public DefaultAgenda() {
    }

    public DefaultAgenda(InternalRuleBase rb) {
        this(rb, true);
    }

    public DefaultAgenda(InternalRuleBase rb, boolean initMain) {
        Object object;
        this.agendaGroups = new HashMap<String, InternalAgendaGroup>();
        this.activationGroups = new HashMap<String, ActivationGroup>();
        this.ruleFlowGroups = new HashMap<String, RuleFlowGroup>();
        this.focusStack = new java.util.LinkedList();
        this.scheduledActivations = new LinkedList();
        this.agendaGroupFactory = rb.getConfiguration().getAgendaGroupFactory();
        if (initMain) {
            this.main = this.agendaGroupFactory.createAgendaGroup("MAIN", rb);
            this.agendaGroups.put("MAIN", this.main);
            this.focusStack.add(this.main);
        }
        if ((object = ClassUtils.instantiateObject(rb.getConfiguration().getConsequenceExceptionHandler(), rb.getConfiguration().getClassLoader())) instanceof org.drools.spi.ConsequenceExceptionHandler) {
            this.legacyConsequenceExceptionHandler = (org.drools.spi.ConsequenceExceptionHandler)object;
        } else {
            this.consequenceExceptionHandler = (ConsequenceExceptionHandler)object;
        }
        this.declarativeAgenda = rb.getConfiguration().isDeclarativeAgenda();
    }

    @Override
    public AgendaItem createAgendaItem(LeftTuple tuple, int salience, PropagationContext context, RuleTerminalNode rtn) {
        return new AgendaItem(this.activationCounter++, tuple, salience, context, rtn);
    }

    @Override
    public ScheduledAgendaItem createScheduledAgendaItem(LeftTuple tuple, PropagationContext context, RuleTerminalNode rtn) {
        return new ScheduledAgendaItem((long)this.activationCounter++, tuple, this, context, rtn);
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.knowledgeHelper = ((InternalRuleBase)this.workingMemory.getRuleBase()).getConfiguration().isSequential() ? new SequentialKnowledgeHelper(this.workingMemory) : new DefaultKnowledgeHelper(this.workingMemory);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.scheduledActivations = (LinkedList)in.readObject();
        this.agendaGroups = (Map)in.readObject();
        this.activationGroups = (Map)in.readObject();
        this.ruleFlowGroups = (Map)in.readObject();
        this.focusStack = (java.util.LinkedList)in.readObject();
        this.currentModule = (InternalAgendaGroup)in.readObject();
        this.main = (InternalAgendaGroup)in.readObject();
        this.agendaGroupFactory = (AgendaGroupFactory)in.readObject();
        this.knowledgeHelper = (KnowledgeHelper)in.readObject();
        this.activeActivations = in.readInt();
        this.dormantActivations = in.readInt();
        this.legacyConsequenceExceptionHandler = (org.drools.spi.ConsequenceExceptionHandler)in.readObject();
        this.declarativeAgenda = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.scheduledActivations);
        out.writeObject(this.agendaGroups);
        out.writeObject(this.activationGroups);
        out.writeObject(this.ruleFlowGroups);
        out.writeObject(this.focusStack);
        out.writeObject(this.currentModule);
        out.writeObject(this.main);
        out.writeObject(this.agendaGroupFactory);
        out.writeObject(this.knowledgeHelper);
        out.writeInt(this.activeActivations);
        out.writeInt(this.dormantActivations);
        out.writeObject(this.legacyConsequenceExceptionHandler);
        out.writeBoolean(this.declarativeAgenda);
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public void scheduleItem(ScheduledAgendaItem item, InternalWorkingMemory wm) {
        if (item.getPropagationContext().getReaderContext() == null) {
            Scheduler.scheduleAgendaItem(item, this, wm);
        }
        this.scheduledActivations.add(item);
    }

    private void addItemToActivationGroup(AgendaItem item) {
        String group = item.getRule().getActivationGroup();
        if (group != null && group.length() > 0) {
            this.getActivationGroup(group).addActivation(item);
        }
    }

    public ActivationGroup getStageActivationsGroup() {
        if (this.stagedActivations == null) {
            this.stagedActivations = new ActivationGroupImpl("staged activations");
        }
        return this.stagedActivations;
    }

    @Override
    public boolean addActivation(AgendaItem activation) {
        if (this.declarativeAgenda) {
            if (this.activationObjectTypeConf == null) {
                EntryPoint ep = this.workingMemory.getEntryPoint();
                this.activationObjectTypeConf = ((InternalWorkingMemoryEntryPoint)((Object)this.workingMemory.getWorkingMemoryEntryPoint(ep.getEntryPointId()))).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, activation);
            }
            InternalFactHandle factHandle = this.workingMemory.getFactHandleFactory().newFactHandle(activation, this.activationObjectTypeConf, this.workingMemory, this.workingMemory);
            this.workingMemory.getEntryPointNode().assertActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
            activation.setFactHandle(factHandle);
            if (!activation.isCanceled() && (activation.getBlockers() == null || activation.getBlockers().isEmpty())) {
                this.getStageActivationsGroup().addActivation(activation);
            }
            return true;
        }
        this.addActivation(activation, true);
        return true;
    }

    public void setActiveActivations(int activeActivations) {
        this.activeActivations = activeActivations;
    }

    public void setDormantActivations(int dormantActivations) {
        this.dormantActivations = dormantActivations;
    }

    @Override
    public boolean isDeclarativeAgenda() {
        return this.declarativeAgenda;
    }

    @Override
    public void removeActivation(AgendaItem activation) {
        if (this.declarativeAgenda) {
            this.workingMemory.getEntryPointNode().retractActivation(activation.getFactHandle(), activation.getPropagationContext(), this.workingMemory);
            if (activation.getActivationGroupNode() != null && activation.getActivationGroupNode() == activation.getActivationGroupNode().getActivationGroup()) {
                activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
            }
        }
    }

    @Override
    public void modifyActivation(AgendaItem activation, boolean previouslyActive) {
        if (this.declarativeAgenda) {
            InternalFactHandle factHandle = activation.getFactHandle();
            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
            if (previouslyActive) {
                return;
            }
            if (activation.isCanceled() || activation.getBlockers() != null && activation.getBlockers().size() > 0) {
                return;
            }
            ActivationGroup activationGroup = this.getStageActivationsGroup();
            if (activation.getActivationGroupNode() != null && activation.getActivationGroupNode().getActivationGroup() == activationGroup) {
                return;
            }
            activationGroup.addActivation(activation);
        } else if (!previouslyActive) {
            this.addActivation(activation, true);
        }
    }

    public void clearAndCancelStagedActivations() {
        if (this.getStageActivationsGroup().isEmpty()) {
            return;
        }
        LinkedList list = this.getStageActivationsGroup().getList();
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        LinkedListNode entry = list.removeFirst();
        while (entry != null) {
            ActivationGroupNode node = (ActivationGroupNode)entry;
            AgendaItem item = (AgendaItem)node.getActivation();
            item.setActivated(false);
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.CLEAR);
            entry = list.removeFirst();
        }
    }

    @Override
    public void unstageActivations() {
        if (!this.declarativeAgenda || this.getStageActivationsGroup().isEmpty()) {
            return;
        }
        LinkedList list = this.getStageActivationsGroup().getList();
        LinkedListNode entry = list.removeFirst();
        while (entry != null) {
            ActivationGroupNode node = (ActivationGroupNode)entry;
            AgendaItem item = (AgendaItem)node.getActivation();
            item.setActivationGroupNode(null);
            this.addActivation(item, false);
            entry = list.removeFirst();
        }
        this.notifyHalt();
    }

    private void addActivation(AgendaItem item, boolean notify) {
        Rule rule = item.getRule();
        if (rule.getAutoFocus()) {
            this.setFocus(item.getPropagationContext(), rule.getAgendaGroup());
        }
        this.addItemToActivationGroup(item);
        Timer timer = rule.getTimer();
        if (timer != null) {
            this.scheduleItem((ScheduledAgendaItem)item, this.workingMemory);
        } else {
            AgendaItem agendaItem = item;
            InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(rule.getAgendaGroup());
            if (agendaItem.getRule().getRuleFlowGroup() == null) {
                agendaGroup.add(agendaItem);
            } else {
                InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(rule.getRuleFlowGroup());
                rfg.addActivation(agendaItem);
            }
        }
        if (notify) {
            if (this.isFiringActivation) {
                this.mustNotifyHalt = true;
            } else {
                this.notifyHalt();
            }
        }
    }

    @Override
    public void removeScheduleItem(ScheduledAgendaItem item) {
        this.scheduledActivations.remove(item);
        Scheduler.removeAgendaItem(item, this);
    }

    @Override
    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), (InternalAgendaGroup)agendaGroup);
    }

    @Override
    public boolean createActivation(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, RuleTerminalNode rtn, boolean reuseActivation) {
        AgendaItem item;
        if (rtn.isFireDirect()) {
            AgendaItem item2;
            if (reuseActivation) {
                item2 = (AgendaItem)tuple.getObject();
                item2.setPropagationContext(context);
            } else {
                item2 = this.createAgendaItem(tuple, 0, context, rtn);
            }
            tuple.setObject(item2);
            if (this.activationsFilter != null && !this.activationsFilter.accept(item2, context, workingMemory, rtn)) {
                return false;
            }
            item2.setActivated(true);
            tuple.increaseActivationCountForEvents();
            this.increaseActiveActivations();
            this.fireActivation(item2);
            return true;
        }
        Rule rule = rtn.getRule();
        Timer timer = rule.getTimer();
        if (timer != null) {
            if (reuseActivation) {
                item = (AgendaItem)tuple.getObject();
                item.setPropagationContext(context);
            } else {
                item = this.createScheduledAgendaItem(tuple, context, rtn);
            }
        } else {
            if (rule.getCalendars() != null) {
                long timestamp = workingMemory.getSessionClock().getCurrentTime();
                for (String cal : rule.getCalendars()) {
                    if (workingMemory.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                    return false;
                }
            }
            InternalAgendaGroup agendaGroup = (InternalAgendaGroup)this.getAgendaGroup(rule.getAgendaGroup());
            if (rule.getRuleFlowGroup() == null) {
                if (rule.isLockOnActive() && agendaGroup.isActive() && agendaGroup.getAutoFocusActivator() != context) {
                    if (tuple.getObject() == null) {
                        tuple.setObject(Boolean.TRUE);
                    }
                    return false;
                }
            } else {
                InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(rule.getRuleFlowGroup());
                if (rule.isLockOnActive() && rfg.isActive() && agendaGroup.getAutoFocusActivator() != context) {
                    if (tuple.getObject() == null) {
                        tuple.setObject(Boolean.TRUE);
                    }
                    return false;
                }
            }
            if (reuseActivation) {
                item = (AgendaItem)tuple.getObject();
                item.setSalience(rule.getSalience().getValue(new DefaultKnowledgeHelper(item, workingMemory), rule, workingMemory));
                item.setPropagationContext(context);
            } else {
                item = this.createAgendaItem(tuple, 0, context, rtn);
                item.setSalience(rule.getSalience().getValue(new DefaultKnowledgeHelper(item, workingMemory), rule, workingMemory));
            }
            item.setAgendaGroup(agendaGroup);
        }
        tuple.setObject(item);
        if (this.activationsFilter != null && !this.activationsFilter.accept(item, context, workingMemory, rtn)) {
            this.increaseDormantActivations();
            return false;
        }
        item.setActivated(true);
        tuple.increaseActivationCountForEvents();
        this.increaseActiveActivations();
        item.setSequenence(rtn.getSequence());
        ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCreated(item, workingMemory);
        return true;
    }

    @Override
    public void cancelActivation(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, org.drools.spi.Activation activation, RuleTerminalNode rtn) {
        AgendaItem item = (AgendaItem)activation;
        item.cancel();
        item.removeAllBlockersAndBlocked(this);
        if (this.isDeclarativeAgenda() && activation.getFactHandle() == null) {
            this.decreaseDormantActivations();
            return;
        }
        this.removeActivation((AgendaItem)activation);
        if (activation.isActivated()) {
            if (context.getType() != 5 || context.getFactHandleOrigin() == null) {
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                if (activation.getActivationNode() != null) {
                    InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)activation.getActivationNode().getParentContainer();
                    ruleFlowGroup.removeActivation(activation);
                }
                leftTuple.decreaseActivationCountForEvents();
                ((EventSupport)((Object)workingMemory)).getAgendaEventSupport().fireActivationCancelled(activation, workingMemory, ActivationCancelledCause.WME_MODIFY);
                this.decreaseActiveActivations();
            }
        } else {
            this.decreaseDormantActivations();
        }
        workingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, context, rtn.getRule());
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            ((InternalAgendaGroup)this.focusStack.getLast()).setActive(false);
            this.focusStack.add(agendaGroup);
            ((InternalAgendaGroup)agendaGroup).setActive(true);
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPushed(agendaGroup, this.workingMemory);
            return true;
        }
        return false;
    }

    @Override
    public void setFocus(String name) {
        this.setFocus(null, name);
    }

    public void setFocus(PropagationContext ctx, String name) {
        AgendaGroup agendaGroup = this.getAgendaGroup(name);
        agendaGroup.setAutoFocusActivator(ctx);
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return this.focusStack.getLast();
    }

    public AgendaGroup getNextFocus() {
        boolean empty;
        InternalAgendaGroup agendaGroup = null;
        while ((empty = (agendaGroup = (InternalAgendaGroup)this.focusStack.getLast()).isEmpty()) && this.focusStack.size() > 1) {
            agendaGroup.setActive(false);
            this.focusStack.removeLast();
            EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
            eventsupport.getAgendaEventSupport().fireAgendaGroupPopped(agendaGroup, this.workingMemory);
        }
        agendaGroup = empty ? null : agendaGroup;
        if (agendaGroup != null) {
            agendaGroup.setActive(true);
        }
        return agendaGroup;
    }

    public void setCurrentAgendaGroup(InternalAgendaGroup agendaGroup) {
        this.currentModule = agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    @Override
    public AgendaGroup getAgendaGroup(String name) {
        return this.getAgendaGroup(name, this.workingMemory == null ? null : (InternalRuleBase)this.workingMemory.getRuleBase());
    }

    public AgendaGroup getAgendaGroup(String name, InternalRuleBase ruleBase) {
        String groupName = name == null || name.length() == 0 ? "MAIN" : name;
        AgendaGroup agendaGroup = this.agendaGroups.get(groupName);
        if (agendaGroup == null) {
            agendaGroup = this.agendaGroupFactory.createAgendaGroup(name, ruleBase);
            this.addAgendaGroup(agendaGroup);
        }
        return agendaGroup;
    }

    @Override
    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public Map<String, InternalAgendaGroup> getAgendaGroupsMap() {
        return this.agendaGroups;
    }

    public InternalAgendaGroup getMainAgendaGroup() {
        if (this.main == null) {
            this.main = (InternalAgendaGroup)this.getAgendaGroup("MAIN");
        }
        return this.main;
    }

    @Override
    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public java.util.LinkedList<AgendaGroup> getStackList() {
        return this.focusStack;
    }

    public void addAgendaGroupOnStack(AgendaGroup agendaGroup) {
        if (this.focusStack.isEmpty() || this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
        }
    }

    public Map<String, RuleFlowGroup> getRuleFlowGroupsMap() {
        return this.ruleFlowGroups;
    }

    public Map<String, ActivationGroup> getActivationGroupsMap() {
        return this.activationGroups;
    }

    @Override
    public ActivationGroup getActivationGroup(String name) {
        ActivationGroupImpl activationGroup = (ActivationGroupImpl)this.activationGroups.get(name);
        if (activationGroup == null) {
            activationGroup = new ActivationGroupImpl(name);
            this.activationGroups.put(name, activationGroup);
        }
        return activationGroup;
    }

    @Override
    public RuleFlowGroup getRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGroup = this.ruleFlowGroups.get(name);
        if (ruleFlowGroup == null) {
            ruleFlowGroup = new RuleFlowGroupImpl(name);
            ((InternalRuleFlowGroup)ruleFlowGroup).setWorkingMemory((InternalWorkingMemory)this.getWorkingMemory());
            this.ruleFlowGroups.put(name, ruleFlowGroup);
        }
        return ruleFlowGroup;
    }

    @Override
    public void activateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(true);
    }

    @Override
    public void activateRuleFlowGroup(String name, long processInstanceId, String nodeInstanceId) {
        InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)this.getRuleFlowGroup(name);
        ruleFlowGroup.addNodeInstance(processInstanceId, nodeInstanceId);
        ruleFlowGroup.setActive(true);
    }

    @Override
    public void deactivateRuleFlowGroup(String name) {
        ((InternalRuleFlowGroup)this.getRuleFlowGroup(name)).setActive(false);
    }

    @Override
    public int focusStackSize() {
        int size = 0;
        for (AgendaGroup group : this.focusStack) {
            size += group.size();
        }
        return size;
    }

    @Override
    public int agendaSize() {
        int size = 0;
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            size += agendaGroup.size();
        }
        return size;
    }

    @Override
    public org.drools.spi.Activation[] getActivations() {
        ArrayList<org.drools.spi.Activation> list = new ArrayList<org.drools.spi.Activation>();
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            for (Activation activation : agendaGroup.getActivations()) {
                list.add((org.drools.spi.Activation)activation);
            }
        }
        return list.toArray(new org.drools.spi.Activation[list.size()]);
    }

    @Override
    public org.drools.spi.Activation[] getScheduledActivations() {
        org.drools.spi.Activation[] scheduledActivations = new org.drools.spi.Activation[this.scheduledActivations.size()];
        int i = 0;
        for (LinkedListNode node = this.scheduledActivations.getFirst(); node != null; node = node.getNext()) {
            scheduledActivations[i++] = (org.drools.spi.Activation)((Object)node);
        }
        return scheduledActivations;
    }

    @Override
    public LinkedList getScheduledActivationsLinkedList() {
        return this.scheduledActivations;
    }

    @Override
    public void clear() {
        this.focusStack.clear();
        this.focusStack.add(this.getMainAgendaGroup());
        if (!this.scheduledActivations.isEmpty()) {
            ScheduledAgendaItem item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (item != null) {
                Scheduler.removeAgendaItem(item, this);
                item = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        this.getStageActivationsGroup().clear();
        for (InternalAgendaGroup internalAgendaGroup : this.agendaGroups.values()) {
            internalAgendaGroup.clear();
        }
        for (RuleFlowGroup ruleFlowGroup : this.ruleFlowGroups.values()) {
            ruleFlowGroup.clear();
        }
        for (ActivationGroup activationGroup : this.activationGroups.values()) {
            activationGroup.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearAndCancel() {
        for (AgendaGroup agendaGroup : this.agendaGroups.values()) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        if (!this.scheduledActivations.isEmpty()) {
            void var2_4;
            ScheduledAgendaItem scheduledAgendaItem = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (var2_4 != null) {
                Scheduler.removeAgendaItem((ScheduledAgendaItem)var2_4, this);
                eventsupport.getAgendaEventSupport().fireActivationCancelled((org.drools.spi.Activation)var2_4, this.workingMemory, ActivationCancelledCause.CLEAR);
                ScheduledAgendaItem scheduledAgendaItem2 = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
        this.clearAndCancelStagedActivations();
        for (RuleFlowGroup ruleFlowGroup : this.ruleFlowGroups.values()) {
            this.clearAndCancelAndCancel(ruleFlowGroup);
        }
        for (ActivationGroup activationGroup : this.activationGroups.values()) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(String name) {
        AgendaGroup agendaGroup = this.agendaGroups.get(name);
        if (agendaGroup != null) {
            this.clearAndCancelAgendaGroup(agendaGroup);
        }
    }

    @Override
    public void clearAndCancelAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        for (org.drools.spi.Activation aQueueable : ((InternalAgendaGroup)agendaGroup).getAndClear()) {
            AgendaItem item = (AgendaItem)aQueueable;
            if (item == null) continue;
            item.setActivated(false);
            if (item.getActivationGroupNode() != null) {
                item.getActivationGroupNode().getActivationGroup().removeActivation(item);
            }
            if (item.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)item.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(item);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(String name) {
        ActivationGroup activationGroup = this.activationGroups.get(name);
        if (activationGroup != null) {
            this.clearAndCancelActivationGroup(activationGroup);
        }
    }

    @Override
    public void clearAndCancelActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        Iterator it = activationGroup.iterator();
        while (it.hasNext()) {
            ActivationGroupNode node = (ActivationGroupNode)it.next();
            org.drools.spi.Activation activation = node.getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isActivated()) continue;
            activation.setActivated(false);
            activation.remove();
            if (activation.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)activation.getActivationNode().getParentContainer();
                ruleFlowGroup.removeActivation(activation);
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(activation, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
        activationGroup.clear();
    }

    @Override
    public void clearAndCancelRuleFlowGroup(String name) {
        RuleFlowGroup ruleFlowGrlup = this.ruleFlowGroups.get(name);
        if (ruleFlowGrlup != null) {
            this.clearAndCancelAndCancel(ruleFlowGrlup);
        }
    }

    @Override
    public void clearAndCancelAndCancel(RuleFlowGroup ruleFlowGroup) {
        EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
        for (ActivationNode node : ruleFlowGroup) {
            AgendaItem item = (AgendaItem)node.getActivation();
            if (item != null) {
                item.setActivated(false);
                item.remove();
                if (item.getActivationGroupNode() != null) {
                    item.getActivationGroupNode().getActivationGroup().removeActivation(item);
                }
            }
            eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.CLEAR);
        }
        ((InternalRuleFlowGroup)ruleFlowGroup).clear();
        if (ruleFlowGroup.isActive() && ruleFlowGroup.isAutoDeactivate()) {
            RuleFlowGroupImpl.DeactivateCallback action = new RuleFlowGroupImpl.DeactivateCallback((InternalRuleFlowGroup)ruleFlowGroup);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fireNextItem(AgendaFilter filter) throws ConsequenceException {
        boolean result;
        try {
            boolean tryagain;
            do {
                AgendaItem item;
                this.workingMemory.prepareToFireActivation();
                result = false;
                tryagain = false;
                InternalAgendaGroup group = (InternalAgendaGroup)this.getNextFocus();
                if (group == null || (item = (AgendaItem)group.getNext()) == null) continue;
                InternalRuleFlowGroup ruleFlowGroup = null;
                if (item.getActivationNode() != null) {
                    ruleFlowGroup = (InternalRuleFlowGroup)item.getActivationNode().getParentContainer();
                    ruleFlowGroup.removeActivation(item);
                }
                try {
                    if (filter == null || filter.accept(item)) {
                        this.fireActivation(item);
                        result = true;
                        continue;
                    }
                    this.workingMemory.executeQueuedActions();
                    EventSupport eventsupport = (EventSupport)((Object)this.workingMemory);
                    eventsupport.getAgendaEventSupport().fireActivationCancelled(item, this.workingMemory, ActivationCancelledCause.FILTER);
                    tryagain = true;
                }
                finally {
                    if (ruleFlowGroup != null) {
                        ruleFlowGroup.deactivateIfEmpty();
                        this.workingMemory.executeQueuedActions();
                    }
                }
            } while (tryagain);
        }
        finally {
            this.workingMemory.activationFired();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void fireActivation(org.drools.spi.Activation activation) throws ConsequenceException {
        this.workingMemory.startOperation();
        this.isFiringActivation = true;
        try {
            EventSupport eventsupport;
            block19: {
                this.increaseDormantActivations();
                this.decreaseActiveActivations();
                eventsupport = (EventSupport)((Object)this.workingMemory);
                eventsupport.getAgendaEventSupport().fireBeforeActivationFired(activation, this.workingMemory);
                if (activation.getActivationGroupNode() != null) {
                    ActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                    activationGroup.removeActivation(activation);
                    this.clearAndCancelActivationGroup(activationGroup);
                }
                activation.setActivated(false);
                try {
                    try {
                        this.knowledgeHelper.setActivation(activation);
                        activation.getRule().getConsequence().evaluate(this.knowledgeHelper, this.workingMemory);
                        this.knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
                        this.knowledgeHelper.reset();
                    }
                    catch (Exception e) {
                        if (this.legacyConsequenceExceptionHandler != null) {
                            this.legacyConsequenceExceptionHandler.handleException(activation, this.workingMemory, e);
                        } else {
                            if (this.consequenceExceptionHandler == null) throw new RuntimeException(e);
                            this.consequenceExceptionHandler.handleException(activation, this.workingMemory.getKnowledgeRuntime(), e);
                        }
                        Object var5_6 = null;
                        if (activation.getFactHandle() != null) {
                            InternalFactHandle factHandle = activation.getFactHandle();
                            this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                            activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                        }
                        for (LeftTuple tuple = activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
                            if (!tuple.getLastHandle().isEvent()) continue;
                            EventFactHandle handle = (EventFactHandle)tuple.getLastHandle();
                            handle.decreaseActivationsCount();
                            if (!handle.isExpired() || handle.getActivationsCount() > 0L) continue;
                            handle.getEntryPoint().retract(handle);
                        }
                        break block19;
                    }
                    Object var5_5 = null;
                    if (activation.getFactHandle() != null) {
                        InternalFactHandle factHandle = activation.getFactHandle();
                        this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                        activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (activation.getFactHandle() != null) {
                        InternalFactHandle factHandle = activation.getFactHandle();
                        this.workingMemory.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), this.workingMemory);
                        activation.getPropagationContext().evaluateActionQueue(this.workingMemory);
                    }
                    LeftTuple tuple = activation.getTuple();
                    while (tuple != null) {
                        if (tuple.getLastHandle().isEvent()) {
                            EventFactHandle handle = (EventFactHandle)tuple.getLastHandle();
                            handle.decreaseActivationsCount();
                            if (handle.isExpired() && handle.getActivationsCount() <= 0L) {
                                handle.getEntryPoint().retract(handle);
                            }
                        }
                        tuple = tuple.getParent();
                    }
                    throw throwable;
                }
                for (LeftTuple tuple = activation.getTuple(); tuple != null; tuple = tuple.getParent()) {
                    if (!tuple.getLastHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getLastHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.isExpired() || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint().retract(handle);
                }
            }
            eventsupport.getAgendaEventSupport().fireAfterActivationFired(activation, this.workingMemory);
            this.unstageActivations();
            Object var9_15 = null;
            this.isFiringActivation = false;
            if (this.mustNotifyHalt) {
                this.mustNotifyHalt = false;
                this.notifyHalt();
            }
            this.workingMemory.endOperation();
            return;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            this.isFiringActivation = false;
            if (this.mustNotifyHalt) {
                this.mustNotifyHalt = false;
                this.notifyHalt();
            }
            this.workingMemory.endOperation();
            throw throwable;
        }
    }

    @Override
    public void increaseActiveActivations() {
        ++this.activeActivations;
    }

    @Override
    public void decreaseActiveActivations() {
        --this.activeActivations;
    }

    @Override
    public void increaseDormantActivations() {
        ++this.dormantActivations;
    }

    @Override
    public void decreaseDormantActivations() {
        --this.dormantActivations;
    }

    @Override
    public int getActiveActivations() {
        return this.activeActivations;
    }

    @Override
    public int getDormantActivations() {
        return this.dormantActivations;
    }

    @Override
    public boolean isRuleActiveInRuleFlowGroup(String ruleflowGroupName, String ruleName, long processInstanceId) {
        RuleFlowGroup systemRuleFlowGroup = this.getRuleFlowGroup(ruleflowGroupName);
        for (ActivationNode aSystemRuleFlowGroup : systemRuleFlowGroup) {
            org.drools.spi.Activation activation = aSystemRuleFlowGroup.getActivation();
            if (!ruleName.equals(activation.getRule().getName()) || !this.checkProcessInstance(activation, processInstanceId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkProcessInstance(org.drools.spi.Activation activation, long processInstanceId) {
        Map<String, Declaration> declarations = activation.getSubRule().getOuterDeclarations();
        for (Declaration declaration : declarations.values()) {
            Object value;
            if (!"processInstance".equals(declaration.getIdentifier()) || !((value = declaration.getValue(this.workingMemory, activation.getTuple().get(declaration).getObject())) instanceof ProcessInstance)) continue;
            return ((ProcessInstance)value).getId() == processInstanceId;
        }
        return true;
    }

    @Override
    public void addRuleFlowGroupListener(String ruleFlowGroup, RuleFlowGroupListener listener) {
        InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(ruleFlowGroup);
        rfg.addRuleFlowGroupListener(listener);
    }

    @Override
    public void removeRuleFlowGroupListener(String ruleFlowGroup, RuleFlowGroupListener listener) {
        InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)this.getRuleFlowGroup(ruleFlowGroup);
        rfg.removeRuleFlowGroupListener(listener);
    }

    @Override
    public String getFocusName() {
        return this.getFocus().getName();
    }

    @Override
    public void fireUntilHalt() {
        this.fireUntilHalt(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.unstageActivations();
        this.halt.set(false);
        while (this.continueFiring(-1)) {
            boolean fired = this.fireNextItem(agendaFilter);
            fired = fired || !((AbstractWorkingMemory)this.workingMemory).getActionQueue().isEmpty();
            this.workingMemory.executeQueuedActions();
            if (!fired) {
                try {
                    AtomicBoolean atomicBoolean = this.halt;
                    synchronized (atomicBoolean) {
                        if (!this.halt.get()) {
                            this.halt.wait();
                        }
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    this.halt.set(true);
                    continue;
                }
            }
            this.workingMemory.executeQueuedActions();
        }
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int fireLimit) {
        this.unstageActivations();
        this.halt.set(false);
        int fireCount = 0;
        while (this.continueFiring(fireLimit) && this.fireNextItem(agendaFilter)) {
            ++fireCount;
            fireLimit = this.updateFireLimit(fireLimit);
            this.workingMemory.executeQueuedActions();
        }
        if (this.focusStack.size() == 1 && this.getMainAgendaGroup().isEmpty()) {
            this.getMainAgendaGroup().setActive(false);
        }
        return fireCount;
    }

    private boolean continueFiring(int fireLimit) {
        return !this.halt.get() && fireLimit != 0;
    }

    private final int updateFireLimit(int fireLimit) {
        return fireLimit > 0 ? fireLimit - 1 : fireLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyHalt() {
        AtomicBoolean atomicBoolean = this.halt;
        synchronized (atomicBoolean) {
            this.halt.notifyAll();
        }
    }

    @Override
    public void halt() {
        this.halt.set(true);
        this.notifyHalt();
    }

    @Override
    public boolean isHalted() {
        return this.halt.get();
    }

    public org.drools.spi.ConsequenceExceptionHandler getConsequenceExceptionHandler() {
        return this.legacyConsequenceExceptionHandler;
    }

    @Override
    public void setActivationsFilter(ActivationsFilter filter) {
        this.activationsFilter = filter;
    }

    @Override
    public ActivationsFilter getActivationsFilter() {
        return this.activationsFilter;
    }
}

