/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.widget.AbstractDecisionTableWidget;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableControlsWidget;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.util.GWTDateConverter;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.HasColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.HasRows;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSystemControlledColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.data.Coordinate;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.data.GroupedDynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDecisionTableWidget
extends Composite
implements HasRows,
HasColumns<DTColumnConfig>,
HasSystemControlledColumns {
    protected TypeSafeGuidedDecisionTable model;
    protected DecoratedGridWidget<DTColumnConfig> widget;
    protected SuggestionCompletionEngine sce;
    protected DecisionTableCellFactory cellFactory;
    protected DecisionTableCellValueFactory cellValueFactory;
    protected DecisionTableControlsWidget dtableCtrls;

    public AbstractDecisionTableWidget(DecisionTableControlsWidget dtableCtrls, SuggestionCompletionEngine sce) {
        if (dtableCtrls == null) {
            throw new IllegalArgumentException("dtableControls cannot be null");
        }
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.sce = sce;
        this.dtableCtrls = dtableCtrls;
        this.dtableCtrls.setDecisionTableWidget(this);
    }

    public void addColumn(DTColumnConfig modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.addColumn(modelColumn, true);
    }

    public void appendRow() {
        this.insertRowBefore(null);
    }

    public void deleteColumn(DTColumnConfig modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.deleteColumn(col);
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.widget.deleteRow(row);
        this.updateSystemControlledColumnValues();
        this.redrawSystemControlledColumns();
    }

    public TypeSafeGuidedDecisionTable getModel() {
        return this.model;
    }

    public SuggestionCompletionEngine getSCE() {
        return this.sce;
    }

    public void insertRowBefore(DynamicDataRow rowBefore) {
        List rowData = this.makeRowData();
        this.widget.insertRowBefore(rowBefore, rowData);
        this.redrawSystemControlledColumns();
    }

    public void makeOtherwiseCell() {
        MergableGridWidget grid = this.widget.getGridWidget();
        List selections = grid.getSelectedCells();
        CellValue cell = (CellValue)selections.get(0);
        if (this.canAcceptOtherwiseValues(cell)) {
            for (CellValue cv : selections) {
                cv.addState(CellValue.CellState.OTHERWISE);
            }
            grid.update(null);
        }
    }

    public void redrawSystemControlledColumns() {
        this.widget.redrawSystemControlledColumns();
    }

    public void scrapeColumns() {
        this.model.getMetadataCols().clear();
        this.model.getAttributeCols().clear();
        this.model.getConditionCols().clear();
        this.model.getActionCols().clear();
        RowNumberCol rnCol = null;
        DescriptionCol descCol = null;
        for (DynamicColumn column : this.widget.getGridWidget().getColumns()) {
            MetadataCol tc;
            DTColumnConfig modelCol = (DTColumnConfig)column.getModelColumn();
            if (modelCol instanceof RowNumberCol) {
                rnCol = (RowNumberCol)modelCol;
                this.model.setRowNumberCol(rnCol);
            } else if (modelCol instanceof DescriptionCol) {
                descCol = (DescriptionCol)modelCol;
                this.model.setDescriptionCol(descCol);
            } else if (modelCol instanceof MetadataCol) {
                tc = (MetadataCol)modelCol;
                this.model.getMetadataCols().add(tc);
            } else if (modelCol instanceof AttributeCol) {
                tc = (AttributeCol)modelCol;
                this.model.getAttributeCols().add(tc);
            } else if (modelCol instanceof ConditionCol) {
                tc = (ConditionCol)modelCol;
                this.model.getConditionCols().add(tc);
            } else if (modelCol instanceof ActionCol) {
                tc = (ActionCol)modelCol;
                this.model.getActionCols().add(tc);
            }
            modelCol.setWidth(column.getWidth());
            modelCol.setHideColumn(!column.isVisible());
        }
    }

    public void scrapeData() {
        DynamicData data = this.widget.getGridWidget().getData().getFlattenedData();
        List columns = this.widget.getGridWidget().getColumns();
        int GRID_ROWS = data.size();
        ArrayList grid = new ArrayList();
        for (int iRow = 0; iRow < GRID_ROWS; ++iRow) {
            DynamicDataRow dataRow = data.get(iRow);
            ArrayList<DTCellValue> row = new ArrayList<DTCellValue>();
            for (int iCol = 0; iCol < columns.size(); ++iCol) {
                CellValue cv = dataRow.get(iCol);
                DTColumnConfig column = (DTColumnConfig)((DynamicColumn)columns.get(iCol)).getModelColumn();
                DTCellValue dcv = this.cellValueFactory.convertToDTModelCell(column, cv);
                dcv.setOtherwise(cv.isOtherwise());
                row.add(dcv);
            }
            grid.add(row);
        }
        this.model.setData(grid);
    }

    public void setColumnVisibility(DTColumnConfig modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.setColumnVisibility(col.getColumnIndex(), isVisible);
    }

    public void setModel(TypeSafeGuidedDecisionTable model) {
        DynamicColumn column;
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.cellFactory = new DecisionTableCellFactory(this.sce, this.widget.getGridWidget(), this.model);
        this.cellValueFactory = new DecisionTableCellValueFactory(this.sce, this.model);
        DecisionTableCellValueFactory.injectDateConvertor((DateConverter)GWTDateConverter.getInstance());
        this.widget.getGridWidget().getData().setOnRowChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.widget.getGridWidget().getData().clear();
        this.widget.getGridWidget().getColumns().clear();
        DynamicData data = this.widget.getGridWidget().getData();
        for (int iRow = 0; iRow < model.getData().size(); ++iRow) {
            data.addRow();
        }
        int colIndex = 0;
        RowNumberCol colStatic = model.getRowNumberCol();
        DynamicColumn columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig)colStatic), colIndex, true, false);
        columnStatic.setWidth(24);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig)colStatic, colIndex++), false);
        colStatic = model.getDescriptionCol();
        columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig)colStatic), colIndex);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig)colStatic, colIndex++), false);
        for (MetadataCol col : model.getMetadataCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        for (MetadataCol col : model.getAttributeCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            column.setSystemControlled(col.isUseRowNumber());
            column.setSortable(!col.isUseRowNumber());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        this.assertConditionColumnGrouping(model);
        for (MetadataCol col : model.getConditionCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
            ConditionCol cc = (ConditionCol)col;
            cc.setFieldType(this.sce.getFieldType(cc.getFactType(), cc.getFactField()));
        }
        for (MetadataCol col : model.getActionCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        this.updateSystemControlledColumnValues();
        this.widget.getHeaderWidget().redraw();
        this.widget.getSidebarWidget().redraw();
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void updateColumn(ActionInsertFactCol origColumn, ActionInsertFactCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                this.updateCellsForDataType((DTColumnConfig)editColumn, column);
            }
        } else if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(ActionSetFieldCol origColumn, ActionSetFieldCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                this.updateCellsForDataType((DTColumnConfig)editColumn, column);
            }
        } else if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(ConditionCol origColumn, ConditionCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getOperator(), editColumn.getOperator())) {
            bRedrawHeader = true;
            if (!this.canAcceptOtherwiseValues((DTColumnConfig)editColumn)) {
                this.removeOtherwiseStates(column);
                bRedrawColumn = true;
            }
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            bRedrawHeader = true;
            this.addColumn((DTColumnConfig)editColumn, false);
            DynamicColumn origCol = this.getDynamicColumn((DTColumnConfig)origColumn);
            DynamicColumn editCol = this.getDynamicColumn((DTColumnConfig)editColumn);
            int origColIndex = this.widget.getGridWidget().getColumns().indexOf(origCol);
            int editColIndex = this.widget.getGridWidget().getColumns().indexOf(editCol);
            if (this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType()) {
                DynamicData data = this.widget.getGridWidget().getData();
                for (int iRow = 0; iRow < data.size(); ++iRow) {
                    DynamicDataRow row = data.get(iRow);
                    CellValue oldCell = row.get(origColIndex);
                    CellValue newCell = row.get(editColIndex);
                    newCell.setValue((Object)oldCell.getValue());
                }
            }
            this.widget.deleteColumn(origCol);
            editColIndex = Math.min(this.widget.getGridWidget().getColumns().size() - 1, editColIndex);
            if (editColIndex > origColIndex) {
                int temp = origColIndex;
                origColIndex = editColIndex;
                editColIndex = temp;
            }
            this.widget.getGridWidget().redrawColumns(editColIndex, origColIndex);
        } else if (!(this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && this.isEqualOrNull(origColumn.getFieldType(), editColumn.getFieldType()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType())) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            int maxColumnIndex = this.widget.getGridWidget().getColumns().size() - 1;
            this.widget.getGridWidget().redrawColumns(column.getColumnIndex(), maxColumnIndex);
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateSystemControlledColumnValues() {
        DynamicData data = this.widget.getGridWidget().getData();
        List columns = this.widget.getGridWidget().getColumns();
        for (DynamicColumn col : columns) {
            AttributeCol attrCol;
            DTColumnConfig modelColumn = (DTColumnConfig)col.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                this.updateRowNumberColumnValues(data, col.getColumnIndex());
                continue;
            }
            if (!(modelColumn instanceof AttributeCol) || !(attrCol = (AttributeCol)modelColumn).getAttribute().equals("salience")) continue;
            if (attrCol.isUseRowNumber()) {
                this.updateSalienceColumnValues(data, col.getColumnIndex(), attrCol.isReverseOrder());
            }
            col.setCell(this.cellFactory.getCell((DTColumnConfig)attrCol));
            col.setSystemControlled(attrCol.isUseRowNumber());
            col.setSortable(!attrCol.isUseRowNumber());
        }
    }

    private void addColumn(DTColumnConfig modelColumn, boolean bRedraw) {
        int index = 0;
        if (modelColumn instanceof MetadataCol) {
            index = this.findMetadataColumnIndex();
        } else if (modelColumn instanceof AttributeCol) {
            index = this.findAttributeColumnIndex();
        } else if (modelColumn instanceof ConditionCol) {
            index = this.findConditionColumnIndex((ConditionCol)modelColumn);
        } else if (modelColumn instanceof ActionCol) {
            index = this.findActionColumnIndex();
        }
        this.insertColumnBefore(modelColumn, index, bRedraw);
    }

    private void assertConditionColumnGrouping(TypeSafeGuidedDecisionTable model) {
        List row;
        int iRow;
        int colIndex;
        int iCol;
        int DATA_COLUMN_OFFSET = model.getMetadataCols().size() + model.getAttributeCols().size() + 2;
        HashMap groups = new HashMap();
        int DATA_ROWS = model.getData().size();
        for (iCol = 0; iCol < model.getConditionCols().size(); ++iCol) {
            List<ConditionColData> groupCols;
            ConditionCol col = (ConditionCol)model.getConditionCols().get(iCol);
            String pattern = col.getBoundName();
            if (!groups.containsKey(pattern)) {
                groupCols = new ArrayList();
                groups.put(pattern, groupCols);
            }
            groupCols = (List)groups.get(pattern);
            ConditionColData ccd = new ConditionColData(this);
            colIndex = DATA_COLUMN_OFFSET + iCol;
            ccd.data = new DTCellValue[DATA_ROWS];
            for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                row = (List)model.getData().get(iRow);
                ccd.data[iRow] = (DTCellValue)row.get(colIndex);
            }
            ccd.col = col;
            groupCols.add(ccd);
        }
        iCol = 0;
        model.getConditionCols().clear();
        for (Map.Entry me : groups.entrySet()) {
            for (ConditionColData ccd : (List)me.getValue()) {
                model.getConditionCols().add(ccd.col);
                colIndex = DATA_COLUMN_OFFSET + iCol;
                for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                    row = (List)model.getData().get(iRow);
                    row.set(colIndex, ccd.data[iRow]);
                }
                ++iCol;
            }
        }
    }

    private boolean canAcceptOtherwiseValues(DTColumnConfig column) {
        if (!(column instanceof ConditionCol)) {
            return false;
        }
        ConditionCol cc = (ConditionCol)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    private int findActionColumnIndex() {
        int index = this.widget.getGridWidget().getColumns().size() - 1;
        return index;
    }

    private int findAttributeColumnIndex() {
        int index = 0;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof AttributeCol)) continue;
            index = iCol;
        }
        return index;
    }

    private int findConditionColumnIndex(ConditionCol col) {
        int index = 0;
        boolean bMatched = false;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof AttributeCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof ConditionCol)) continue;
            if (this.isEquivalentConditionColumn((ConditionCol)modelColumn, col)) {
                index = iCol;
                bMatched = true;
                continue;
            }
            if (bMatched) continue;
            index = iCol;
        }
        return index;
    }

    private int findMetadataColumnIndex() {
        int index = 0;
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof MetadataCol)) continue;
            index = iCol;
        }
        return index;
    }

    private DynamicColumn<DTColumnConfig> getDynamicColumn(DTColumnConfig modelCol) {
        DynamicColumn column = null;
        List columns = this.widget.getGridWidget().getColumns();
        for (DynamicColumn dc : columns) {
            if (!((DTColumnConfig)dc.getModelColumn()).equals((Object)modelCol)) continue;
            column = dc;
            break;
        }
        return column;
    }

    private void insertColumnBefore(DTColumnConfig modelColumn, int index, boolean bRedraw) {
        DynamicColumn column = new DynamicColumn((Object)modelColumn, this.cellFactory.getCell(modelColumn), index);
        column.setVisible(!modelColumn.isHideColumn());
        DynamicColumn columnBefore = (DynamicColumn)this.widget.getGridWidget().getColumns().get(index);
        DynamicData data = this.widget.getGridWidget().getData();
        ArrayList<CellValue> columnData = new ArrayList<CellValue>();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DTCellValue dcv = new DTCellValue(modelColumn.getDefaultValue());
            CellValue cell = this.cellValueFactory.makeCellValue(modelColumn, iRow, index, dcv);
            columnData.add(cell);
        }
        this.widget.insertColumnBefore(columnBefore, column, columnData, bRedraw);
    }

    private boolean isEqualOrNull(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    private boolean isEquivalentConditionColumn(ConditionCol c1, ConditionCol c2) {
        return this.isEqualOrNull(c1.getFactType(), c2.getFactType()) && this.isEqualOrNull(c1.getBoundName(), c2.getBoundName());
    }

    private List<CellValue<? extends Comparable<?>>> makeColumnData(DTColumnConfig column, int colIndex) {
        int dataSize = this.model.getData().size();
        ArrayList columnData = new ArrayList();
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            List row = (List)this.model.getData().get(iRow);
            DTCellValue dcv = (DTCellValue)row.get(colIndex);
            CellValue cv = this.cellValueFactory.makeCellValue(column, iRow, colIndex, dcv);
            columnData.add(cv);
        }
        return columnData;
    }

    private List<CellValue<? extends Comparable<?>>> makeRowData() {
        ArrayList rowData = new ArrayList();
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DTColumnConfig col = (DTColumnConfig)((DynamicColumn)columns.get(iCol)).getModelColumn();
            DTCellValue dcv = new DTCellValue(col.getDefaultValue());
            CellValue cv = this.cellValueFactory.makeCellValue(col, 0, iCol, dcv);
            rowData.add(cv);
        }
        return rowData;
    }

    private void populateModelColumn(ActionInsertFactCol col, ActionInsertFactCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setFactType(editingCol.getFactType());
        col.setInsertLogical(editingCol.isInsertLogical());
    }

    private void populateModelColumn(ActionSetFieldCol col, ActionSetFieldCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
    }

    private void populateModelColumn(ConditionCol col, ConditionCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setConstraintValueType(editingCol.getConstraintValueType());
        col.setFactField(editingCol.getFactField());
        col.setFactType(editingCol.getFactType());
        col.setFieldType(editingCol.getFieldType());
        col.setHeader(editingCol.getHeader());
        col.setOperator(editingCol.getOperator());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setNegated(editingCol.isNegated());
    }

    private void removeOtherwiseStates(DynamicColumn<DTColumnConfig> column) {
        if (this.widget.getGridWidget().getData().isMerged()) {
            this.widget.getGridWidget().toggleMerging();
        }
        DynamicData data = this.widget.getGridWidget().getData();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            CellValue cv = row.get(column.getColumnIndex());
            cv.removeState(CellValue.CellState.OTHERWISE);
        }
    }

    private void updateCellsForDataType(DTColumnConfig editColumn, DynamicColumn<DTColumnConfig> column) {
        if (this.widget.getGridWidget().getData().isMerged()) {
            this.widget.getGridWidget().toggleMerging();
        }
        DynamicData data = this.widget.getGridWidget().getData();
        column.setCell(this.cellFactory.getCell(editColumn));
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            row.set(column.getColumnIndex(), this.cellValueFactory.makeCellValue((Object)editColumn, iRow, column.getColumnIndex()));
        }
    }

    private boolean updateCellsForOptionValueList(DTColumnConfig editColumn, DynamicColumn<DTColumnConfig> column) {
        boolean bRedrawRequired = false;
        DynamicData data = this.widget.getGridWidget().getData();
        List<String> vals = Arrays.asList(this.model.getValueList(editColumn, this.sce));
        column.setCell(this.cellFactory.getCell(editColumn));
        int iCol = column.getColumnIndex();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            if (vals.contains(row.get(iCol).getValue())) continue;
            row.get(iCol).setValue(null);
            bRedrawRequired = true;
        }
        return bRedrawRequired;
    }

    private void updateRowNumberColumnValues(DynamicData data, int iCol) {
        int iRowNum = 1;
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = data.get(iRow);
            if (row instanceof GroupedDynamicDataRow) {
                GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                groupedRow.get(iCol).setValue((Object)new BigDecimal(iRowNum));
                for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                    ((DynamicDataRow)groupedRow.getChildRows().get(iGroupedRow)).get(iCol).setValue((Object)new BigDecimal(iRowNum));
                    ++iRowNum;
                }
                continue;
            }
            row.get(iCol).setValue((Object)new BigDecimal(iRowNum));
            ++iRowNum;
        }
    }

    private void updateSalienceColumnValues(DynamicData data, int iCol, boolean isReverseOrder) {
        if (!isReverseOrder) {
            this.updateRowNumberColumnValues(data, iCol);
        } else {
            int rowCount = 0;
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                DynamicDataRow row = data.get(iRow);
                if (row instanceof GroupedDynamicDataRow) {
                    GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                    rowCount += groupedRow.getChildRows().size();
                    continue;
                }
                ++rowCount;
            }
            int iRowNum = 0;
            for (int iRow = 0; iRow < data.size(); ++iRow) {
                DynamicDataRow row = data.get(iRow);
                if (row instanceof GroupedDynamicDataRow) {
                    GroupedDynamicDataRow groupedRow = (GroupedDynamicDataRow)row;
                    groupedRow.get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                    for (int iGroupedRow = 0; iGroupedRow < groupedRow.getChildRows().size(); ++iGroupedRow) {
                        ((DynamicDataRow)groupedRow.getChildRows().get(iGroupedRow)).get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                        ++iRowNum;
                    }
                    continue;
                }
                row.get(iCol).setValue((Object)new BigDecimal(rowCount - iRowNum));
                ++iRowNum;
            }
        }
    }

    protected boolean canAcceptOtherwiseValues(CellValue<?> cell) {
        Coordinate c = cell.getCoordinate();
        MergableGridWidget grid = this.widget.getGridWidget();
        DynamicColumn column = (DynamicColumn)grid.getColumns().get(c.getCol());
        return this.canAcceptOtherwiseValues((DTColumnConfig)column.getModelColumn());
    }
}

