/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.cell.client.AbstractCell;
import java.math.BigDecimal;
import org.drools.guvnor.client.decisiontable.cells.PopupDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.RowNumberCell;
import org.drools.guvnor.client.widgets.decoratedgrid.AbstractCellFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridCellValueAdaptor;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCellFactory
extends AbstractCellFactory<DTColumnConfig> {
    private static String[] DIALECTS = new String[]{"java", "mvel"};
    private TypeSafeGuidedDecisionTable model;

    public DecisionTableCellFactory(SuggestionCompletionEngine sce, MergableGridWidget<DTColumnConfig> grid, TypeSafeGuidedDecisionTable model) {
        super(sce, grid);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public DecoratedGridCellValueAdaptor<? extends Comparable<?>> getCell(DTColumnConfig column) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        if (column instanceof RowNumberCol) {
            cell = this.makeRowNumberCell();
        } else if (column instanceof AttributeCol) {
            AttributeCol attrCol = (AttributeCol)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                cell = attrCol.isUseRowNumber() ? this.makeRowNumberCell() : this.makeNumericCell();
            } else if (attrName.equals("enabled")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("no-loop")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("duration")) {
                cell = this.makeNumericCell();
            } else if (attrName.equals("auto-focus")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("lock-on-active")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("date-effective")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("date-expires")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("dialect")) {
                cell = this.makeDialectCell();
            } else if (attrName.equals("negate")) {
                cell = this.makeBooleanCell();
            }
        } else if (column instanceof ConditionCol) {
            cell = this.derieveNewCellFromModel(column);
        } else if (column instanceof ActionSetFieldCol) {
            cell = this.derieveNewCellFromModel(column);
        } else if (column instanceof ActionInsertFactCol) {
            cell = this.derieveNewCellFromModel(column);
        }
        cell.setMergableGridWidget(this.grid);
        return cell;
    }

    private DecoratedGridCellValueAdaptor<? extends Comparable<?>> derieveNewCellFromModel(DTColumnConfig col) {
        DecoratedGridCellValueAdaptor cell = this.makeTextCell();
        String type = this.model.getType(col, this.sce);
        if (type == null) {
            return cell;
        }
        String[] vals = this.model.getValueList(col, this.sce);
        if (vals.length == 0) {
            if (type.equals("Numeric")) {
                cell = this.makeNumericCell();
            } else if (type.equals("Boolean")) {
                cell = this.makeBooleanCell();
            } else if (type.equals("Date")) {
                cell = this.makeDateCell();
            }
        } else {
            PopupDropDownEditCell pudd = new PopupDropDownEditCell();
            pudd.setItems(vals);
            cell = new DecoratedGridCellValueAdaptor((AbstractCell)pudd);
        }
        return cell;
    }

    private DecoratedGridCellValueAdaptor<String> makeDialectCell() {
        PopupDropDownEditCell pudd = new PopupDropDownEditCell();
        pudd.setItems(DIALECTS);
        return new DecoratedGridCellValueAdaptor((AbstractCell)pudd);
    }

    private DecoratedGridCellValueAdaptor<BigDecimal> makeRowNumberCell() {
        return new DecoratedGridCellValueAdaptor((AbstractCell)new RowNumberCell());
    }
}

