/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Iterator;
import java.util.Map;
import org.drools.guvnor.client.explorer.AbstractTree;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.util.TabOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseTree
extends AbstractTree
implements OpenHandler<TreeItem> {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);

    public BrowseTree() {
        this.name = constants.Browse();
        this.image = images.ruleAsset();
        this.mainTree.setAnimationEnabled(true);
        ExplorerNodeConfig.setupBrowseTree((Tree)this.mainTree, (Map)this.itemWidgets);
        this.mainTree.addSelectionHandler((SelectionHandler)this);
        this.mainTree.addOpenHandler((OpenHandler)this);
    }

    protected Tree createTree() {
        return new Tree();
    }

    public void refreshTree() {
        this.mainTree.clear();
        this.itemWidgets.clear();
        ExplorerNodeConfig.setupBrowseTree((Tree)this.mainTree, (Map)this.itemWidgets);
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getSelectedItem();
        String widgetID = (String)this.itemWidgets.get(item);
        TabOpener opener = TabOpener.getInstance();
        if (widgetID != null) {
            if (widgetID.equals("find")) {
                opener.openFind();
            } else if (widgetID.equals("incoming") || widgetID.equals("recentEdited") || widgetID.equals("recentViewed")) {
                opener.openInbox(item.getText(), widgetID);
            } else if (widgetID.startsWith("states")) {
                opener.openState(item.getText(), widgetID);
            } else if (widgetID.startsWith("category")) {
                opener.openCategory(item.getText(), widgetID);
            }
        }
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem node = (TreeItem)event.getTarget();
        if ("rootstates".equals(this.itemWidgets.get(node))) {
            this.removeStateIDs(this.itemWidgets);
            node.removeItems();
            ExplorerNodeConfig.setupStatesStructure((TreeItem)node, (Map)this.itemWidgets);
        } else if ("rootcategory".equals(this.itemWidgets.get(node))) {
            this.removeCategoryIDs(this.itemWidgets);
            node.removeItems();
            ExplorerNodeConfig.setupCategoriesStructure((TreeItem)node, (Map)this.itemWidgets);
        }
    }

    private void removeStateIDs(Map<TreeItem, String> itemWidgets) {
        Iterator<Map.Entry<TreeItem, String>> it = itemWidgets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TreeItem, String> entry = it.next();
            TreeItem item = entry.getKey();
            String id = entry.getValue();
            if (!id.startsWith("states-")) continue;
            it.remove();
        }
    }

    private void removeCategoryIDs(Map<TreeItem, String> itemWidgets) {
        Iterator<Map.Entry<TreeItem, String>> it = itemWidgets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TreeItem, String> entry = it.next();
            TreeItem item = entry.getKey();
            String id = entry.getValue();
            if (!id.startsWith("category-")) continue;
            it.remove();
        }
    }
}

