/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Map;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.PackageHierarchy;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.client.security.CapabilitiesManager;
import org.drools.guvnor.client.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ExplorerNodeConfig {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    public static final String FIND_ID = "find";
    public static final String CATEGORY_ROOT_ID = "rootcategory";
    public static final String CATEGORY_ID = "category";
    public static final String STATES_ID = "states";
    public static final String STATES_ROOT_ID = "rootstates";
    public static final String RECENT_EDITED_ID = "recentEdited";
    public static final String RECENT_VIEWED_ID = "recentViewed";
    public static final String INCOMING_ID = "incoming";
    public static final String TEST_SCENARIOS_ID = "testScenarios";
    public static final String TEST_SCENARIOS_ROOT_ID = "roottestScenarios";
    public static final String ANALYSIS_ID = "analysis";
    public static final String ANALYSIS_ROOT_ID = "rootanalysis";
    public static final String RULE_LIST_TABLE_ID = "rulelist";
    public static final String PACKAGEVIEW_LIST_TABLE_ID = "packageviewlist";
    public static final String ARCHIVED_RULE_LIST_TABLE_ID = "archivedrulelist";
    public static final String PACKAGE_SNAPSHOTS = "packageSnapshots";

    public static TreeItem getPackageItemStructure(String packageName, String uuid, Map<TreeItem, String> itemWidgets) {
        TreeItem pkg = new TreeItem(Util.getHeader((ImageResource)images.packages(), (String)packageName));
        itemWidgets.put(pkg, uuid);
        TreeItem item = new TreeItem(Util.getHeader((ImageResource)images.ruleAsset(), (String)constants.BusinessRuleAssets()));
        item.setUserObject((Object)AssetFormats.BUSINESS_RULE_FORMATS);
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.technicalRuleAssets(), (String)constants.TechnicalRuleAssets()));
        itemWidgets.put(item, "drl");
        item.setUserObject((Object)new String[]{"drl"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.functionAssets(), (String)constants.Functions()));
        itemWidgets.put(item, "function");
        item.setUserObject((Object)new String[]{"function"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.dsl(), (String)constants.DSLConfigurations()));
        itemWidgets.put(item, "dsl");
        item.setUserObject((Object)new String[]{"dsl"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.modelAsset(), (String)constants.Model()));
        itemWidgets.put(item, "model.drl");
        item.setUserObject((Object)new String[]{"model.drl", "jar"});
        pkg.addItem(item);
        if (Preferences.getBooleanPref((String)"flex-bpel-editor")) {
            item = new TreeItem(Util.getHeader((ImageResource)images.ruleflowSmall(), (String)constants.RuleFlows()));
            itemWidgets.put(item, "rf");
            item.setUserObject((Object)new String[]{"rf", "bpmn", "bpmn2", "bpel.jar"});
            pkg.addItem(item);
        } else {
            item = new TreeItem(Util.getHeader((ImageResource)images.ruleflowSmall(), (String)constants.RuleFlows()));
            itemWidgets.put(item, "rf");
            item.setUserObject((Object)new String[]{"rf", "bpmn", "bpmn2"});
            pkg.addItem(item);
        }
        item = new TreeItem(Util.getHeader((ImageResource)images.enumeration(), (String)constants.Enumerations()));
        itemWidgets.put(item, "enumeration");
        item.setUserObject((Object)new String[]{"enumeration"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.testManager(), (String)constants.TestScenarios()));
        itemWidgets.put(item, "scenario");
        item.setUserObject((Object)new String[]{"scenario"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.newFile(), (String)constants.XMLProperties()));
        itemWidgets.put(item, "properties");
        item.setUserObject((Object)new String[]{"properties", "xml"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.newFile(), (String)constants.OtherAssetsDocumentation()));
        itemWidgets.put(item, "properties");
        item.setUserObject((Object)new String[0]);
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.workingset(), (String)constants.WorkingSets()));
        itemWidgets.put(item, "workingset");
        item.setUserObject((Object)new String[]{"workingset"});
        pkg.addItem(item);
        item = new TreeItem(Util.getHeader((ImageResource)images.enumeration(), (String)constants.SpringContext()));
        itemWidgets.put(item, "springContext");
        item.setUserObject((Object)new String[]{"springContext"});
        pkg.addItem(item);
        return pkg;
    }

    public static void setupDeploymentTree(Tree tree, Map<TreeItem, String> itemWidgets) {
        TreeItem root = tree.addItem(Util.getHeader((ImageResource)images.chartOrganisation(), (String)constants.PackageSnapshots()));
        root.setState(true);
        itemWidgets.put(root, "packageSnapshots");
        ExplorerNodeConfig.deploymentListPackages((TreeItem)root);
    }

    private static void deploymentListPackages(TreeItem root) {
        RepositoryServiceFactory.getPackageService().listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void buildDeploymentTree(TreeItem root, PackageHierarchy.Folder fldr) {
        if (fldr.getConfig() != null) {
            TreeItem pkg = new TreeItem(Util.getHeader((ImageResource)images.snapshotSmall(), (String)fldr.getConfig().name));
            pkg.setUserObject((Object)fldr.getConfig());
            pkg.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
            root.addItem(pkg);
        } else {
            TreeItem tn = new TreeItem(Util.getHeader((ImageResource)images.emptyPackage(), (String)fldr.getName()));
            root.addItem(tn);
            for (PackageHierarchy.Folder c : fldr.getChildren()) {
                ExplorerNodeConfig.buildDeploymentTree((TreeItem)tn, (PackageHierarchy.Folder)c);
            }
        }
    }

    public static void setupBrowseTree(Tree tree, Map<TreeItem, String> itemWidgets) {
        TreeItem root = tree.addItem(Util.getHeader((ImageResource)images.ruleAsset(), (String)constants.AssetsTreeView()));
        TreeItem find = root.addItem(Util.getHeader((ImageResource)images.find(), (String)constants.Find()));
        itemWidgets.put(find, "find");
        TreeItem inbox = ExplorerNodeConfig.getInboxStructure(itemWidgets);
        inbox.setState(true);
        root.addItem(inbox);
        if (CapabilitiesManager.getInstance().shouldShow(new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            TreeItem byStatus = new TreeItem(Util.getHeader((ImageResource)images.statusSmall(), (String)constants.ByStatus()));
            itemWidgets.put(byStatus, "rootstates");
            ExplorerNodeConfig.setupStatesStructure((TreeItem)byStatus, itemWidgets);
            root.addItem(byStatus);
        }
        TreeItem byCategory = new TreeItem(Util.getHeader((ImageResource)images.chartOrganisation(), (String)constants.ByCategory()));
        itemWidgets.put(byCategory, "rootcategory");
        ExplorerNodeConfig.setupCategoriesStructure((TreeItem)byCategory, itemWidgets);
        root.addItem(byCategory);
    }

    private static TreeItem getInboxStructure(Map<TreeItem, String> itemWidgets) {
        TreeItem inbox = new TreeItem(Util.getHeader((ImageResource)images.inbox(), (String)constants.Inbox()));
        TreeItem incomingChanges = new TreeItem(Util.getHeader((ImageResource)images.categorySmall(), (String)constants.IncomingChanges()));
        itemWidgets.put(incomingChanges, "incoming");
        inbox.addItem(incomingChanges);
        TreeItem recentOpened = new TreeItem(Util.getHeader((ImageResource)images.categorySmall(), (String)constants.RecentlyOpened()));
        itemWidgets.put(recentOpened, "recentViewed");
        inbox.addItem(recentOpened);
        TreeItem recentEdited = new TreeItem(Util.getHeader((ImageResource)images.categorySmall(), (String)constants.RecentlyEdited()));
        itemWidgets.put(recentEdited, "recentEdited");
        inbox.addItem(recentEdited);
        return inbox;
    }

    public static void setupCategoriesStructure(TreeItem byCategory, Map<TreeItem, String> itemWidgets) {
        ExplorerNodeConfig.doCategoryNode((TreeItem)byCategory, (String)"/", itemWidgets);
    }

    private static void doCategoryNode(TreeItem treeItem, String path, Map<TreeItem, String> itemWidgets) {
        ExplorerNodeConfig.infanticide((TreeItem)treeItem);
        RepositoryServiceFactory.getCategoryService().loadChildCategories(path, (AsyncCallback)ExplorerNodeConfig.createGenericCallbackForLoadChildCategories((TreeItem)treeItem, (String)path, itemWidgets));
    }

    private static GenericCallback<String[]> createGenericCallbackForLoadChildCategories(TreeItem treeItem, String path, Map<TreeItem, String> itemWidgets) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static void infanticide(TreeItem treeNode) {
        treeNode.removeItems();
    }

    public static void setupStatesStructure(TreeItem byStatus, Map<TreeItem, String> itemWidgets) {
        RepositoryServiceFactory.getService().listStates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Tree getQAStructure(Map<TreeItem, String> itemWidgets) {
        Tree tree = new Tree();
        tree.setAnimationEnabled(true);
        TreeItem scenarios = new TreeItem(Util.getHeader((ImageResource)images.testManager(), (String)constants.TestScenariosInPackages()));
        scenarios.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
        tree.addItem(scenarios);
        itemWidgets.put(scenarios, "roottestScenarios");
        TreeItem analysis = new TreeItem(Util.getHeader((ImageResource)images.analyze(), (String)constants.Analysis()));
        analysis.addItem(new TreeItem(constants.PleaseWaitDotDotDot()));
        itemWidgets.put(analysis, "rootanalysis");
        if (Preferences.getBooleanPref((String)"verifier")) {
            tree.addItem(analysis);
        }
        return tree;
    }

    static /* synthetic */ void access$000(TreeItem x0, PackageHierarchy.Folder x1) {
        ExplorerNodeConfig.buildDeploymentTree((TreeItem)x0, (PackageHierarchy.Folder)x1);
    }

    static /* synthetic */ void access$100(TreeItem x0) {
        ExplorerNodeConfig.infanticide((TreeItem)x0);
    }

    static /* synthetic */ Images access$200() {
        return images;
    }

    static /* synthetic */ Constants access$300() {
        return constants;
    }

    static /* synthetic */ void access$500(TreeItem x0, String x1, Map x2) {
        ExplorerNodeConfig.doCategoryNode((TreeItem)x0, (String)x1, (Map)x2);
    }
}

