/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Iterator;
import java.util.Map;
import org.drools.guvnor.client.explorer.AbstractTree;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.util.TabOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QATree
extends AbstractTree
implements OpenHandler<TreeItem> {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);

    public QATree() {
        this.name = constants.QA1();
        this.image = images.analyze();
        this.mainTree.addSelectionHandler((SelectionHandler)this);
        this.mainTree.addOpenHandler((OpenHandler)this);
    }

    protected Tree createTree() {
        return ExplorerNodeConfig.getQAStructure((Map)this.itemWidgets);
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem item = (TreeItem)event.getSelectedItem();
        if (item.getUserObject() instanceof PackageConfigData) {
            PackageConfigData pc = (PackageConfigData)item.getUserObject();
            String id = (String)this.itemWidgets.get(item);
            TabOpener opener = TabOpener.getInstance();
            if ("testScenarios".equals(id)) {
                opener.openTestScenario(pc.uuid, pc.name);
            } else if ("analysis".equals(id)) {
                opener.openVerifierView(pc.uuid, pc.name);
            }
        }
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem node = (TreeItem)event.getTarget();
        if ("roottestScenarios".equals(this.itemWidgets.get(node))) {
            RepositoryServiceFactory.getPackageService().listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if ("rootanalysis".equals(this.itemWidgets.get(node))) {
            RepositoryServiceFactory.getPackageService().listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void removeTestScenarioIDs(Map<TreeItem, String> itemWidgets) {
        Iterator<Map.Entry<TreeItem, String>> it = itemWidgets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TreeItem, String> entry = it.next();
            TreeItem item = entry.getKey();
            String id = entry.getValue();
            if (!"testScenarios".equals(id)) continue;
            it.remove();
        }
    }

    private void removeAnalysisIDs(Map<TreeItem, String> itemWidgets) {
        Iterator<Map.Entry<TreeItem, String>> it = itemWidgets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<TreeItem, String> entry = it.next();
            TreeItem item = entry.getKey();
            String id = entry.getValue();
            if (!"analysis".equals(id)) continue;
            it.remove();
        }
    }

    static /* synthetic */ void access$000(QATree x0, Map x1) {
        x0.removeTestScenarioIDs(x1);
    }

    static /* synthetic */ Images access$100() {
        return images;
    }

    static /* synthetic */ void access$200(QATree x0, Map x1) {
        x0.removeAnalysisIDs(x1);
    }
}

