/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.AbstractRestrictedEntryTextBox;
import org.drools.guvnor.client.modeldriven.ui.CEPLengthParameterTextBox;
import org.drools.guvnor.client.modeldriven.ui.CEPTimeParameterTextBox;
import org.drools.guvnor.client.modeldriven.ui.OperatorSelection;
import org.drools.guvnor.client.resources.OperatorsCss;
import org.drools.guvnor.client.resources.OperatorsResource;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEPWindowOperatorsDropdown
extends Composite
implements HasValueChangeHandlers<OperatorSelection> {
    private static final Constants constants = (Constants)GWT.create(Constants.class);
    private static final OperatorsResource resources = (OperatorsResource)GWT.create(OperatorsResource.class);
    private static final OperatorsCss css = resources.operatorsCss();
    private List<String> operators;
    private ListBox box;
    private HorizontalPanel container = new HorizontalPanel();
    protected CEPWindow window;
    private static final String CEP_OPERATOR_PARAMETER_GENERATOR = "org.drools.ide.common.server.util.CEPWindowOperatorParameterDRLBuilder";

    public CEPWindowOperatorsDropdown(List<String> operators, HasCEPWindow hcw) {
        this.window = hcw.getWindow();
        this.operators = operators;
        HorizontalPanel hp = new HorizontalPanel();
        hp.setStylePrimaryName(css.container());
        hp.add(this.getDropDown());
        hp.add(this.getOperatorExtension());
        this.initWidget((Widget)hp);
    }

    public int getSelectedIndex() {
        return this.box.getSelectedIndex();
    }

    public String getValue(int index) {
        return this.box.getValue(index);
    }

    private Widget getOperatorExtension() {
        this.container.setStylePrimaryName(css.container());
        return this.container;
    }

    private void operatorChanged(OperatorSelection selection) {
        this.container.clear();
        String operator = selection.getValue();
        if (SuggestionCompletionEngine.isCEPWindowOperatorTime((String)operator)) {
            CEPTimeParameterTextBox txt = new CEPTimeParameterTextBox((HasParameterizedOperator)this.window, 1);
            this.initialiseTextBox((AbstractRestrictedEntryTextBox)txt);
        } else if (SuggestionCompletionEngine.isCEPWindowOperatorLength((String)operator)) {
            CEPLengthParameterTextBox txt = new CEPLengthParameterTextBox((HasParameterizedOperator)this.window, 1);
            this.initialiseTextBox((AbstractRestrictedEntryTextBox)txt);
        } else {
            this.container.setVisible(false);
            this.window.clearParameters();
        }
    }

    private void initialiseTextBox(AbstractRestrictedEntryTextBox txt) {
        String key = String.valueOf(1);
        String value = this.window.getParameter(key);
        if (value == null) {
            value = "";
            this.window.setParameter(key, value);
        }
        if (!txt.isValidValue(value)) {
            value = "";
            this.window.setParameter(key, value);
        }
        txt.setText(value);
        this.container.add((Widget)txt);
        this.container.setVisible(true);
        this.window.setParameter("org.drools.ide.common.server.util.BRDRLPersistence.operatorParameterGenerator", CEP_OPERATOR_PARAMETER_GENERATOR);
    }

    private Widget getDropDown() {
        String selected = "";
        String selectedText = "";
        this.box = new ListBox();
        this.box.addItem("<no window>", "");
        for (int i = 0; i < this.operators.size(); ++i) {
            String op = (String)this.operators.get(i);
            this.box.addItem(HumanReadable.getOperatorDisplayName((String)op), op);
            if (!op.equals(this.window.getOperator())) continue;
            selected = op;
            selectedText = HumanReadable.getOperatorDisplayName((String)op);
            this.box.setSelectedIndex(i + 1);
        }
        CEPWindowOperatorsDropdown source = this;
        OperatorSelection selection = new OperatorSelection(selected, selectedText);
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        this.box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.box;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<OperatorSelection> handler) {
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    static /* synthetic */ void access$000(CEPWindowOperatorsDropdown x0, OperatorSelection x1) {
        x0.operatorChanged(x1);
    }

    static /* synthetic */ ListBox access$100(CEPWindowOperatorsDropdown x0) {
        return x0.box;
    }
}

