/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.BoundTextBox;
import org.drools.guvnor.client.modeldriven.ui.CustomFormPopUp;
import org.drools.guvnor.client.modeldriven.ui.DatePickerLabel;
import org.drools.guvnor.client.modeldriven.ui.DefaultLiteralEditor;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDownLabel;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.factconstraints.customform.CustomFormConfiguration;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.HasOperator;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

public class ConstraintValueEditor
extends DirtyableComposite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private final FactPattern pattern;
    private String fieldName;
    private final SuggestionCompletionEngine sce;
    private final BaseSingleFieldConstraint constraint;
    private final Panel panel;
    private final RuleModel model;
    private final RuleModeller modeller;
    private boolean isNumeric;
    private DropDownData dropDownData;
    private String fieldType;
    private boolean readOnly;
    private Command onValueChangeCommand;
    private boolean isDropDownDataEnum;

    public ConstraintValueEditor(FactPattern pattern, String fieldName, BaseSingleFieldConstraint con, RuleModeller modeller, boolean readOnly) {
        this.pattern = pattern;
        this.sce = modeller.getSuggestionCompletions();
        this.constraint = con;
        this.panel = new SimplePanel();
        this.model = modeller.getModel();
        this.modeller = modeller;
        this.readOnly = readOnly;
        if (con instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)con;
            this.fieldName = sfexp.getExpressionLeftSide().getFieldName();
            this.fieldType = sfexp.getExpressionLeftSide().getGenericType();
        } else if (con instanceof ConnectiveConstraint) {
            ConnectiveConstraint cc = (ConnectiveConstraint)con;
            this.fieldName = cc.getFieldName();
            this.fieldType = cc.getFieldType();
        } else {
            this.fieldName = fieldName;
            this.fieldType = this.sce.getFieldType(pattern.getFactType(), fieldName);
        }
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    public BaseSingleFieldConstraint getConstraint() {
        return this.constraint;
    }

    private void refreshEditor() {
        this.panel.clear();
        Widget constraintWidget = null;
        if (this.constraint instanceof SingleFieldConstraintEBLeftSide) {
            SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)this.constraint;
            this.fieldName = sfexp.getExpressionLeftSide().getFieldName();
            this.fieldType = sfexp.getExpressionLeftSide().getGenericType();
        }
        this.isNumeric = "Numeric".equals(this.fieldType);
        if ("Boolean".equals(this.fieldType)) {
            this.isDropDownDataEnum = false;
            this.dropDownData = DropDownData.create((String[])new String[]{"true", "false"});
        } else {
            this.isDropDownDataEnum = true;
            this.dropDownData = this.sce.getEnums(this.pattern, this.fieldName);
        }
        if (this.constraint.getConstraintValueType() == 0) {
            Image clickme = new Image(images.edit());
            clickme.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            constraintWidget = clickme;
        } else {
            switch (this.constraint.getConstraintValueType()) {
                case 1: 
                case 4: {
                    constraintWidget = this.literalEditor();
                    break;
                }
                case 3: {
                    constraintWidget = this.returnValueEditor();
                    break;
                }
                case 6: {
                    constraintWidget = this.expressionEditor();
                    break;
                }
                case 2: {
                    constraintWidget = this.variableEditor();
                    break;
                }
                case 7: {
                    constraintWidget = new DefaultLiteralEditor(this.constraint, false);
                    break;
                }
            }
        }
        this.panel.add(constraintWidget);
    }

    private Widget literalEditor() {
        if (this.constraint instanceof SingleFieldConstraint) {
            SingleFieldConstraint con = (SingleFieldConstraint)this.constraint;
            CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().metaData.packageName, this.pattern.getFactType(), this.fieldName);
            if (customFormConfiguration != null) {
                Button btnCustom = new Button(con.getValue(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                btnCustom.setEnabled(!this.readOnly);
                return btnCustom;
            }
        }
        if (this.dropDownData != null) {
            EnumDropDownLabel enumDropDown = new EnumDropDownLabel(this.pattern, this.fieldName, this.sce, this.constraint, !this.readOnly);
            if (!this.readOnly) {
                enumDropDown.setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            }
            return enumDropDown;
        }
        boolean isCEPOperator = false;
        if (this.constraint instanceof HasOperator) {
            isCEPOperator = SuggestionCompletionEngine.isCEPOperator((String)((HasOperator)this.constraint).getOperator());
        }
        if ("Date".equals(this.fieldType) || "this".equals(this.fieldType) && isCEPOperator) {
            DatePickerLabel datePicker = new DatePickerLabel(this.constraint.getValue());
            this.constraint.setValue(datePicker.getDateString());
            if (!this.readOnly) {
                datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
                return datePicker;
            }
            return new SmallLabel(this.constraint.getValue());
        }
        if (!this.readOnly) {
            DefaultLiteralEditor dle = new DefaultLiteralEditor(this.constraint, this.isNumeric);
            dle.setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            return dle;
        }
        return new SmallLabel(this.constraint.getValue());
    }

    private Widget variableEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.constraint.getValue());
        }
        List vars = this.model.getBoundVariablesInScope(this.constraint);
        ListBox box = new ListBox();
        if (this.constraint.getValue() == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (String var : vars) {
            HasOperator hop;
            boolean addVariable = false;
            FactPattern f = this.model.getBoundFact(var);
            String fv = this.model.getBindingType(var);
            if (f != null && f.getFactType().equals(this.fieldType) || fv != null && fv.equals(this.fieldType)) {
                addVariable = true;
            } else if (this.fieldType.equals("this")) {
                if (f != null && f.getFactType().equals(this.pattern.getFactType())) {
                    addVariable = true;
                }
                if (fv != null && fv.equals(this.pattern.getFactType())) {
                    addVariable = true;
                }
            } else if (this.fieldType.equals("this") && this.sce.isFactTypeAnEvent(fv)) {
                if (this.constraint instanceof HasOperator && SuggestionCompletionEngine.isCEPOperator((String)(hop = (HasOperator)this.constraint).getOperator())) {
                    addVariable = true;
                }
            } else if (this.fieldType.equals("Date") && this.sce.isFactTypeAnEvent(fv)) {
                if (this.constraint instanceof HasOperator && SuggestionCompletionEngine.isCEPOperator((String)(hop = (HasOperator)this.constraint).getOperator())) {
                    addVariable = true;
                }
            } else {
                String factCollectionType = this.sce.getParametricFieldType(this.pattern.getFactType(), this.fieldName);
                if (f != null && factCollectionType != null && f.getFactType().equals(factCollectionType) || factCollectionType != null && factCollectionType.equals(fv)) {
                    addVariable = true;
                }
            }
            if (!addVariable) continue;
            box.addItem(var);
            if (this.constraint.getValue() != null && this.constraint.getValue().equals(var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget returnValueEditor() {
        BoundTextBox box = new BoundTextBox(this.constraint);
        if (this.readOnly) {
            return new SmallLabel(box.getText());
        }
        String msg = this.constants.FormulaEvaluateToAValue();
        Image img = new Image(images.functionAssets());
        img.setTitle(msg);
        box.setTitle(msg);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Panel ed = this.widgets((Widget)img, (Widget)box);
        return ed;
    }

    private Widget expressionEditor() {
        if (!(this.constraint instanceof SingleFieldConstraint)) {
            throw new IllegalArgumentException("Expected SingleFieldConstraint, but " + this.constraint.getClass().getName() + " found.");
        }
        ExpressionBuilder builder = new ExpressionBuilder(this.modeller, ((SingleFieldConstraint)this.constraint).getExpressionValue(), Boolean.valueOf(this.readOnly));
        builder.addExpressionTypeChangeHandler((ExpressionTypeChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        builder.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        Panel ed = this.widgets((Widget)new HTML("&nbsp;"), (Widget)builder);
        return ed;
    }

    private void showTypeChoice(Widget w, BaseSingleFieldConstraint con) {
        ConnectiveConstraint cc;
        CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().metaData.packageName, this.pattern.getFactType(), this.fieldName);
        if (customFormConfiguration != null) {
            if (!(con instanceof SingleFieldConstraint)) {
                Window.alert((String)"Unexpected constraint type!");
                return;
            }
            CustomFormPopUp customFormPopUp = new CustomFormPopUp(images.newexWiz(), this.constants.FieldValue(), customFormConfiguration);
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            customFormPopUp.addOkButtonHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            customFormPopUp.show(sfc.getId(), sfc.getValue());
            return;
        }
        FormStylePopup form = new FormStylePopup(images.newexWiz(), this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        boolean showLiteralOrFormula = true;
        if (con instanceof SingleFieldConstraint) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            if (sfc.getFieldType().equals("this")) {
                showLiteralOrFormula = SuggestionCompletionEngine.isCEPOperator((String)sfc.getOperator());
            }
        } else if (con instanceof ConnectiveConstraint && (cc = (ConnectiveConstraint)con).getFieldType().equals("this")) {
            showLiteralOrFormula = SuggestionCompletionEngine.isCEPOperator((String)cc.getOperator());
        }
        if (showLiteralOrFormula) {
            form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        }
        if (this.modeller.isTemplate()) {
            String templateKeyLabel = this.constants.TemplateKey();
            Button templateKeyButton = new Button(templateKeyLabel);
            templateKeyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(templateKeyLabel + ":", (Widget)this.widgets((Widget)templateKeyButton, (Widget)new InfoPopup(templateKeyLabel, this.constants.LiteralValTip())));
        }
        if (showLiteralOrFormula) {
            form.addRow((Widget)new HTML("<hr/>"));
            form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        }
        if (this.model.getBoundVariablesInScope(this.constraint).size() > 0 || "Collection".equals(this.fieldType)) {
            List vars = this.model.getBoundFacts();
            for (String var : vars) {
                String fieldConstraint;
                FactPattern f = this.model.getBoundFact(var);
                if (!this.isBoundVariableApplicable(con, f, fieldConstraint = this.model.getBindingType(var))) continue;
                Button variable = new Button(this.constants.BoundVariable());
                variable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
                break;
            }
        }
        if (showLiteralOrFormula) {
            Button formula = new Button(this.constants.NewFormula());
            formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(this.constants.AFormula() + ":", (Widget)this.widgets((Widget)formula, (Widget)new InfoPopup(this.constants.AFormula(), this.constants.FormulaExpressionTip())));
        }
        Button expression = new Button(this.constants.ExpressionEditor());
        expression.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.ExpressionEditor() + ":", (Widget)this.widgets((Widget)expression, (Widget)new InfoPopup(this.constants.ExpressionEditor(), this.constants.ExpressionEditor())));
        form.show();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.executeOnValueChangeCommand();
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    private boolean isBoundVariableApplicable(BaseSingleFieldConstraint con, FactPattern f, String fieldConstraint) {
        if (f != null && f.getFactType() != null && f.getFactType().equals(this.fieldType)) {
            return true;
        }
        if (this.fieldType != null && this.fieldType.equals(fieldConstraint)) {
            return true;
        }
        if (con instanceof SingleFieldConstraint && f != null && f.getFactType() != null) {
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            if (SuggestionCompletionEngine.isCEPOperator((String)sfc.getOperator())) {
                if (sfc.getFieldType().equals("this") ? this.sce.isFactTypeAnEvent(f.getFactType()) : sfc.getFieldType().equals("Date") && this.sce.isFactTypeAnEvent(f.getFactType())) {
                    return true;
                }
            } else if (sfc.getFieldType().equals("this")) {
                if (f.getFactType().equals(this.pattern.getFactType())) {
                    return true;
                }
                if (fieldConstraint != null && fieldConstraint.equals(this.pattern.getFactType())) {
                    return true;
                }
            }
        }
        if (con instanceof ConnectiveConstraint && f != null && f.getFactType() != null) {
            ConnectiveConstraint cc = (ConnectiveConstraint)con;
            if (SuggestionCompletionEngine.isCEPOperator((String)cc.getOperator())) {
                if (cc.getFieldType().equals("this")) {
                    if (this.sce.isFactTypeAnEvent(f.getFactType())) {
                        return true;
                    }
                    if (cc.getFieldType().equals("Date") && this.sce.isFactTypeAnEvent(f.getFactType())) {
                        return true;
                    }
                }
            } else if (cc.getFieldType().equals("this")) {
                if (f.getFactType().equals(this.pattern.getFactType())) {
                    return true;
                }
                if (fieldConstraint != null && fieldConstraint.equals(this.pattern.getFactType())) {
                    return true;
                }
            }
        }
        String factCollectionType = this.sce.getParametricFieldType(this.pattern.getFactType(), this.fieldName);
        return f != null && factCollectionType != null && f.getFactType().equals(factCollectionType) || factCollectionType != null && factCollectionType.equals(fieldConstraint);
    }

    static /* synthetic */ BaseSingleFieldConstraint access$000(ConstraintValueEditor x0) {
        return x0.constraint;
    }

    static /* synthetic */ void access$100(ConstraintValueEditor x0, Widget x1, BaseSingleFieldConstraint x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$200(ConstraintValueEditor x0) {
        x0.executeOnValueChangeCommand();
    }

    static /* synthetic */ void access$300(ConstraintValueEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }

    static /* synthetic */ boolean access$400(ConstraintValueEditor x0) {
        return x0.isDropDownDataEnum;
    }

    static /* synthetic */ DropDownData access$500(ConstraintValueEditor x0) {
        return x0.dropDownData;
    }
}

