/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.ExpressionChangeEvent;
import org.drools.guvnor.client.modeldriven.ui.ExpressionChangeHandler;
import org.drools.guvnor.client.modeldriven.ui.ExpressionTypeChangeEvent;
import org.drools.guvnor.client.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.modeldriven.ui.HasExpressionChangeHandlers;
import org.drools.guvnor.client.modeldriven.ui.HasExpressionTypeChangeHandlers;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionCollectionIndex;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFieldVariable;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.ExpressionMethod;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPart;
import org.drools.ide.common.client.modeldriven.brl.ExpressionPartHelper;
import org.drools.ide.common.client.modeldriven.brl.ExpressionText;
import org.drools.ide.common.client.modeldriven.brl.ExpressionVariable;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionBuilder
extends RuleModellerWidget
implements HasExpressionTypeChangeHandlers,
HasExpressionChangeHandlers {
    private static final String DELETE_VALUE = "_delete_";
    private static final String FIElD_VALUE_PREFIX = "fl";
    private static final String VARIABLE_VALUE_PREFIX = "va";
    private static final String GLOBAL_VARIABLE_VALUE_PREFIX = "gv";
    private static final String METHOD_VALUE_PREFIX = "mt";
    private final SmallLabelClickHandler slch = new SmallLabelClickHandler(this, null);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private HorizontalPanel panel = new HorizontalPanel();
    private ExpressionFormLine expression;
    private boolean readOnly;

    public ExpressionBuilder(RuleModeller modeller, ExpressionFormLine expression) {
        this(modeller, expression, Boolean.valueOf(false));
    }

    public ExpressionBuilder(RuleModeller modeller, ExpressionFormLine expression, Boolean readOnly) {
        super(modeller);
        this.expression = expression;
        this.readOnly = readOnly == null ? !modeller.getSuggestionCompletions().containsFactType(modeller.getSuggestionCompletions().getFactNameFromType(this.expression.getRootExpression().getClassType())) : readOnly;
        this.panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        if (expression == null || expression.isEmpty()) {
            if (this.readOnly) {
                this.panel.add((Widget)new SmallLabel("<b>-</b>"));
            } else {
                this.panel.add(this.createStartPointWidget());
            }
        } else if (this.readOnly) {
            this.panel.add((Widget)this.createWidgetForExpression("<b>" + this.getBoundText() + expression.getText(false) + "</b>"));
        } else {
            this.panel.add((Widget)this.createWidgetForExpression("<b>" + this.getBoundText() + expression.getText(false) + ".</b>"));
            this.panel.add(this.getWidgetForCurrentType());
        }
        this.initWidget((Widget)this.panel);
    }

    private String getBoundText() {
        if (this.expression.isBound()) {
            return "[" + this.expression.getBinding() + "] ";
        }
        return "";
    }

    private Widget createStartPointWidget() {
        ListBox startPoint = new ListBox();
        this.panel.add((Widget)startPoint);
        startPoint.addItem(this.constants.ChooseDotDotDot(), "");
        for (String gv : this.getCompletionEngine().getGlobalVariables()) {
            startPoint.addItem(gv, "gv." + gv);
        }
        for (String v : this.getRuleModel().getBoundFacts()) {
            startPoint.addItem(v, "va." + v);
        }
        startPoint.setVisibleItemCount(1);
        startPoint.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return startPoint;
    }

    public void makeDirty() {
        super.makeDirty();
        this.setModified(true);
    }

    private void startPointChange(String value) {
        this.setModified(true);
        this.panel.clear();
        int dotPos = value.indexOf(46);
        String prefix = value.substring(0, dotPos);
        String attrib = value.substring(dotPos + 1);
        if (prefix.equals(VARIABLE_VALUE_PREFIX)) {
            FactPattern fact = this.getRuleModel().getBoundFact(attrib);
            Object variable = fact != null ? new ExpressionVariable(fact) : new ExpressionFieldVariable(attrib);
            this.expression.appendPart((ExpressionPart)variable);
        } else if (prefix.equals(GLOBAL_VARIABLE_VALUE_PREFIX)) {
            this.expression.appendPart(ExpressionPartHelper.getExpressionPartForGlobalVariable((SuggestionCompletionEngine)this.getCompletionEngine(), (String)attrib));
        }
        Widget w = this.getWidgetForCurrentType();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)this.createWidgetForExpression("<b>" + this.expression.getText() + ".</b>"));
        }
        if (w != null) {
            this.panel.add(w);
        }
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent();
    }

    private Widget getWidgetForCurrentType() {
        if (this.expression.isEmpty()) {
            return this.createStartPointWidget();
        }
        2 ch = new /* Unavailable Anonymous Inner Class!! */;
        ListBox lb = new ListBox();
        lb.setVisibleItemCount(1);
        lb.addItem(this.constants.ChooseDotDotDot(), "");
        lb.addItem("<==" + this.constants.DeleteItem(), DELETE_VALUE);
        for (Map.Entry entry : this.getCompletionsForCurrentType().entrySet()) {
            lb.addItem((String)entry.getKey(), (String)entry.getValue());
        }
        lb.addChangeHandler((ChangeHandler)ch);
        return lb;
    }

    private void onCollectionChange(String value) {
        if ("size".contains(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
        } else if ("isEmpty".equals(value)) {
            this.expression.appendPart((ExpressionPart)new ExpressionMethod("isEmpty", "boolean", "Boolean"));
        } else {
            String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentParametricType());
            ExpressionCollectionIndex collectionIndex = this.getCurrentParametricType() != null && factName != null ? new ExpressionCollectionIndex("get", this.getCurrentParametricType(), factName) : new ExpressionCollectionIndex("get", "java.lang.Object", "Object");
            if ("first".equals(value)) {
                collectionIndex.putParam("index", new ExpressionFormLine((ExpressionPart)new ExpressionText("0")));
                this.expression.appendPart((ExpressionPart)collectionIndex);
            } else if ("last".equals(value)) {
                ExpressionFormLine index = new ExpressionFormLine(this.expression);
                index.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
                index.appendPart((ExpressionPart)new ExpressionText("-1"));
                collectionIndex.putParam("index", index);
                this.expression.appendPart((ExpressionPart)collectionIndex);
            }
        }
    }

    private void onChangeSelection(String value) {
        this.setModified(true);
        String oldType = this.getCurrentGenericType();
        String prevFactName = null;
        if (DELETE_VALUE.equals(value)) {
            this.expression.removeLast();
        } else if ("Collection".equals(this.getCurrentGenericType())) {
            this.onCollectionChange(value);
        } else if ("String".equals(this.getCurrentGenericType())) {
            if ("size".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionMethod("size", "int", "Numeric"));
            } else if ("isEmpty".equals(value)) {
                this.expression.appendPart((ExpressionPart)new ExpressionText(".size() == 0", "", "Numeric"));
            }
        } else {
            int dotPos = value.indexOf(46);
            String prefix = value.substring(0, dotPos);
            String attrib = value.substring(dotPos + 1);
            prevFactName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
            if (FIElD_VALUE_PREFIX.equals(prefix)) {
                this.expression.appendPart(ExpressionPartHelper.getExpressionPartForField((SuggestionCompletionEngine)this.getCompletionEngine(), (String)prevFactName, (String)attrib));
            } else if (METHOD_VALUE_PREFIX.equals(prefix)) {
                this.expression.appendPart(ExpressionPartHelper.getExpressionPartForMethod((SuggestionCompletionEngine)this.getCompletionEngine(), (String)prevFactName, (String)attrib));
            }
        }
        Widget w = this.getWidgetForCurrentType();
        this.panel.clear();
        if (!this.expression.isEmpty()) {
            this.panel.add((Widget)this.createWidgetForExpression("<b>" + this.expression.getText() + ".</b>"));
        }
        if (w != null) {
            this.panel.add(w);
        }
        this.fireExpressionChangeEvent();
        this.fireExpressionTypeChangeEvent(oldType);
    }

    private Map<String, String> getCompletionsForCurrentType() {
        LinkedHashMap<String, String> completions = new LinkedHashMap<String, String>();
        if ("FinalObject".equals(this.getCurrentGenericType())) {
            return completions;
        }
        if ("Collection".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("first()", "first");
            completions.put("last()", "last");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("String".equals(this.getCurrentGenericType())) {
            completions.put("size()", "size");
            completions.put("isEmpty()", "isEmpty");
            return completions;
        }
        if ("Boolean".equals(this.getCurrentGenericType()) || "Numeric".equals(this.getCurrentGenericType()) || "Date".equals(this.getCurrentGenericType()) || "Object".equals(this.getCurrentGenericType())) {
            return completions;
        }
        String factName = this.getCompletionEngine().getFactNameFromType(this.getCurrentClassType());
        if (factName != null) {
            List methodNames = this.getCompletionEngine().getMethodFullNames(factName, 0);
            for (String field : this.getCompletionEngine().getFieldCompletions(factName)) {
                boolean changed = false;
                Iterator i = methodNames.iterator();
                while (i.hasNext()) {
                    String method = (String)i.next();
                    if (!method.startsWith(field)) continue;
                    completions.put(method, "mt." + method);
                    i.remove();
                    changed = true;
                }
                if (changed) continue;
                completions.put(field, "fl." + field);
            }
        }
        return completions;
    }

    private RuleModel getRuleModel() {
        return this.getModeller().getModel();
    }

    private SuggestionCompletionEngine getCompletionEngine() {
        return this.getModeller().getSuggestionCompletions();
    }

    private String getCurrentClassType() {
        return this.expression.getClassType();
    }

    private String getCurrentGenericType() {
        return this.expression.getGenericType();
    }

    private String getPreviousGenericType() {
        return this.expression.getPreviousGenericType();
    }

    private String getCurrentParametricType() {
        return this.expression.getParametricType();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public HandlerRegistration addExpressionTypeChangeHandler(ExpressionTypeChangeHandler handler) {
        return this.addHandler((EventHandler)handler, ExpressionTypeChangeEvent.getType());
    }

    private void fireExpressionChangeEvent() {
        this.fireEvent((GwtEvent)new ExpressionChangeEvent());
    }

    private void fireExpressionTypeChangeEvent() {
        this.fireExpressionTypeChangeEvent(this.getPreviousGenericType());
    }

    private void fireExpressionTypeChangeEvent(String previousGenericType) {
        String currentGenericType = this.getCurrentGenericType();
        if (previousGenericType == null || !previousGenericType.equals(currentGenericType) || currentGenericType != null) {
            this.fireEvent((GwtEvent)new ExpressionTypeChangeEvent(previousGenericType, currentGenericType));
        }
    }

    public HandlerRegistration addExpressionChangeHandler(ExpressionChangeHandler handler) {
        return this.addHandler((EventHandler)handler, ExpressionChangeEvent.getType());
    }

    private void showBindingPopUp() {
        FormStylePopup popup = new FormStylePopup();
        popup.setWidth("500px");
        HorizontalPanel vn = new HorizontalPanel();
        TextBox varName = new TextBox();
        Button ok = new Button(this.constants.Set());
        vn.add((Widget)new Label(this.constants.BindTheExpressionToAVariable()));
        vn.add((Widget)varName);
        vn.add((Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addRow((Widget)vn);
        popup.show();
    }

    private ClickableLabel createWidgetForExpression(String text) {
        ClickableLabel label = new ClickableLabel(text, (ClickHandler)this.slch, !this.readOnly);
        return label;
    }

    static /* synthetic */ void access$100(ExpressionBuilder x0, String x1) {
        x0.startPointChange(x1);
    }

    static /* synthetic */ HorizontalPanel access$200(ExpressionBuilder x0) {
        return x0.panel;
    }

    static /* synthetic */ void access$300(ExpressionBuilder x0, String x1) {
        x0.onChangeSelection(x1);
    }

    static /* synthetic */ Constants access$400(ExpressionBuilder x0) {
        return x0.constants;
    }

    static /* synthetic */ ExpressionFormLine access$500(ExpressionBuilder x0) {
        return x0.expression;
    }

    static /* synthetic */ void access$600(ExpressionBuilder x0) {
        x0.showBindingPopUp();
    }
}

