/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import java.math.BigDecimal;
import java.util.Date;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataCellValueFactory;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.DTDataTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDataCellValueFactory
extends AbstractCellValueFactory<TemplateDataColumn> {
    public TemplateDataCellValueFactory(SuggestionCompletionEngine sce) {
        super(sce);
    }

    public String convertValueToString(TemplateDataColumn column, CellValue<?> cv) {
        DTDataTypes dataType = this.getDataType(column);
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dataType.ordinal()]) {
            case 1: {
                return this.convertBooleanValueToString(cv);
            }
            case 2: {
                return this.convertDateValueToString(cv);
            }
            case 3: {
                return this.convertNumericValueToString(cv);
            }
        }
        return this.convertStringValueToString(cv);
    }

    public CellValue<? extends Comparable<?>> makeCellValue(TemplateDataColumn column, int iRow, int iCol, String initialValue) {
        DTDataTypes dataType = this.getDataType(column);
        CellValue cell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dataType.ordinal()]) {
            case 1: {
                Boolean b = Boolean.FALSE;
                try {
                    b = Boolean.valueOf(initialValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewBooleanCellValue(iRow, iCol, b);
                break;
            }
            case 2: {
                Date d = null;
                try {
                    if (DATE_CONVERTOR == null) {
                        throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                    }
                    d = DATE_CONVERTOR.parse(initialValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewDateCellValue(iRow, iCol, d);
                break;
            }
            case 3: {
                BigDecimal bd = null;
                try {
                    bd = new BigDecimal(initialValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                cell = this.makeNewNumericCellValue(iRow, iCol, bd);
                break;
            }
            default: {
                cell = this.makeNewStringCellValue(iRow, iCol, (Object)initialValue);
            }
        }
        return cell;
    }

    private String convertBooleanValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((Boolean)value.getValue()).toString();
    }

    private String convertDateValueToString(CellValue<?> value) {
        String result = null;
        if (value.getValue() != null) {
            if (DATE_CONVERTOR == null) {
                throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
            }
            result = DATE_CONVERTOR.format((Date)value.getValue());
        }
        return result;
    }

    private String convertNumericValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : ((BigDecimal)value.getValue()).toPlainString();
    }

    private String convertStringValueToString(CellValue<?> value) {
        return value.getValue() == null ? null : (String)((Object)value.getValue());
    }

    protected DTDataTypes getDataType(TemplateDataColumn column) {
        String[] vals = null;
        String factType = column.getFactType();
        String factField = column.getFactField();
        if (factType != null && factField != null && (vals = this.sce.getEnumValues(factType, factField)) != null && vals.length > 0) {
            return DTDataTypes.STRING;
        }
        String dataType = column.getDataType();
        if (dataType.equals("Boolean")) {
            return DTDataTypes.BOOLEAN;
        }
        if (dataType.equals("Date")) {
            return DTDataTypes.DATE;
        }
        if (dataType.equals("Numeric")) {
            return DTDataTypes.NUMERIC;
        }
        return DTDataTypes.STRING;
    }
}

