/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.qa.testscenarios.CallMethodWidget;
import org.drools.guvnor.client.qa.testscenarios.MethodParameterCallValueEditor;
import org.drools.guvnor.client.qa.testscenarios.ScenarioWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.MethodInfo;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.CallFieldValue;
import org.drools.ide.common.client.modeldriven.testing.CallMethod;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.Scenario;

public class CallMethodWidget
extends DirtyableComposite {
    protected static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    protected final ScenarioWidget parent;
    protected final Scenario scenario;
    protected final CallMethod mCall;
    protected final String factName;
    private final ExecutionTrace executionTrace;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletionTexts;
    private String[] fieldCompletionValues;
    private String variableClass;
    private final SuggestionCompletionEngine suggestionCompletionEngine;

    public CallMethodWidget(String factName, ScenarioWidget parent, Scenario scenario, CallMethod mCall, ExecutionTrace executionTrace) {
        this.factName = factName;
        this.parent = parent;
        this.scenario = scenario;
        this.mCall = mCall;
        this.executionTrace = executionTrace;
        this.suggestionCompletionEngine = parent.suggestionCompletionEngine;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        if (this.suggestionCompletionEngine.isGlobalVariable(mCall.getVariable())) {
            List infos = this.suggestionCompletionEngine.getMethodInfosForGlobalVariable(mCall.getVariable());
            this.fieldCompletionTexts = new String[infos.size()];
            this.fieldCompletionValues = new String[infos.size()];
            int i = 0;
            for (MethodInfo info : infos) {
                this.fieldCompletionTexts[i] = info.getName();
                this.fieldCompletionValues[i] = info.getNameWithParameters();
                ++i;
            }
            this.variableClass = this.suggestionCompletionEngine.getGlobalVariable(mCall.getVariable());
        } else {
            FactData pattern = (FactData)scenario.getFactTypes().get(mCall.getVariable());
            if (pattern != null) {
                List methodList = this.suggestionCompletionEngine.getMethodNames(pattern.getType());
                this.fieldCompletionTexts = new String[methodList.size()];
                this.fieldCompletionValues = new String[methodList.size()];
                int i = 0;
                Iterator i$ = methodList.iterator();
                while (i$.hasNext()) {
                    String methodName;
                    this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                    this.fieldCompletionValues[i] = methodName;
                    ++i;
                }
                this.variableClass = pattern.getType();
                this.isBoundFact = true;
            }
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        for (int i = 0; i < this.mCall.getCallFieldValues().length; ++i) {
            CallFieldValue val = this.mCall.getCallFieldValues()[i];
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
        }
        this.layout.setWidget(0, 1, (Widget)inner);
        this.layout.setWidget(0, 2, (Widget)new DeleteButton(this));
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        if (this.mCall.getState() == 0) {
            ImageButton edit = new ImageButton(images.addFieldToFact());
            edit.setTitle(constants.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.mCall.getVariable() + "]"));
            horiz.add((Widget)edit);
        } else {
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.mCall.getVariable() + "." + this.mCall.getMethodName() + "]"));
        }
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        FormStylePopup popup = new FormStylePopup(images.newexWiz(), constants.ChooseAMethodToInvoke());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletionTexts.length; ++i) {
            box.addItem(this.fieldCompletionTexts[i], this.fieldCompletionValues[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(constants.ChooseAMethodToInvoke(), (Widget)box);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.setPopupPosition(w.getAbsoluteLeft(), w.getAbsoluteTop());
        popup.show();
    }

    private Widget valueEditor(CallFieldValue val) {
        String type = "";
        if (this.suggestionCompletionEngine.isGlobalVariable(this.mCall.getVariable())) {
            type = this.suggestionCompletionEngine.getGlobalVariable(this.mCall.getVariable());
        } else {
            Map mFactTypes = this.scenario.getVariableTypes();
            type = (String)mFactTypes.get(this.mCall.getVariable());
        }
        DropDownData enums = this.suggestionCompletionEngine.getEnums(type, (FieldNature[])this.mCall.getCallFieldValues(), val.field);
        return new MethodParameterCallValueEditor(val, enums, this.executionTrace, this.scenario, val.type, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static KeyPressHandler getNumericFilter(TextBox box) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Widget fieldSelector(CallFieldValue val) {
        return new SmallLabel(val.type);
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    protected void onDelete() {
        if (Window.confirm((String)constants.AreYouSureToRemoveCallMethod())) {
            this.scenario.removeFixture((Fixture)this.mCall);
            this.parent.renderEditor();
        }
    }

    static /* synthetic */ String access$000(CallMethodWidget x0) {
        return x0.variableClass;
    }

    static /* synthetic */ SuggestionCompletionEngine access$100(CallMethodWidget x0) {
        return x0.suggestionCompletionEngine;
    }

    static /* synthetic */ Images access$200() {
        return images;
    }
}

