/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.rpc.ConfigurationService;
import org.drools.guvnor.client.rpc.IFramePerspectiveConfiguration;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.drools.repository.IFramePerspectiveConfigurationItem;
import org.drools.repository.RulesRepository;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImplementation
extends RemoteServiceServlet
implements ConfigurationService {
    private ServiceSecurity serviceSecurity = new ServiceSecurity();

    public String save(IFramePerspectiveConfiguration configuration) {
        this.serviceSecurity.checkSecurityIsAdmin();
        RulesRepository repository = this.getRepository();
        if (this.isNewConfiguration(configuration)) {
            IFramePerspectiveConfigurationItem perspectiveConfigurationItem = repository.createPerspectivesConfiguration(configuration.getName(), configuration.getUrl());
            return perspectiveConfigurationItem.getUuid();
        }
        String uuid = configuration.getUuid();
        IFramePerspectiveConfigurationItem perspectiveConfigurationItem = repository.loadPerspectivesConfiguration(uuid);
        perspectiveConfigurationItem.setName(configuration.getName());
        perspectiveConfigurationItem.setUrl(configuration.getUrl());
        repository.save();
        return uuid;
    }

    private boolean isNewConfiguration(IFramePerspectiveConfiguration configuration) {
        return configuration.getUuid() == null;
    }

    public IFramePerspectiveConfiguration load(String uuid) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        this.validateUuid(uuid);
        RulesRepository repository = this.getRepository();
        IFramePerspectiveConfigurationItem perspectiveConfigurationItem = repository.loadPerspectivesConfiguration(uuid);
        return this.prepareResult(perspectiveConfigurationItem);
    }

    public Collection<IFramePerspectiveConfiguration> loadPerspectiveConfigurations() {
        RulesRepository repository = this.getRepository();
        Collection perspectiveConfigurationItems = repository.listPerspectiveConfigurations();
        ArrayList<IFramePerspectiveConfiguration> result = new ArrayList<IFramePerspectiveConfiguration>(perspectiveConfigurationItems.size());
        for (IFramePerspectiveConfigurationItem perspectiveConfigurationItem : perspectiveConfigurationItems) {
            result.add(this.configurationItemToConfiguration(perspectiveConfigurationItem));
        }
        return result;
    }

    public void remove(String uuid) {
        this.serviceSecurity.checkSecurityIsAdmin();
        RulesRepository repository = this.getRepository();
        IFramePerspectiveConfigurationItem perspectiveConfigurationItem = repository.loadPerspectivesConfiguration(uuid);
        perspectiveConfigurationItem.remove();
        repository.save();
    }

    private IFramePerspectiveConfiguration prepareResult(IFramePerspectiveConfigurationItem perspectiveConfigurationItem) {
        if (perspectiveConfigurationItem == null) {
            return null;
        }
        return this.configurationItemToConfiguration(perspectiveConfigurationItem);
    }

    private void validateUuid(String uuid) throws SerializationException {
        if (uuid == null) {
            throw new SerializationException("Invalid parameter: Uuid for the perspective was null");
        }
    }

    protected RulesRepository getRepository() {
        if (Contexts.isApplicationContextActive()) {
            RulesRepository repo = (RulesRepository)Component.getInstance((String)"repository");
            return repo;
        }
        try {
            RulesRepository repo = new RulesRepository(TestEnvironmentSessionHelper.getSession((boolean)false));
            return repo;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get repo to run tests", e);
        }
    }

    private IFramePerspectiveConfiguration configurationItemToConfiguration(IFramePerspectiveConfigurationItem perspectiveConfigurationItem) {
        IFramePerspectiveConfiguration configuration = new IFramePerspectiveConfiguration();
        configuration.setUuid(perspectiveConfigurationItem.getUuid());
        configuration.setName(perspectiveConfigurationItem.getName());
        configuration.setUrl(perspectiveConfigurationItem.getUrl());
        return configuration;
    }
}

