/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.rpc.CategoryPageRequest;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.TableDataResult;
import org.drools.guvnor.server.CategoryFilter;
import org.drools.guvnor.server.builder.pagerow.CategoryRuleListPageRowBuilder;
import org.drools.guvnor.server.security.CategoryPathType;
import org.drools.guvnor.server.util.HtmlCleaner;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.guvnor.server.util.ServiceRowSizeHelper;
import org.drools.guvnor.server.util.TableDisplayHandler;
import org.drools.repository.AssetItemPageResult;
import org.drools.repository.CategoryItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.server.RepositoryCategoryOperations")
@AutoCreate
public class RepositoryCategoryOperations {
    private RulesRepository repository;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryCategoryOperations.class);

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    protected String[] loadChildCategories(String categoryPath) {
        ArrayList<String> resultList = new ArrayList<String>();
        CategoryFilter filter = new CategoryFilter();
        CategoryItem item = this.getRulesRepository().loadCategory(categoryPath);
        List children = item.getChildTags();
        for (Object aChildren : children) {
            String childCategoryName = ((CategoryItem)aChildren).getName();
            if (!filter.acceptNavigate(categoryPath, childCategoryName)) continue;
            resultList.add(childCategoryName);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    protected Boolean createCategory(String path, String name, String description) {
        log.info("USER:" + this.getCurrentUserName() + " CREATING cateogory: [" + name + "] in path [" + path + "]");
        if (path == null || "".equals(path)) {
            path = "/";
        }
        path = HtmlCleaner.cleanHTML((String)path);
        this.getRulesRepository().loadCategory(path).addCategory(name, description);
        this.getRulesRepository().save();
        return Boolean.TRUE;
    }

    protected void renameCategory(String fullPathAndName, String newName) {
        this.getRulesRepository().renameCategory(fullPathAndName, newName);
    }

    protected TableDataResult loadRuleListForCategories(String categoryPath, int skip, int numRows, String tableConfig) throws SerializationException {
        if (Contexts.isSessionContextActive() && !Identity.instance().hasPermission((Object)new CategoryPathType(categoryPath), "analyst.readonly")) {
            TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
            return handler.loadRuleListTable(new AssetItemPageResult());
        }
        AssetItemPageResult result = this.getRulesRepository().findAssetsByCategory(categoryPath, false, skip, numRows);
        TableDisplayHandler handler = new TableDisplayHandler(tableConfig);
        return handler.loadRuleListTable(result);
    }

    protected PageResponse<CategoryPageRow> loadRuleListForCategories(CategoryPageRequest request) {
        long start = System.currentTimeMillis();
        int numRowsToReturn = request.getPageSize() == null ? -1 : request.getPageSize();
        AssetItemPageResult result = this.getRulesRepository().findAssetsByCategory(request.getCategoryPath(), false, request.getStartRowIndex(), numRowsToReturn);
        log.debug("Search time: " + (System.currentTimeMillis() - start));
        boolean bHasMoreRows = result.hasNext;
        PageResponse pageResponse = new PageResponse();
        CategoryRuleListPageRowBuilder categoryRuleListPageRowBuilder = new CategoryRuleListPageRowBuilder();
        List rowList = categoryRuleListPageRowBuilder.createRows((PageRequest)request, result.assets.iterator());
        pageResponse.setStartRowIndex(request.getStartRowIndex());
        pageResponse.setPageRowList(rowList);
        pageResponse.setLastPage(!bHasMoreRows);
        ServiceRowSizeHelper serviceRowSizeHelper = new ServiceRowSizeHelper();
        serviceRowSizeHelper.fixTotalRowSize((PageRequest)request, pageResponse, -1L, rowList.size(), bHasMoreRows);
        long methodDuration = System.currentTimeMillis() - start;
        log.debug("Searched for Assest with Category (" + request.getCategoryPath() + ") in " + methodDuration + " ms.");
        return pageResponse;
    }

    protected void removeCategory(String categoryPath) throws SerializationException {
        log.info("USER:" + this.getCurrentUserName() + " REMOVING CATEGORY path: [" + categoryPath + "]");
        try {
            this.getRulesRepository().loadCategory(categoryPath).remove();
            this.getRulesRepository().save();
        }
        catch (RulesRepositoryException e) {
            log.info("Unable to remove category [" + categoryPath + "]. It is probably still used: " + e.getMessage());
            throw new DetailedSerializationException("Unable to remove category. It is probably still used.", e.getMessage());
        }
    }

    private String getCurrentUserName() {
        return this.getRulesRepository().getSession().getUserID();
    }
}

