/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.StandaloneEditorService;
import org.drools.guvnor.client.ruleeditor.standalone.StandaloneEditorInvocationParameters;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.StandaloneEditorServlet;
import org.drools.guvnor.server.standalonededitor.BRLRuleAssetProvider;
import org.drools.guvnor.server.standalonededitor.NewRuleAssetProvider;
import org.drools.guvnor.server.standalonededitor.UUIDRuleAssetProvider;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.BRXMLPersistence;
import org.drools.repository.RulesRepository;
import org.jboss.seam.annotations.In;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneEditorServiceImplementation
extends RemoteServiceServlet
implements StandaloneEditorService {
    @In
    public RulesRepository repository;
    private static final long serialVersionUID = 520L;

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    private RepositoryAssetService getAssetService() {
        return RepositoryServiceServlet.getAssetService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandaloneEditorInvocationParameters getInvocationParameters(String parametersUUID) throws DetailedSerializationException {
        HttpSession session = this.getThreadLocalRequest().getSession();
        try {
            Map sessionParameters = (Map)session.getAttribute(parametersUUID);
            if (sessionParameters == null || sessionParameters.isEmpty()) {
                throw new DetailedSerializationException("Error initializing Guided Editor", "No initial parameters were supplied");
            }
            boolean hideLHSInEditor = false;
            Object attribute = sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_HIDE_RULE_LHS_PARAMETER_NAME.getParameterName());
            if (attribute != null) {
                hideLHSInEditor = Boolean.parseBoolean(attribute.toString());
            }
            boolean hideRHSInEditor = false;
            attribute = sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_HIDE_RULE_RHS_PARAMETER_NAME.getParameterName());
            if (attribute != null) {
                hideRHSInEditor = Boolean.parseBoolean(attribute.toString());
            }
            boolean hideAttributesInEditor = false;
            attribute = sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_HIDE_RULE_ATTRIBUTES_PARAMETER_NAME.getParameterName());
            if (attribute != null) {
                hideAttributesInEditor = Boolean.parseBoolean(attribute.toString());
            }
            attribute = sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_CLIENT_NAME_PARAMETER_NAME.getParameterName());
            String clientName = attribute.toString();
            String[] validFactTypes = (String[])sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_VALID_FACT_TYPE_PARAMETER_NAME.getParameterName());
            StandaloneEditorInvocationParameters invocationParameters = new StandaloneEditorInvocationParameters();
            this.loadRuleAssetsFromSessionParameters(sessionParameters, invocationParameters);
            invocationParameters.setHideLHS(hideLHSInEditor);
            invocationParameters.setHideRHS(hideRHSInEditor);
            invocationParameters.setHideAttributes(hideAttributesInEditor);
            invocationParameters.setValidFactTypes(validFactTypes);
            invocationParameters.setClientName(clientName);
            StandaloneEditorInvocationParameters standaloneEditorInvocationParameters = invocationParameters;
            return standaloneEditorInvocationParameters;
        }
        finally {
            session.removeAttribute(parametersUUID);
        }
    }

    private void loadRuleAssetsFromSessionParameters(Map<String, Object> sessionParameters, StandaloneEditorInvocationParameters invocationParameters) throws DetailedSerializationException {
        UUIDRuleAssetProvider provider;
        String packageName = (String)sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_PACKAGE_PARAMETER_NAME.getParameterName());
        String categoryName = (String)sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_CATEGORY_PARAMETER_NAME.getParameterName());
        String[] initialBRL = (String[])sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_BRL_PARAMETER_NAME.getParameterName());
        String[] assetsUUIDs = (String[])sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_ASSETS_UUIDS_PARAMETER_NAME.getParameterName());
        boolean createNewAsset = false;
        Object attribute = sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_CREATE_NEW_ASSET_PARAMETER_NAME.getParameterName());
        if (attribute != null) {
            createNewAsset = Boolean.parseBoolean(attribute.toString());
        }
        String assetName = (String)sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_ASSET_NAME_PARAMETER_NAME.getParameterName());
        String assetFormat = (String)sessionParameters.get(StandaloneEditorServlet.STANDALONE_EDITOR_SERVLET_PARAMETERS.GE_ASSET_FORMAT_PARAMETER_NAME.getParameterName());
        if (createNewAsset) {
            provider = new NewRuleAssetProvider(packageName, categoryName, assetName, assetFormat);
            invocationParameters.setTemporalAssets(false);
        } else if (assetsUUIDs != null) {
            provider = new UUIDRuleAssetProvider(assetsUUIDs);
            invocationParameters.setTemporalAssets(false);
        } else if (initialBRL != null) {
            provider = new BRLRuleAssetProvider(packageName, initialBRL);
            invocationParameters.setTemporalAssets(true);
        } else {
            throw new IllegalStateException();
        }
        invocationParameters.setAssetsToBeEdited(provider.getRuleAssets());
    }

    public String[] getAsstesDRL(RuleAsset[] assets) throws SerializationException {
        String[] sources = new String[assets.length];
        for (int i = 0; i < assets.length; ++i) {
            sources[i] = this.getAssetService().buildAssetSource(assets[i]);
        }
        return sources;
    }

    public String[] getAsstesBRL(RuleAsset[] assets) throws SerializationException {
        String[] sources = new String[assets.length];
        BRLPersistence converter = BRXMLPersistence.getInstance();
        for (int i = 0; i < assets.length; ++i) {
            sources[i] = converter.marshal((RuleModel)assets[i].content);
        }
        return sources;
    }
}

