/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.AdminArchivedPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchivedAssetPageRowBuilder {
    public List<AdminArchivedPageRow> createRows(PageRequest pageRequest, Iterator<AssetItem> iterator) {
        int skipped = 0;
        Integer pageSize = pageRequest.getPageSize();
        int startRowIndex = pageRequest.getStartRowIndex();
        AssetItemFilter filter = new AssetItemFilter();
        ArrayList<AdminArchivedPageRow> rowList = new ArrayList<AdminArchivedPageRow>();
        while (iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem archivedAssetItem = iterator.next();
            if (!filter.accept((Object)archivedAssetItem, "read")) continue;
            if (skipped >= startRowIndex) {
                rowList.add(this.makeAdminArchivedPageRow(archivedAssetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private AdminArchivedPageRow makeAdminArchivedPageRow(AssetItem assetItem) {
        AdminArchivedPageRow row = new AdminArchivedPageRow();
        row.setUuid(assetItem.getUUID());
        row.setFormat(assetItem.getFormat());
        row.setName(assetItem.getName());
        row.setPackageName(assetItem.getPackageName());
        row.setLastContributor(assetItem.getLastContributor());
        row.setLastModified(assetItem.getLastModified().getTime());
        return row;
    }
}

