/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;
import org.drools.repository.RepositoryFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFullTextPageRowBuilder {
    public List<QueryPageRow> createRows(QueryPageRequest pageRequest, Iterator<AssetItem> iterator) {
        int skipped = 0;
        Integer pageSize = pageRequest.getPageSize();
        int startRowIndex = pageRequest.getStartRowIndex();
        PackageFilter filter = new PackageFilter();
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = iterator.next();
            if (!this.checkPackagePermissionHelper((RepositoryFilter)filter, assetItem, "package.readonly")) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow((AssetItem)assetItem));
            }
            ++skipped;
        }
        return rowList;
    }

    private boolean checkPackagePermissionHelper(RepositoryFilter filter, AssetItem item, String roleType) {
        return filter.accept((Object)this.getConfigDataHelper(item.getPackage().getUUID()), roleType);
    }

    private PackageConfigData getConfigDataHelper(String uuidStr) {
        PackageConfigData data = new PackageConfigData();
        data.uuid = uuidStr;
        return data;
    }
}

