/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.builder.RuleFlowProcessBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.brl.PortableObject;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.XmlProcessReader;
import org.jbpm.compiler.xml.XmlRuleFlowProcessDumper;
import org.jbpm.ruleflow.core.RuleFlowProcess;

/*
 * Exception performing whole class analysis ignored.
 */
public class BPMN2ProcessHandler
extends ContentHandler
implements ICompilable {
    private static final LoggingHelper log = LoggingHelper.getLogger(BPMN2ProcessHandler.class);

    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializationException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.content = content;
        } else {
            RuleFlowContentModel content = new RuleFlowContentModel();
            content.setXml(item.getContent());
            asset.content = content;
        }
    }

    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process = null;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            configuration.initSemanticModules();
            configuration.addSemanticModule((SemanticModule)new BPMNSemanticModule());
            configuration.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
            XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules(), BPMN2ProcessHandler.getClassLoader());
            try {
                process = (RuleFlowProcess)xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                reader.close();
                throw new Exception("Unable to read BPMN2 XML.", e);
            }
            reader.close();
        }
        catch (Exception e) {
            return null;
        }
        return process;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializationException {
        RuleFlowContentModel content = (RuleFlowContentModel)asset.content;
        if (content != null) {
            if (content.getXml() != null) {
                RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(content.getXml().getBytes()));
                if (process != null) {
                    RuleFlowProcessBuilder.updateProcess((RuleFlowProcess)process, (Collection)content.getNodes());
                    XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
                    String out = dumper.dump((WorkflowProcess)process);
                    repoAsset.updateContent(out);
                } else {
                    repoAsset.updateContent(content.getXml());
                }
            }
            if (content.getJson() != null) {
                try {
                    String xml = BPMN2ProcessHandler.serialize((String)("http://localhost:8080/designer/uuidRepository?profile=jbpm&action=toXML&pp=" + URLEncoder.encode(content.getPreprocessingdata(), "UTF-8")), (String)content.getJson());
                    content.setXml(xml);
                    repoAsset.updateContent(content.getXml());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(String serializeUrl, String modelJson) throws IOException {
        OutputStream out = null;
        InputStream content = null;
        ByteArrayOutputStream bos = null;
        try {
            modelJson = "&data=" + URLEncoder.encode(modelJson, "UTF-8");
            byte[] bytes = modelJson.getBytes("UTF-8");
            HttpURLConnection connection = (HttpURLConnection)new URL(serializeUrl).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            connection.setDoOutput(true);
            out = connection.getOutputStream();
            out.write(bytes);
            out.close();
            content = connection.getInputStream();
            bos = new ByteArrayOutputStream();
            int b = 0;
            while ((b = content.read()) > -1) {
                bos.write(b);
            }
            bytes = bos.toByteArray();
            content.close();
            bos.close();
            String string = new String(bytes);
            return string;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (content != null) {
                    content.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void ruleFlowAttached(AssetItem item) {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getPackageName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlBPMNProcessDumper dumper = XmlBPMNProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed BPMN2 process package from " + originalPackageName + " to " + packageName);
        }
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addProcessFromXml((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }

    public void compile(BRMSPackageBuilder builder, RuleAsset asset, ContentPackageAssembler.ErrorLogger logger) {
    }

    public void assembleProcessSource(PortableObject assetContent, StringBuilder stringBuilder) {
        RuleFlowContentModel content = (RuleFlowContentModel)assetContent;
        if (content.getXml() != null && content.getXml().length() > 0) {
            stringBuilder.append(content.getXml());
        } else if (content.getJson() != null && content.getJson().length() > 0) {
            try {
                String xml = BPMN2ProcessHandler.serialize((String)("http://localhost:8080/designer/uuidRepository?profile=jbpm&action=toXML&pp=" + URLEncoder.encode(content.getPreprocessingdata(), "UTF-8")), (String)content.getJson());
                stringBuilder.append(StringEscapeUtils.escapeXml((String)xml));
            }
            catch (IOException e) {
                log.error("Exception converting to xml: " + e.getMessage());
            }
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = BPMN2ProcessHandler.class.getClassLoader();
        }
        return cl;
    }
}

