/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.jaxrs;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.jaxrs.Resource;
import org.drools.guvnor.server.jaxrs.Translator;
import org.drools.guvnor.server.jaxrs.jaxb.Asset;
import org.drools.guvnor.server.jaxrs.jaxb.Package;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageHistoryIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.jboss.seam.annotations.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="PackageResource")
@Path(value="/packages")
public class PackageResource
extends Resource {
    @GET
    @Produces(value={"application/atom+xml"})
    public Feed getPackagesAsFeed() {
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.getAbdera().newFeed();
        f.setTitle("Packages");
        f.setBaseUri(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]).toString());
        PackageIterator iter = this.repository.listPackages();
        while (iter.hasNext()) {
            try {
                PackageItem item = iter.next();
                Entry e = factory.getAbdera().newEntry();
                e.setTitle(item.getName());
                Link l = factory.newLink();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages").path(item.getName()).build(new Object[0]).toString());
                e.addLink(l);
                f.addEntry(e);
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return f;
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<Package> getPackagesAsJAXB() {
        ArrayList<Package> ret = new ArrayList<Package>();
        PackageIterator iter = this.repository.listPackages();
        while (iter.hasNext()) {
            ret.add(Translator.ToPackage((PackageItem)iter.next(), (UriInfo)this.uriInfo));
        }
        return ret;
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json", "application/xml"})
    public Package createPackageFromDRLAndReturnAsJaxB(InputStream is, @Context UriInfo uriInfo) throws IOException, DroolsParserException {
        String packageName = RepositoryServlet.getFileManager().importClassicDRL(is, null);
        Package p = Translator.ToPackage((PackageItem)this.repository.loadPackage(packageName), (UriInfo)uriInfo);
        return p;
    }

    @POST
    @Consumes(value={"application/atom+xml"})
    @Produces(value={"application/atom+xml"})
    public Response createPackageFromAtom(Entry entry, @Context UriInfo uriInfo) {
        this.repository.createPackage(entry.getTitle(), entry.getSummary());
        URI uri = uriInfo.getBaseUriBuilder().path("packages").path(entry.getTitle()).build(new Object[0]);
        entry.setBaseUri(uri.toString());
        return Response.created((URI)uri).entity((Object)entry).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public void createPackageFromJAXB(Package p) {
        this.repository.createPackage(p.getTitle(), p.getDescription());
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/atom+xml"})
    public Entry getPackageAsEntry(@PathParam(value="packageName") String packageName) {
        return Translator.ToPackageEntryAbdera((PackageItem)this.repository.loadPackage(packageName), (UriInfo)this.uriInfo);
    }

    @GET
    @Path(value="{packageName}")
    @Produces(value={"application/json", "application/xml"})
    public Package getPackageAsJAXB(@PathParam(value="packageName") String packageName) {
        return Translator.ToPackage((PackageItem)this.repository.loadPackage(packageName), (UriInfo)this.uriInfo);
    }

    @GET
    @Path(value="{packageName}/source")
    @Produces(value={"text/plain"})
    public Response getPackageSource(@PathParam(value="packageName") String packageName) {
        PackageItem item = this.repository.loadPackage(packageName);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        String fileName = packageName;
        String drl = asm.getDRL();
        return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
    }

    @GET
    @Path(value="{packageName}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getPackageBinary(@PathParam(value="packageName") String packageName) throws SerializationException {
        byte[] result;
        PackageItem p = this.repository.loadPackage(packageName);
        String fileName = packageName + ".pkg";
        if (p.isBinaryUpToDate()) {
            result = p.getCompiledPackageBytes();
        } else {
            StringBuilder errs = new StringBuilder();
            BuilderResult builderResult = this.packageService.buildPackage(p.getUUID(), true);
            if (builderResult != null) {
                errs.append("Unable to build package name [").append(packageName).append("]\n");
                StringBuilder buf = this.createStringBuilderFrom(builderResult);
                return Response.status((int)500).entity((Object)buf.toString()).build();
            }
            result = this.repository.loadPackage(packageName).getCompiledPackageBytes();
        }
        return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
    }

    private StringBuilder createStringBuilderFrom(BuilderResult res) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.getLines().size(); ++i) {
            buf.append(((BuilderResultLine)res.getLines().get(i)).toString());
            buf.append('\n');
        }
        return buf;
    }

    @GET
    @Path(value="{packageName}/versions")
    @Produces(value={"application/atom+xml"})
    public Feed getPackageVersionsAsFeed(@PathParam(value="packageName") String packageName) throws SerializationException {
        PackageItem p = this.repository.loadPackage(packageName);
        Factory factory = Abdera.getNewFactory();
        Feed f = factory.getAbdera().newFeed();
        f.setTitle("Version history of " + p.getName());
        f.setBaseUri(this.uriInfo.getBaseUriBuilder().path("packages").build(new Object[0]).toString());
        PackageHistoryIterator it = p.getHistory();
        while (it.hasNext()) {
            try {
                PackageItem historicalPackage = it.next();
                if (historicalPackage.getVersionNumber() == 0L) continue;
                Entry e = factory.getAbdera().newEntry();
                e.setTitle(Long.toString(historicalPackage.getVersionNumber()));
                e.setUpdated(historicalPackage.getLastModified().getTime());
                Link l = factory.newLink();
                l.setHref(this.uriInfo.getBaseUriBuilder().path("packages").path(p.getName()).path("versions").path(Long.toString(historicalPackage.getVersionNumber())).build(new Object[0]).toString());
                e.addLink(l);
                f.addEntry(e);
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return f;
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}")
    @Produces(value={"application/atom+xml"})
    public Entry getHistoricalPackageAsEntry(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        return Translator.ToPackageEntryAbdera((PackageItem)this.repository.loadPackage(packageName, versionNumber), (UriInfo)this.uriInfo);
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/source")
    @Produces(value={"text/plain"})
    public Response getHistoricalPackageSource(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) {
        PackageItem item = this.repository.loadPackage(packageName, versionNumber);
        ContentPackageAssembler asm = new ContentPackageAssembler(item, false);
        String fileName = packageName;
        String drl = asm.getDRL();
        return Response.ok((Object)drl).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
    }

    @GET
    @Path(value="{packageName}/versions/{versionNumber}/binary")
    @Produces(value={"application/octet-stream"})
    public Response getHistoricalPackageBinary(@PathParam(value="packageName") String packageName, @PathParam(value="versionNumber") long versionNumber) throws SerializationException {
        PackageItem p = this.repository.loadPackage(packageName, versionNumber);
        byte[] result = p.getCompiledPackageBytes();
        if (result != null) {
            String fileName = packageName + ".pkg";
            return Response.ok((Object)result).header("Content-Disposition", (Object)("attachment; filename=" + fileName)).build();
        }
        return Response.status((int)500).entity((Object)"This package version has no compiled binary").type("text/plain").build();
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/atom+xml"})
    public Feed getAssetsAsAtom(@PathParam(value="packageName") String packageName) {
        Factory factory = Abdera.getNewFactory();
        Feed feed = factory.getAbdera().newFeed();
        PackageItem p = this.repository.loadPackage(packageName);
        feed.setTitle(p.getTitle() + "-asset-feed");
        Iterator iter = p.getAssets();
        while (iter.hasNext()) {
            feed.addEntry(Translator.ToAssetEntryAbdera((AssetItem)((AssetItem)iter.next()), (UriInfo)this.uriInfo));
        }
        return feed;
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/atom+xml"})
    public void updatePackageFromAtom(@PathParam(value="packageName") String packageName, Entry entry) {
        ExtensibleElement archivedExtension;
        ExtensibleElement metadataExtension;
        PackageItem p = this.repository.loadPackage(packageName);
        p.checkout();
        if (entry.getSummary() != null) {
            p.updateDescription(entry.getSummary());
        }
        if (entry.getAuthor() != null) {
            // empty if block
        }
        if ((metadataExtension = (ExtensibleElement)entry.getExtension(Translator.METADATA)) != null && (archivedExtension = (ExtensibleElement)metadataExtension.getExtension(Translator.ARCHIVED)) != null) {
            p.archiveItem(Boolean.getBoolean(archivedExtension.getSimpleExtension(Translator.VALUE)));
        }
        p.checkin("Update from ATOM.");
        this.repository.save();
    }

    @DELETE
    @Path(value="{packageName}")
    public void deletePackage(@PathParam(value="packageName") String packageName) {
        PackageItem p = this.repository.loadPackage(packageName);
        this.packageService.removePackage(p.getUUID());
    }

    @GET
    @Path(value="{packageName}/assets")
    @Produces(value={"application/json", "application/xml"})
    public Collection<Asset> getAssetsAsJAXB(@PathParam(value="packageName") String packageName) {
        ArrayList<Asset> ret = Collections.EMPTY_LIST;
        PackageItem p = this.repository.loadPackage(packageName);
        Iterator iter = p.getAssets();
        if (iter.hasNext()) {
            ret = new ArrayList<Asset>();
        }
        while (iter.hasNext()) {
            ret.add(Translator.ToAsset((AssetItem)((AssetItem)iter.next()), (UriInfo)this.uriInfo));
        }
        return ret;
    }

    @PUT
    @Path(value="{packageName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updatePackageFromJAXB(@PathParam(value="packageName") String packageName, Package p) {
        PackageItem item = this.repository.loadPackage(packageName);
        item.checkout();
        item.updateDescription(p.getDescription());
        item.updateTitle(p.getTitle());
        item.checkin(p.getCheckInComment());
        this.repository.save();
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/atom+xml"})
    public Entry getAssetAsAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        Entry ret = null;
        PackageItem item = this.repository.loadPackage(packageName);
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            if (!a.getName().equals(assetName)) continue;
            ret = Translator.ToAssetEntryAbdera((AssetItem)a, (UriInfo)this.uriInfo);
            break;
        }
        return ret;
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}")
    @Produces(value={"application/json", "application/xml"})
    public Asset getAssetAsJaxB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        Asset ret = null;
        PackageItem item = this.repository.loadPackage(packageName);
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            if (!a.getName().equals(assetName)) continue;
            ret = Translator.ToAsset((AssetItem)a, (UriInfo)this.uriInfo);
            break;
        }
        return ret;
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/binary")
    @Produces(value={"application/octet-stream"})
    public InputStream getAssetBinary(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        InputStream ret = null;
        PackageItem item = this.repository.loadPackage(packageName);
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            if (!a.getName().equals(assetName)) continue;
            ret = a.getBinaryContentAttachment();
            break;
        }
        return ret;
    }

    @GET
    @Path(value="{packageName}/assets/{assetName}/source")
    @Produces(value={"text/plain"})
    public String getAssetSource(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        String ret = null;
        if (this.repository.containsPackage(packageName)) {
            PackageItem item = this.repository.loadPackage(packageName);
            Iterator iter = item.getAssets();
            while (iter.hasNext()) {
                AssetItem a = (AssetItem)iter.next();
                if (!a.getName().equals(assetName)) continue;
                ret = a.getContent();
                break;
            }
            return ret;
        }
        throw new WebApplicationException((Throwable)new RuntimeException("Package '" + packageName + "' does not exist!"));
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/atom+xml"})
    public void updateAssetFromAtom(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Entry assetEntry) {
        AssetItem ai = null;
        PackageItem item = this.repository.loadPackage(packageName);
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            if (!a.getName().equals(assetName)) continue;
            ai = a;
            break;
        }
        ai.checkout();
        ai.updateTitle(assetEntry.getTitle());
        ai.updateDescription(assetEntry.getSummary());
        ai.updateContent(assetEntry.getContent());
        ai.checkin("Check-in (summary): " + assetEntry.getSummary());
        this.repository.save();
    }

    @PUT
    @Path(value="{packageName}/assets/{assetName}")
    @Consumes(value={"application/json", "application/xml"})
    public void updateAssetFromJAXB(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName, Asset asset) {
        AssetItem ai = null;
        PackageItem pi = this.repository.loadPackage(packageName);
        Iterator iter = pi.getAssets();
        while (iter.hasNext()) {
            AssetItem item = (AssetItem)iter.next();
            if (!item.getName().equals(assetName)) continue;
            ai = item;
            break;
        }
        ai.checkout();
        ai.updateTitle(asset.getMetadata().getTitle());
        ai.updateDescription(asset.getDescription());
        ai.checkin(asset.getCheckInComment());
        this.repository.save();
    }

    @DELETE
    @Path(value="{packageName}/assets/{assetName}/")
    public void deleteAsset(@PathParam(value="packageName") String packageName, @PathParam(value="assetName") String assetName) {
        AssetItem asset = null;
        PackageItem item = this.repository.loadPackage(packageName);
        Iterator iter = item.getAssets();
        while (iter.hasNext()) {
            AssetItem a = (AssetItem)iter.next();
            if (!a.getName().equals(assetName)) continue;
            asset = a;
            break;
        }
        this.assetService.archiveAsset(asset.getUUID());
    }
}

