/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.drools.core.util.DateUtils;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.server.security.CapabilityCalculator;
import org.drools.guvnor.server.security.RoleBasedPermissionManager;
import org.drools.guvnor.server.security.RoleBasedPermissionResolver;
import org.drools.repository.utils.IOUtils;
import org.jboss.seam.Component;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class SecurityServiceImpl
implements SecurityService {
    public static final String GUEST_LOGIN = "guest";
    private static final Logger log = LoggerFactory.getLogger(SecurityServiceImpl.class);
    static final Map<String, String> PREFERENCES = SecurityServiceImpl.loadPrefs();
    private static String[] serializationProperties = new String[]{"drools.serialization.private.keyStoreURL", "drools.serialization.private.keyStorePwd", "drools.serialization.private.keyAlias", "drools.serialization.private.keyPwd", "drools.serialization.public.keyStoreURL", "drools.serialization.public.keyStorePwd"};

    public boolean login(String userName, String password) {
        if (userName == null || userName.trim().equals("")) {
            userName = "logInAdmin";
        }
        log.info("Logging in user [" + userName + "]");
        if (Contexts.isApplicationContextActive()) {
            char[] bannedChars = new char[]{'\'', '*', '[', ']'};
            for (int i = 0; i < bannedChars.length; ++i) {
                char c = bannedChars[i];
                if (userName.indexOf(c) < 0) continue;
                log.error("Not a valid name character " + c);
                return false;
            }
            Identity.instance().getCredentials().setUsername(userName);
            Identity.instance().getCredentials().setPassword(password);
            try {
                Identity.instance().authenticate();
            }
            catch (LoginException e) {
                log.error("Unable to login.", (Throwable)e);
                return false;
            }
            return Identity.instance().isLoggedIn();
        }
        return true;
    }

    public UserSecurityContext getCurrentUser() {
        if (Contexts.isApplicationContextActive()) {
            if (!Identity.instance().isLoggedIn()) {
                return new UserSecurityContext(this.checkAutoLogin());
            }
            return new UserSecurityContext(Identity.instance().getCredentials().getUsername());
        }
        return new UserSecurityContext("SINGLE USER MODE (DEBUG) USE ONLY");
    }

    private String checkAutoLogin() {
        Identity id = Identity.instance();
        id.getCredentials().setUsername("guest");
        try {
            id.authenticate();
        }
        catch (LoginException e) {
            return null;
        }
        if (id.isLoggedIn()) {
            return id.getCredentials().getUsername();
        }
        return null;
    }

    public Capabilities getUserCapabilities() {
        if (Contexts.isApplicationContextActive()) {
            if (Identity.instance().hasRole("logInAdmin")) {
                return Capabilities.all((Map)PREFERENCES);
            }
            RoleBasedPermissionResolver resolver = (RoleBasedPermissionResolver)Component.getInstance((String)"org.jboss.seam.security.roleBasedPermissionResolver");
            if (!resolver.isEnableRoleBasedAuthorization()) {
                return Capabilities.all((Map)PREFERENCES);
            }
            RoleBasedPermissionManager permManager = (RoleBasedPermissionManager)Component.getInstance((String)"roleBasedPermissionManager");
            List permissions = permManager.getRoleBasedPermission();
            if (permissions.size() == 0) {
                Identity.instance().logout();
                throw new AuthorizationException("This user has no permissions setup.");
            }
            if (this.invalidSecuritySerilizationSetup()) {
                Identity.instance().logout();
                throw new AuthorizationException(" Configuration error - Please refer to the Administration Guide section on installation. You must configure a key store before proceding.  ");
            }
            return new CapabilityCalculator().calcCapabilities(permissions, PREFERENCES);
        }
        if (this.invalidSecuritySerilizationSetup()) {
            throw new AuthorizationException(" Configuration error - Please refer to the Administration Guide section on installation. You must configure a key store before proceding.  ");
        }
        return Capabilities.all((Map)PREFERENCES);
    }

    private boolean invalidSecuritySerilizationSetup() {
        String ssecurity = System.getProperty("drools.serialization.sign");
        if (ssecurity != null && ssecurity.equalsIgnoreCase("true")) {
            for (String nextProp : serializationProperties) {
                String nextPropVal = System.getProperty(nextProp);
                if (nextPropVal != null && !nextPropVal.trim().equals("")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadPrefs() {
        Properties ps = new Properties();
        InputStream in = null;
        try {
            in = SecurityServiceImpl.class.getResourceAsStream("/preferences.properties");
            ps.load(in);
            HashMap<String, String> prefs = new HashMap<String, String>();
            for (Object o : ps.keySet()) {
                String feature = (String)o;
                prefs.put(feature, ps.getProperty(feature));
            }
            SecurityServiceImpl.setSystemProperties(prefs);
            HashMap<String, String> hashMap = prefs;
            return hashMap;
        }
        catch (IOException e) {
            log.info("Couldn't find preferences.properties - using defaults");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static void setSystemProperties(Map<String, String> prefs) {
        String dateFormat = "drools.dateformat";
        String defaultLanguage = "drools.defaultlanguage";
        String defaultCountry = "drools.defaultcountry";
        String serializationSign = "drools.serialization.sign";
        String privateKeyStoreURL = "drools.serialization.private.keyStoreURL";
        String privateKeyStorePwd = "drools.serialization.private.keyStorePwd";
        String privateKeyAlias = "drools.serialization.private.keyAlias";
        String privateKeyPwd = "drools.serialization.private.keyPwd";
        String publicKeyStoreURL = "drools.serialization.public.keyStoreURL";
        String publicKeyStorePwd = "drools.serialization.public.keyStorePwd";
        if (prefs.containsKey("drools.dateformat")) {
            System.setProperty("drools.dateformat", prefs.get("drools.dateformat"));
        }
        if (prefs.containsKey("drools.defaultlanguage")) {
            System.setProperty("drools.defaultlanguage", prefs.get("drools.defaultlanguage"));
        }
        if (prefs.containsKey("drools.defaultcountry")) {
            System.setProperty("drools.defaultcountry", prefs.get("drools.defaultcountry"));
        }
        if (prefs.containsKey("drools.serialization.sign")) {
            System.setProperty("drools.serialization.sign", prefs.get("drools.serialization.sign"));
        }
        if (prefs.containsKey("drools.serialization.private.keyStoreURL")) {
            System.setProperty("drools.serialization.private.keyStoreURL", prefs.get("drools.serialization.private.keyStoreURL"));
        }
        if (prefs.containsKey("drools.serialization.private.keyStorePwd")) {
            System.setProperty("drools.serialization.private.keyStorePwd", prefs.get("drools.serialization.private.keyStorePwd"));
        }
        if (prefs.containsKey("drools.serialization.private.keyAlias")) {
            System.setProperty("drools.serialization.private.keyAlias", prefs.get("drools.serialization.private.keyAlias"));
        }
        if (prefs.containsKey("drools.serialization.private.keyPwd")) {
            System.setProperty("drools.serialization.private.keyPwd", prefs.get("drools.serialization.private.keyPwd"));
        }
        if (prefs.containsKey("drools.serialization.public.keyStoreURL")) {
            System.setProperty("drools.serialization.public.keyStoreURL", prefs.get("drools.serialization.public.keyStoreURL"));
        }
        if (prefs.containsKey("drools.serialization.public.keyStorePwd")) {
            System.setProperty("drools.serialization.public.keyStorePwd", prefs.get("drools.serialization.public.keyStorePwd"));
        }
        if (!prefs.containsKey("drools.dateformat")) {
            prefs.put("drools.dateformat", DateUtils.getDateFormatMask());
        }
        if (!prefs.containsKey("drools.defaultlanguage")) {
            prefs.put("drools.defaultlanguage", System.getProperty("drools.defaultlanguage"));
        }
        if (!prefs.containsKey("drools.defaultcountry")) {
            prefs.put("drools.defaultcountry", System.getProperty("drools.defaultcountry"));
        }
    }
}

