/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.guvnor.client.explorer.Preferences;
import org.drools.guvnor.client.util.DateConverter;

public class JVMDateConverter
implements DateConverter {
    private static final String DATE_FORMAT = Preferences.getStringPref((String)"drools.dateformat");
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat(DATE_FORMAT);
    private static DateConverter INSTANCE;

    public static synchronized DateConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JVMDateConverter();
        }
        return INSTANCE;
    }

    private JVMDateConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        SimpleDateFormat simpleDateFormat = FORMATTER;
        synchronized (simpleDateFormat) {
            return FORMATTER.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String text) {
        try {
            SimpleDateFormat simpleDateFormat = FORMATTER;
            synchronized (simpleDateFormat) {
                return FORMATTER.parse(text);
            }
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

