/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import org.drools.guvnor.client.rpc.AbstractPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRowSizeHelper {
    public void fixTotalRowSize(PageRequest request, PageResponse<? extends AbstractPageRow> response, long totalRowsCount, int rowsRetrievedCount, boolean bHasMoreRows) {
        if (totalRowsCount > Integer.MAX_VALUE) {
            throw new IllegalStateException("The totalRowSize (" + totalRowsCount + ") is too big.");
        }
        if (totalRowsCount == -1L) {
            if (!bHasMoreRows) {
                response.setTotalRowSize(request.getStartRowIndex() + rowsRetrievedCount);
                response.setTotalRowSizeExact(true);
            } else {
                response.setTotalRowSize(-1);
                response.setTotalRowSizeExact(false);
            }
        } else {
            response.setTotalRowSize((int)totalRowsCount);
            response.setTotalRowSizeExact(true);
        }
    }
}

