/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.Reader;
import java.io.StringReader;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.guvnor.client.rpc.AnalysisReport;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.VerifierReportCreator;
import org.drools.io.ResourceFactory;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.verifier.Verifier;
import org.drools.verifier.VerifierError;
import org.drools.verifier.builder.ScopesAgendaFilter;
import org.drools.verifier.data.VerifierReport;

public class VerifierRunner {
    private Verifier verifier;
    private PackageItem packageItem;

    public VerifierRunner(Verifier verifier) {
        this.verifier = verifier;
    }

    public AnalysisReport verify(PackageItem packageItem, ScopesAgendaFilter scopesAgendaFilter) {
        this.packageItem = packageItem;
        this.addHeaderToVerifier();
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"dsl"}), ResourceType.DSL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"model.drl"}), ResourceType.DRL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"function"}), ResourceType.DRL);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"dslr"}), ResourceType.DSLR);
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"xls"}), ResourceType.DTABLE);
        this.addGuidedDecisionTablesToVerifier();
        this.addDRLRulesToVerifier();
        this.addToVerifier(packageItem.listAssetsByFormat(new String[]{"brl"}), ResourceType.BRL);
        this.fireAnalysis(scopesAgendaFilter);
        VerifierReport report = this.verifier.getResult();
        return VerifierReportCreator.doReport((VerifierReport)report);
    }

    private void fireAnalysis(ScopesAgendaFilter scopesAgendaFilter) throws RuntimeException {
        this.verifier.fireAnalysis(scopesAgendaFilter);
        if (this.verifier.hasErrors()) {
            StringBuilder message = new StringBuilder("Verifier Errors:\n");
            for (VerifierError verifierError : this.verifier.getErrors()) {
                message.append("\t");
                message.append(verifierError.getMessage());
                message.append("\n");
            }
            throw new RuntimeException(message.toString());
        }
    }

    private void addHeaderToVerifier() {
        StringBuilder header = new StringBuilder();
        header.append("package " + this.packageItem.getName() + "\n");
        header.append(DroolsHeader.getDroolsHeader((PackageItem)this.packageItem) + "\n");
        this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(header.toString())), ResourceType.DRL);
    }

    private void addToVerifier(AssetItemIterator assets, ResourceType resourceType) {
        while (assets.hasNext()) {
            AssetItem asset = assets.next();
            if (asset.isArchived() || asset.getDisabled()) continue;
            if (resourceType == ResourceType.DTABLE) {
                DecisionTableConfiguration dtableconfiguration = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                dtableconfiguration.setInputType(DecisionTableInputType.XLS);
                this.verifier.addResourcesToVerify(ResourceFactory.newByteArrayResource((byte[])asset.getBinaryContentAsBytes()), resourceType, (ResourceConfiguration)dtableconfiguration);
                continue;
            }
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(asset.getContent())), resourceType);
        }
    }

    private void addGuidedDecisionTablesToVerifier() {
        AssetItemIterator rules = this.packageItem.listAssetsByFormat(new String[]{"gdst"});
        while (rules.hasNext()) {
            AssetItem rule = rules.next();
            ContentHandler contentHandler = ContentManager.getHandler((String)rule.getFormat());
            if (!contentHandler.isRuleAsset()) continue;
            IRuleAsset ruleAsset = (IRuleAsset)contentHandler;
            String drl = ruleAsset.getRawDRL(rule);
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        }
    }

    private void addDRLRulesToVerifier() {
        AssetItemIterator rules = this.packageItem.listAssetsByFormat(new String[]{"drl"});
        while (rules.hasNext()) {
            AssetItem rule = rules.next();
            ContentHandler contentHandler = ContentManager.getHandler((String)rule.getFormat());
            if (!contentHandler.isRuleAsset()) continue;
            IRuleAsset ruleAsset = (IRuleAsset)contentHandler;
            String drl = ruleAsset.getRawDRL(rule);
            this.verifier.addResourcesToVerify(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        }
    }
}

