/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.admin.PermissionViewer;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rulelist.OpenItemCommand;
import org.drools.guvnor.client.widgets.tables.PermissionsPagedTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionViewer
extends Composite {
    private static Images images = (Images)GWT.create(Images.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    private VerticalPanel layout;
    private PermissionsPagedTable table;

    public PermissionViewer() {
        PrettyFormLayout pf = new PrettyFormLayout();
        VerticalPanel header = new VerticalPanel();
        Label caption = new Label(this.constants.PermissionDetails());
        caption.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
        header.add((Widget)caption);
        header.add(this.howToTurnOn());
        pf.addHeader(images.userPermissionsLarge(), (Widget)header);
        this.layout = new VerticalPanel();
        this.layout.setHeight("100%");
        this.layout.setWidth("100%");
        pf.startSection();
        pf.addRow((Widget)this.layout);
        pf.endSection();
        this.setupWidget();
        this.initWidget((Widget)pf);
    }

    private Widget howToTurnOn() {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new HTML("<small><i>" + this.constants.TipAuthEnable() + "</i></small>"));
        InfoPopup pop = new InfoPopup(this.constants.EnablingAuthorization(), this.constants.EnablingAuthPopupTip());
        hp.add((Widget)pop);
        return hp;
    }

    private void setupWidget() {
        1 newUserCommand = new /* Unavailable Anonymous Inner Class!! */;
        2 deleteUserCommand = new /* Unavailable Anonymous Inner Class!! */;
        3 openSelectedCommand = new /* Unavailable Anonymous Inner Class!! */;
        this.table = new PermissionsPagedTable((Command)newUserCommand, (Command)deleteUserCommand, (OpenItemCommand)openSelectedCommand);
        this.layout.add((Widget)this.table);
    }

    private void showEditor(String userName) {
        LoadingPopup.showMessage((String)this.constants.LoadingUsersPermissions());
        RepositoryServiceFactory.getService().retrieveUserPermissions(userName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget doPermsPanel(Map<String, List<String>> perms, Panel vp) {
        vp.clear();
        for (Map.Entry<String, List<String>> perm : perms.entrySet()) {
            if (perm.getKey().equals("logInAdmin")) {
                HorizontalPanel h = new HorizontalPanel();
                h.add((Widget)new HTML("<b>" + this.constants.ThisUserIsAnAdministrator() + "</b>"));
                Button del = new Button(this.constants.RemoveAdminRights());
                del.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                h.add((Widget)del);
                vp.add((Widget)h);
                continue;
            }
            String permType = perm.getKey();
            List<String> permList = perm.getValue();
            Grid g = new Grid(permList.size() + 1, 3);
            g.setWidget(0, 0, (Widget)new HTML("<b>[" + permType + "] for:</b>"));
            for (int i = 0; i < permList.size(); ++i) {
                String p = permList.get(i);
                ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemovePermission(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                g.setWidget(i + 1, 1, (Widget)new SmallLabel(p));
                g.setWidget(i + 1, 2, (Widget)del);
            }
            vp.add((Widget)g);
        }
        ImageButton newPermission = new ImageButton(images.newItem(), this.constants.AddANewPermission(), this.createClickHandlerForNewPersmissionImageButton(perms, vp));
        vp.add((Widget)newPermission);
        return vp;
    }

    private ClickHandler createClickHandlerForNewPersmissionImageButton(Map<String, List<String>> perms, Panel vp) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Images access$000() {
        return images;
    }

    static /* synthetic */ Constants access$100(PermissionViewer x0) {
        return x0.constants;
    }

    static /* synthetic */ PermissionsPagedTable access$200(PermissionViewer x0) {
        return x0.table;
    }

    static /* synthetic */ void access$300(PermissionViewer x0, String x1) {
        x0.showEditor(x1);
    }

    static /* synthetic */ Widget access$400(PermissionViewer x0, Map x1, Panel x2) {
        return x0.doPermsPanel(x1, x2);
    }
}

