/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import org.drools.guvnor.client.admin.PerspectiveEditorPopUpView;
import org.drools.guvnor.client.rpc.IFramePerspectiveConfiguration;
import org.drools.guvnor.client.util.SaveCommand;

public class PerspectiveEditorPopUp
implements PerspectiveEditorPopUpView.Presenter {
    private final PerspectiveEditorPopUpView view;
    private SaveCommand saveCommand;
    private String uuid;

    public PerspectiveEditorPopUp(PerspectiveEditorPopUpView view) {
        this.view = view;
        view.setPresenter((PerspectiveEditorPopUpView.Presenter)this);
    }

    public void show(SaveCommand saveCommand) {
        this.saveCommand = saveCommand;
        this.view.show();
    }

    public void onSave() {
        String name = this.view.getName();
        String url = this.view.getUrl();
        if (this.isNullOrEmpty(name)) {
            this.view.showNameCanNotBeEmptyWarning();
        } else if (this.isNullOrEmpty(url)) {
            this.view.showUrlCanNotBeEmptyWarning();
        } else {
            this.save(name, url);
        }
    }

    public void onCancel() {
        this.view.setName("");
        this.view.setUrl("");
        this.view.hide();
    }

    private void save(String name, String url) {
        IFramePerspectiveConfiguration newConfiguration = new IFramePerspectiveConfiguration();
        newConfiguration.setUuid(this.uuid);
        newConfiguration.setName(name);
        newConfiguration.setUrl(url);
        this.saveCommand.save((Object)newConfiguration);
    }

    private boolean isNullOrEmpty(String name) {
        return name == null || name.length() == 0;
    }

    public void setConfiguration(IFramePerspectiveConfiguration iFramePerspectiveConfiguration) {
        this.uuid = iFramePerspectiveConfiguration.getUuid();
        this.view.setName(iFramePerspectiveConfiguration.getName());
        this.view.setUrl(iFramePerspectiveConfiguration.getUrl());
    }

    public void hide() {
        this.view.hide();
    }
}

