/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.admin.PerspectiveEditorPopUp;
import org.drools.guvnor.client.admin.PerspectiveEditorPopUpView;
import org.drools.guvnor.client.admin.PerspectiveEditorPopUpViewImpl;
import org.drools.guvnor.client.admin.PerspectivesManagerView;
import org.drools.guvnor.client.admin.PerspectivesManagerViewImpl;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.IFramePerspectiveConfiguration;
import org.drools.guvnor.client.util.SaveCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectivesManagerViewImpl
extends Composite
implements PerspectivesManagerView {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static PerspectivesManagerViewImplBinder uiBinder = (PerspectivesManagerViewImplBinder)GWT.create(PerspectivesManagerViewImplBinder.class);
    private PerspectivesManagerView.Presenter presenter;
    @UiField
    ListBox perspectivesList;
    @UiField
    Button newPerspective;
    @UiField
    Button editPerspective;
    @UiField
    Button removePerspective;
    private PerspectiveEditorPopUp perspectiveEditorPopUp;

    public PerspectivesManagerViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setPresenter(PerspectivesManagerView.Presenter presenter) {
        this.presenter = presenter;
    }

    public String getSelectedPerspectiveUuid() {
        int selectedIndex = this.perspectivesList.getSelectedIndex();
        if (selectedIndex < 0) {
            return null;
        }
        return this.perspectivesList.getValue(selectedIndex);
    }

    public void addPerspective(String uuid, String name) {
        this.perspectivesList.addItem(name, uuid);
    }

    public void openPopUp(SaveCommand<IFramePerspectiveConfiguration> saveCommand) {
        this.perspectiveEditorPopUp = new PerspectiveEditorPopUp((PerspectiveEditorPopUpView)new PerspectiveEditorPopUpViewImpl());
        this.perspectiveEditorPopUp.show(saveCommand);
    }

    public void openPopUp(SaveCommand<IFramePerspectiveConfiguration> saveCommand, IFramePerspectiveConfiguration iFramePerspectiveConfiguration) {
        this.perspectiveEditorPopUp = new PerspectiveEditorPopUp((PerspectiveEditorPopUpView)new PerspectiveEditorPopUpViewImpl());
        this.perspectiveEditorPopUp.setConfiguration(iFramePerspectiveConfiguration);
        this.perspectiveEditorPopUp.show(saveCommand);
    }

    public void closePopUp() {
        this.perspectiveEditorPopUp.hide();
    }

    public void removePerspective(String uuid) {
        for (int i = 0; i < this.perspectivesList.getItemCount(); ++i) {
            if (!this.perspectivesList.getValue(i).equals(uuid)) continue;
            this.perspectivesList.removeItem(i);
            break;
        }
    }

    public Collection<String> getListOfPerspectiveNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.perspectivesList.getItemCount(); ++i) {
            result.add(this.perspectivesList.getItemText(i));
        }
        return result;
    }

    public void showNameTakenError(String name) {
        ErrorPopup.showMessage((String)this.constants.NameTakenForModel(name));
    }

    public void showNoSelectedPerspectiveError() {
        ErrorPopup.showMessage((String)this.constants.PleaseSelectAPerspective());
    }

    @UiHandler(value={"newPerspective"})
    public void addNewPerspective(ClickEvent event) {
        this.presenter.onAddNewPerspective();
    }

    @UiHandler(value={"editPerspective"})
    public void editPerspective(ClickEvent event) {
        try {
            this.presenter.onEditPerspective();
        }
        catch (SerializationException e) {
            ErrorPopup.showMessage((String)this.constants.FailedToLoadPerspective());
        }
    }

    @UiHandler(value={"removePerspective"})
    public void removePerspective(ClickEvent event) {
        this.presenter.onRemovePerspective();
    }
}

