/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.Popup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.DetailedSerializationException;

public class ErrorPopup
extends Popup {
    private static Images images = (Images)GWT.create(Images.class);
    private Constants constants = (Constants)GWT.create(Constants.class);
    public static ErrorPopup instance = null;
    private VerticalPanel body;

    private ErrorPopup(String message, String longMessage) {
        this.setTitle(this.constants.Error());
        this.setWidth("400px");
        this.setModal(true);
        this.body = new VerticalPanel();
        this.addMessage(message, longMessage);
        this.body.setWidth("100%");
        this.show();
        this.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Widget getContent() {
        return this.body;
    }

    private void addMessage(String message, String longMessage) {
        if (message != null && message.contains("ItemExistsException")) {
            longMessage = message;
            message = this.constants.SorryAnItemOfThatNameAlreadyExistsInTheRepositoryPleaseChooseAnother();
        }
        String longDescription = longMessage;
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new Image(images.validationError()));
        Label msg = new Label(message);
        msg.setStyleName("error-title");
        hp.add((Widget)msg);
        this.body.add((Widget)hp);
        SimplePanel detailPanel = new SimplePanel();
        if (longMessage != null && !"".equals(longMessage)) {
            Button showD = new Button(this.constants.ShowDetail());
            showD.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            detailPanel.add((Widget)showD);
        }
        detailPanel.setWidth("100%");
        this.body.add((Widget)detailPanel);
    }

    public static void showMessage(String message) {
        if (instance != null) {
            instance.addMessage(message, null);
        } else {
            instance = new ErrorPopup(message, null);
        }
        LoadingPopup.close();
    }

    public static void showMessage(DetailedSerializationException exception) {
        if (instance != null) {
            instance.addMessage(exception.getMessage(), exception.getLongDescription());
        } else {
            instance = new ErrorPopup(exception.getMessage(), exception.getLongDescription());
        }
        LoadingPopup.close();
    }
}

