/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableControlsWidget;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.EditorWidget;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.util.AddButton;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;

public class GuidedDecisionTableWidget
extends Composite
implements SaveEventListener,
EditorWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private TypeSafeGuidedDecisionTable guidedDecisionTable;
    private VerticalPanel layout;
    private PrettyFormLayout configureColumnsNote;
    private VerticalPanel attributeConfigWidget;
    private VerticalPanel conditionsConfigWidget;
    private String packageName;
    private VerticalPanel actionsConfigWidget;
    private SuggestionCompletionEngine sce;
    private VerticalDecisionTableWidget dtable;

    public GuidedDecisionTableWidget(RuleAsset asset, RuleViewer viewer) {
        this(asset);
    }

    public GuidedDecisionTableWidget(RuleAsset asset) {
        this.guidedDecisionTable = (TypeSafeGuidedDecisionTable)asset.content;
        this.packageName = asset.metaData.packageName;
        this.guidedDecisionTable.setTableName(asset.name);
        this.layout = new VerticalPanel();
        this.configureColumnsNote = new PrettyFormLayout();
        this.configureColumnsNote.startSection();
        this.configureColumnsNote.addRow((Widget)new HTML("<img src='" + new Image(images.information()).getUrl() + "'/>&nbsp;" + this.constants.ConfigureColumnsNote()));
        this.configureColumnsNote.endSection();
        DecoratedDisclosurePanel disclosurePanel = new DecoratedDisclosurePanel(this.constants.DecisionTable());
        disclosurePanel.setWidth("100%");
        disclosurePanel.setTitle(this.constants.DecisionTable());
        VerticalPanel config = new VerticalPanel();
        config.setWidth("100%");
        disclosurePanel.add((Widget)config);
        DecoratedDisclosurePanel conditions = new DecoratedDisclosurePanel(this.constants.ConditionColumns());
        conditions.setOpen(false);
        conditions.setWidth("75%");
        conditions.add(this.getConditions());
        config.add((Widget)conditions);
        DecoratedDisclosurePanel actions = new DecoratedDisclosurePanel(this.constants.ActionColumns());
        actions.setOpen(false);
        actions.setWidth("75%");
        actions.add(this.getActions());
        config.add((Widget)actions);
        DecoratedDisclosurePanel options = new DecoratedDisclosurePanel(this.constants.Options());
        options.setOpen(false);
        options.setWidth("75%");
        options.add(this.getAttributes());
        config.add((Widget)options);
        this.layout.add((Widget)disclosurePanel);
        this.layout.add((Widget)this.configureColumnsNote);
        this.setupDecisionTable();
        this.initWidget((Widget)this.layout);
    }

    private Widget getActions() {
        this.actionsConfigWidget = new VerticalPanel();
        this.refreshActionsWidget();
        return this.actionsConfigWidget;
    }

    private void refreshActionsWidget() {
        this.actionsConfigWidget.clear();
        for (ActionCol c : this.guidedDecisionTable.getActionCols()) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add(this.removeAction(c));
            hp.add(this.editAction(c));
            hp.add((Widget)new SmallLabel(c.getHeader()));
            this.actionsConfigWidget.add((Widget)hp);
        }
        this.actionsConfigWidget.add(this.newAction());
        this.setupColumnsNote();
    }

    private Widget editAction(ActionCol c) {
        return new ImageButton(images.edit(), this.constants.EditThisActionColumnConfiguration(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget newAction() {
        AddButton addButton = new AddButton();
        addButton.setText(this.constants.NewColumn());
        addButton.setTitle(this.constants.CreateANewActionColumn());
        addButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addButton;
    }

    private Widget removeAction(ActionCol c) {
        ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemoveThisActionColumn(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget getConditions() {
        this.conditionsConfigWidget = new VerticalPanel();
        this.refreshConditionsWidget();
        return this.conditionsConfigWidget;
    }

    private void refreshConditionsWidget() {
        this.conditionsConfigWidget.clear();
        for (int i = 0; i < this.guidedDecisionTable.getConditionCols().size(); ++i) {
            ConditionCol c = (ConditionCol)this.guidedDecisionTable.getConditionCols().get(i);
            HorizontalPanel hp = new HorizontalPanel();
            hp.add(this.removeCondition(c));
            hp.add(this.editCondition(c));
            hp.add((Widget)new SmallLabel(c.getHeader()));
            this.conditionsConfigWidget.add((Widget)hp);
        }
        this.conditionsConfigWidget.add(this.newCondition());
        this.setupColumnsNote();
    }

    private Widget newCondition() {
        ConditionCol newCol = new ConditionCol();
        newCol.setConstraintValueType(1);
        AddButton addButton = new AddButton();
        addButton.setText(this.constants.NewColumn());
        addButton.setTitle(this.constants.AddANewConditionColumn());
        addButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addButton;
    }

    private Widget editCondition(ConditionCol c) {
        return new ImageButton(images.edit(), this.constants.EditThisColumnsConfiguration(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private SuggestionCompletionEngine getSCE() {
        if (this.sce == null) {
            this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
        }
        return this.sce;
    }

    private Widget removeCondition(ConditionCol c) {
        ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemoveThisConditionColumn(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget getAttributes() {
        this.attributeConfigWidget = new VerticalPanel();
        this.refreshAttributeWidget();
        return this.attributeConfigWidget;
    }

    private void refreshAttributeWidget() {
        HorizontalPanel hp;
        this.attributeConfigWidget.clear();
        this.attributeConfigWidget.add(this.newAttr());
        if (this.guidedDecisionTable.getMetadataCols().size() > 0) {
            hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp.add((Widget)new SmallLabel(this.constants.Metadata()));
            this.attributeConfigWidget.add((Widget)hp);
        }
        for (MetadataCol atc : this.guidedDecisionTable.getMetadataCols()) {
            HorizontalPanel hp2 = new HorizontalPanel();
            hp2.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
            hp2.add(this.removeMeta(atc));
            hp2.add((Widget)new SmallLabel(atc.getMetadata()));
            MetadataCol at = atc;
            CheckBox hide = new CheckBox();
            hide.setValue(Boolean.valueOf(atc.isHideColumn()));
            hide.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hp2.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp2.add((Widget)hide);
            hp2.add((Widget)new SmallLabel(this.constants.HideThisColumn()));
            this.attributeConfigWidget.add((Widget)hp2);
        }
        if (this.guidedDecisionTable.getAttributeCols().size() > 0) {
            hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp.add((Widget)new SmallLabel(this.constants.Attributes()));
            this.attributeConfigWidget.add((Widget)hp);
        }
        Iterator i$ = this.guidedDecisionTable.getAttributeCols().iterator();
        while (i$.hasNext()) {
            MetadataCol atc;
            MetadataCol at = atc = (AttributeCol)i$.next();
            HorizontalPanel hp3 = new HorizontalPanel();
            hp3.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
            hp3.add(this.removeAttr((AttributeCol)at));
            hp3.add((Widget)new SmallLabel(at.getAttribute()));
            TextBox defaultValue = new TextBox();
            defaultValue.setText(at.getDefaultValue());
            defaultValue.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (at.getAttribute().equals("salience")) {
                hp3.add((Widget)new HTML("&nbsp;&nbsp;"));
                CheckBox useRowNumber = new CheckBox();
                useRowNumber.setValue(Boolean.valueOf(at.isUseRowNumber()));
                hp3.add((Widget)useRowNumber);
                hp3.add((Widget)new SmallLabel(this.constants.UseRowNumber()));
                hp3.add((Widget)new SmallLabel("("));
                CheckBox reverseOrder = new CheckBox();
                reverseOrder.setValue(Boolean.valueOf(at.isReverseOrder()));
                reverseOrder.setEnabled(at.isUseRowNumber());
                useRowNumber.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                reverseOrder.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                hp3.add((Widget)reverseOrder);
                hp3.add((Widget)new SmallLabel(this.constants.ReverseOrder()));
                hp3.add((Widget)new SmallLabel(")"));
            }
            hp3.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp3.add((Widget)new SmallLabel(this.constants.DefaultValue()));
            hp3.add((Widget)defaultValue);
            CheckBox hide = new CheckBox();
            hide.setValue(Boolean.valueOf(at.isHideColumn()));
            hide.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            hp3.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp3.add((Widget)hide);
            hp3.add((Widget)new SmallLabel(this.constants.HideThisColumn()));
            this.attributeConfigWidget.add((Widget)hp3);
            this.setupColumnsNote();
        }
    }

    private Widget newAttr() {
        ImageButton but = new ImageButton(images.newItem(), this.constants.AddANewAttributeMetadata(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)new SmallLabel(this.constants.AddAttributeMetadata()));
        h.add((Widget)but);
        return h;
    }

    private Widget removeAttr(AttributeCol at) {
        ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemoveThisAttribute(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget removeMeta(MetadataCol md) {
        ImageButton del = new ImageButton(images.deleteItemSmall(), this.constants.RemoveThisMetadata(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private void setupColumnsNote() {
        this.configureColumnsNote.setVisible(this.guidedDecisionTable.getAttributeCols().size() == 0 && this.guidedDecisionTable.getConditionCols().size() == 0 && this.guidedDecisionTable.getActionCols().size() == 0);
    }

    private void setupDecisionTable() {
        if (this.dtable == null) {
            this.dtable = new VerticalDecisionTableWidget(new DecisionTableControlsWidget(), this.getSCE());
            this.dtable.setPixelSize(1000, 400);
            this.dtable.setModel(this.guidedDecisionTable);
        }
        this.layout.add((Widget)this.dtable);
    }

    public void onSave() {
        this.dtable.scrapeData();
    }

    public void onAfterSave() {
    }

    static /* synthetic */ SuggestionCompletionEngine access$000(GuidedDecisionTableWidget x0) {
        return x0.getSCE();
    }

    static /* synthetic */ VerticalDecisionTableWidget access$100(GuidedDecisionTableWidget x0) {
        return x0.dtable;
    }

    static /* synthetic */ void access$200(GuidedDecisionTableWidget x0) {
        x0.refreshActionsWidget();
    }

    static /* synthetic */ Constants access$300(GuidedDecisionTableWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$500(GuidedDecisionTableWidget x0) {
        x0.refreshConditionsWidget();
    }

    static /* synthetic */ Images access$600() {
        return images;
    }

    static /* synthetic */ TypeSafeGuidedDecisionTable access$700(GuidedDecisionTableWidget x0) {
        return x0.guidedDecisionTable;
    }

    static /* synthetic */ void access$800(GuidedDecisionTableWidget x0) {
        x0.refreshAttributeWidget();
    }
}

