/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import java.math.BigDecimal;
import java.util.Date;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.AbstractCellValueFactory;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTCellValue;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DTDataTypes;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;
import org.drools.ide.common.client.modeldriven.dt.TypeSafeGuidedDecisionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCellValueFactory
extends AbstractCellValueFactory<DTColumnConfig> {
    private TypeSafeGuidedDecisionTable model;

    public DecisionTableCellValueFactory(SuggestionCompletionEngine sce, TypeSafeGuidedDecisionTable model) {
        super(sce);
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
    }

    public DTCellValue convertToDTModelCell(DTColumnConfig column, CellValue<?> cell) {
        DTDataTypes dt = this.getDataType(column);
        DTCellValue dtCell = null;
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dt.ordinal()]) {
            case 1: {
                dtCell = new DTCellValue((Boolean)cell.getValue());
                break;
            }
            case 2: {
                dtCell = new DTCellValue((Date)cell.getValue());
                break;
            }
            case 3: {
                dtCell = new DTCellValue((BigDecimal)cell.getValue());
                break;
            }
            default: {
                dtCell = new DTCellValue((String)((Object)cell.getValue()));
            }
        }
        dtCell.setOtherwise(cell.isOtherwise());
        return dtCell;
    }

    public CellValue<? extends Comparable<?>> makeCellValue(DTColumnConfig column, int iRow, int iCol, DTCellValue dcv) {
        DTDataTypes dataType = this.getDataType(column);
        CellValue cell = null;
        this.assertDTCellValue(dataType, dcv);
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dataType.ordinal()]) {
            case 1: {
                cell = this.makeNewBooleanCellValue(iRow, iCol, dcv.getBooleanValue());
                break;
            }
            case 2: {
                cell = this.makeNewDateCellValue(iRow, iCol, dcv.getDateValue());
                break;
            }
            case 3: {
                AttributeCol at;
                if (column instanceof RowNumberCol) {
                    cell = this.makeNewRowNumberCellValue(iRow, iCol);
                    break;
                }
                cell = this.makeNewNumericCellValue(iRow, iCol, dcv.getNumericValue());
                if (!(column instanceof AttributeCol) || !(at = (AttributeCol)column).getAttribute().equals("salience") || !at.isUseRowNumber()) break;
                cell = this.makeNewRowNumberCellValue(iRow, iCol);
                break;
            }
            default: {
                AttributeCol ac;
                cell = this.makeNewStringCellValue(iRow, iCol, (Object)dcv.getStringValue());
                if (!(column instanceof AttributeCol) || !(ac = (AttributeCol)column).getAttribute().equals("dialect")) break;
                cell = this.makeNewDialectCellValue(iRow, iCol, dcv.getStringValue());
            }
        }
        if (dcv.isOtherwise()) {
            cell.addState(CellValue.CellState.OTHERWISE);
        }
        return cell;
    }

    private void assertDTCellValue(DTDataTypes dataType, DTCellValue dcv) {
        if (dcv.getDataType().equals((Object)dataType)) {
            return;
        }
        String text = dcv.getStringValue();
        switch (1.$SwitchMap$org$drools$ide$common$client$modeldriven$dt$DTDataTypes[dataType.ordinal()]) {
            case 1: {
                dcv.setBooleanValue(text == null ? null : Boolean.valueOf(text));
                break;
            }
            case 2: {
                Date d = null;
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                dcv.setDateValue(d);
                break;
            }
            case 3: {
                BigDecimal bd = null;
                try {
                    if (text != null) {
                        bd = new BigDecimal(text);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                dcv.setNumericValue(bd);
            }
        }
    }

    private DTDataTypes derieveDataType(DTColumnConfig col) {
        DTDataTypes dataType = DTDataTypes.STRING;
        String[] vals = this.model.getValueList(col, this.sce);
        if (vals.length == 0) {
            if (this.model.isNumeric(col, this.sce)) {
                dataType = DTDataTypes.NUMERIC;
            } else if (this.model.isBoolean(col, this.sce)) {
                dataType = DTDataTypes.BOOLEAN;
            } else if (this.model.isDate(col, this.sce)) {
                dataType = DTDataTypes.DATE;
            }
        }
        return dataType;
    }

    protected DTDataTypes getDataType(DTColumnConfig column) {
        DTDataTypes dataType = DTDataTypes.STRING;
        if (column instanceof RowNumberCol) {
            dataType = DTDataTypes.NUMERIC;
        } else if (column instanceof AttributeCol) {
            AttributeCol attrCol = (AttributeCol)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                dataType = DTDataTypes.NUMERIC;
            } else if (attrName.equals("enabled")) {
                dataType = DTDataTypes.BOOLEAN;
            } else if (attrName.equals("no-loop")) {
                dataType = DTDataTypes.BOOLEAN;
            } else if (attrName.equals("duration")) {
                dataType = DTDataTypes.NUMERIC;
            } else if (attrName.equals("auto-focus")) {
                dataType = DTDataTypes.BOOLEAN;
            } else if (attrName.equals("lock-on-active")) {
                dataType = DTDataTypes.BOOLEAN;
            } else if (attrName.equals("date-effective")) {
                dataType = DTDataTypes.DATE;
            } else if (attrName.equals("date-expires")) {
                dataType = DTDataTypes.DATE;
            } else if (attrName.equals("negate")) {
                dataType = DTDataTypes.BOOLEAN;
            }
        } else if (column instanceof ConditionCol) {
            dataType = this.derieveDataType(column);
        } else if (column instanceof ActionSetFieldCol) {
            dataType = this.derieveDataType(column);
        } else if (column instanceof ActionInsertFactCol) {
            dataType = this.derieveDataType(column);
        }
        return dataType;
    }

    protected CellValue<BigDecimal> makeNewRowNumberCellValue(int iRow, int iCol) {
        CellValue cv = new CellValue((Comparable)new BigDecimal(iRow + 1), iRow, iCol);
        return cv;
    }
}

