/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ClosableLabel;
import org.drools.guvnor.client.explorer.MultiKeyMap;
import org.drools.guvnor.client.packages.PackageEditor;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.util.ScrollTabLayoutPanel;
import org.drools.guvnor.client.util.TabOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerViewCenterPanel
extends Composite {
    private final ScrollTabLayoutPanel tabLayoutPanel;
    private MultiKeyMap<Panel> openedTabs = new MultiKeyMap();
    private static int id = 0;
    private Map<String, GuvnorEditor> openedAssetEditors = new HashMap();
    private Map<String, PackageEditor> openedPackageEditors = new HashMap();
    private Map<Panel, String[]> itemWidgets = new HashMap();

    public ExplorerViewCenterPanel() {
        this.tabLayoutPanel = new ScrollTabLayoutPanel(2.0, Style.Unit.EM);
        this.initWidget((Widget)this.tabLayoutPanel);
        TabOpener.initIstance((ExplorerViewCenterPanel)this);
        TabOpener.getInstance().openFind();
    }

    public void addTab(String tabname, IsWidget widget, String key) {
        this.addTab(tabname, widget, new String[]{key});
    }

    public void addTab(String tabname, IsWidget widget, String[] keys) {
        String panelId = keys.length == 1 ? keys[0] + id++ : Arrays.toString(keys) + id++;
        ScrollPanel localTP = new ScrollPanel();
        localTP.add(widget);
        this.tabLayoutPanel.add((Widget)localTP, this.newClosableLabel((Panel)localTP, tabname));
        this.tabLayoutPanel.selectTab((Widget)localTP);
        if (widget instanceof GuvnorEditor) {
            this.openedAssetEditors.put(panelId, (GuvnorEditor)widget);
        } else if (widget instanceof PackageEditor) {
            this.getOpenedPackageEditors().put(tabname, (PackageEditor)widget);
        }
        this.openedTabs.put(keys, (Object)localTP);
        this.itemWidgets.put(localTP, keys);
    }

    private Widget newClosableLabel(Panel panel, String title) {
        ClosableLabel closableLabel = new ClosableLabel(title);
        closableLabel.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        return closableLabel;
    }

    public boolean showIfOpen(String key) {
        if (this.openedTabs.containsKey(key)) {
            LoadingPopup.close();
            Panel tpi = (Panel)this.openedTabs.get(key);
            this.tabLayoutPanel.selectTab((Widget)tpi);
            return true;
        }
        return false;
    }

    public void close(String key) {
        Panel tpi = (Panel)this.openedTabs.remove(key);
        int widgetIndex = this.tabLayoutPanel.getWidgetIndex((Widget)tpi);
        if (widgetIndex == this.tabLayoutPanel.getSelectedIndex()) {
            this.tabLayoutPanel.selectTab(widgetIndex - 1);
        }
        this.tabLayoutPanel.remove(widgetIndex);
        this.itemWidgets.remove(tpi);
    }

    public Map<String, PackageEditor> getOpenedPackageEditors() {
        return this.openedPackageEditors;
    }

    static /* synthetic */ ScrollTabLayoutPanel access$000(ExplorerViewCenterPanel x0) {
        return x0.tabLayoutPanel;
    }

    static /* synthetic */ Map access$100(ExplorerViewCenterPanel x0) {
        return x0.itemWidgets;
    }

    static /* synthetic */ MultiKeyMap access$200(ExplorerViewCenterPanel x0) {
        return x0.openedTabs;
    }
}

