/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import java.util.Arrays;
import java.util.Map;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.explorer.AbstractTree;
import org.drools.guvnor.client.explorer.ExplorerNodeConfig;
import org.drools.guvnor.client.explorer.PackageHierarchy;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.util.TabOpener;
import org.drools.guvnor.client.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class PackagesTree
extends AbstractTree
implements OpenHandler<TreeItem> {
    private static Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private boolean packagesLoaded = false;

    public PackagesTree() {
        this.name = constants.KnowledgeBases();
        this.image = images.packages();
        this.mainTree.setAnimationEnabled(true);
        this.mainTree.addSelectionHandler((SelectionHandler)this);
        this.mainTree.addOpenHandler((OpenHandler)this);
    }

    protected Tree createTree() {
        return new Tree();
    }

    public void loadPackageList() {
        if (!this.packagesLoaded) {
            this.setupPackagesTree();
            this.packagesLoaded = true;
        }
    }

    public void refreshTree() {
        this.mainTree.clear();
        this.itemWidgets.clear();
        this.setupPackagesTree();
    }

    private void setupPackagesTree() {
        TreeItem packageRootNode = new TreeItem(Util.getHeader((ImageResource)images.chartOrganisation(), (String)constants.Packages()));
        this.setupPackageNode(packageRootNode);
        this.mainTree.addItem(packageRootNode);
        this.setupGlobalNode(this.mainTree, this.itemWidgets);
    }

    private void setupPackageNode(TreeItem packageRootNode) {
        packageRootNode.setState(true);
        packageRootNode.setUserObject((Object)"rootNode");
        RepositoryServiceFactory.getPackageService().listPackages((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setupGlobalNode(Tree root, Map<TreeItem, String> itemWidgets) {
        RepositoryServiceFactory.getPackageService().loadGlobalPackage((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void buildPkgTree(TreeItem root, PackageHierarchy.Folder folder) {
        if (folder.getConfig() != null) {
            root.addItem(this.loadPackage(folder.getName(), folder.getConfig()));
        } else {
            TreeItem treeItem = new TreeItem(Util.getHeader((ImageResource)images.emptyPackage(), (String)folder.getName()));
            root.addItem(treeItem);
            for (PackageHierarchy.Folder childFolder : folder.getChildren()) {
                this.buildPkgTree(treeItem, childFolder);
            }
        }
    }

    private TreeItem loadPackage(String name, PackageConfigData config) {
        TreeItem treeItem = ExplorerNodeConfig.getPackageItemStructure((String)name, (String)config.uuid, (Map)this.itemWidgets);
        treeItem.setUserObject((Object)config);
        return treeItem;
    }

    public static String key(String[] formats, PackageConfigData userObject) {
        StringBuilder keyBuilder = new StringBuilder(userObject.uuid);
        if (formats.length == 0) {
            keyBuilder.append("[0]");
        } else {
            for (String format : formats) {
                keyBuilder.append(format);
            }
        }
        return keyBuilder.toString();
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem node = (TreeItem)event.getSelectedItem();
        Object userObject = node.getUserObject();
        TabOpener opener = TabOpener.getInstance();
        if (userObject != null) {
            if (userObject instanceof PackageConfigData && !((PackageConfigData)userObject).isGlobal()) {
                PackageConfigData pc = (PackageConfigData)userObject;
                RulePackageSelector.currentlySelectedPackage = pc.name;
                String uuid = pc.uuid;
                opener.openPackageEditor(uuid, (Command)new /* Unavailable Anonymous Inner Class!! */);
            } else if (userObject instanceof String[]) {
                String[] formats = (String[])userObject;
                PackageConfigData packageConfigData = (PackageConfigData)node.getParentItem().getUserObject();
                RulePackageSelector.currentlySelectedPackage = packageConfigData.name;
                String key = PackagesTree.key((String[])formats, (PackageConfigData)packageConfigData);
                opener.openPackageViewAssets(packageConfigData.uuid, packageConfigData.name, key, formats.length == 0 ? null : Arrays.asList(formats), formats.length == 0 ? Boolean.TRUE : null, node.getText());
            } else if (!(userObject instanceof String)) {
                throw new IllegalArgumentException("The userObject (" + userObject + ") is not supported.");
            }
        }
    }

    public void onOpen(OpenEvent<TreeItem> event) {
        TreeItem node = (TreeItem)event.getTarget();
        Object userObject = node.getUserObject();
        if (userObject != null && userObject instanceof String && "rootNode".equals((String)userObject)) {
            node.removeItems();
            this.setupPackageNode(node);
        }
    }

    static /* synthetic */ void access$000(PackagesTree x0, TreeItem x1, PackageHierarchy.Folder x2) {
        x0.buildPkgTree(x1, x2);
    }

    static /* synthetic */ Constants access$100() {
        return constants;
    }

    static /* synthetic */ Images access$200() {
        return images;
    }
}

