/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.guvnor.client.modeldriven.ui.factPattern.Connectives;
import org.drools.guvnor.client.modeldriven.ui.factPattern.PopupCreator;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactPatternWidget
extends RuleModellerWidget {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private FactPattern pattern;
    private DirtyableFlexTable layout = new DirtyableFlexTable();
    private Connectives connectives;
    private PopupCreator popupCreator;
    private boolean bindable;
    private boolean isAll0WithLabel;
    private boolean readOnly;

    public FactPatternWidget(RuleModeller mod, IPattern p, boolean canBind) {
        this(mod, p, false, canBind, null);
    }

    public FactPatternWidget(RuleModeller mod, IPattern p, boolean isAll0WithLabel, boolean canBind) {
        this(mod, p, isAll0WithLabel, canBind, null);
    }

    public FactPatternWidget(RuleModeller ruleModeller, IPattern pattern, boolean canBind, Boolean readOnly) {
        this(ruleModeller, pattern, false, canBind, readOnly);
    }

    public FactPatternWidget(RuleModeller mod, IPattern p, boolean isAll0WithLabel, boolean canBind, Boolean readOnly) {
        super(mod);
        this.pattern = (FactPattern)p;
        this.bindable = canBind;
        this.connectives = new Connectives();
        this.connectives.setModeller(mod);
        this.connectives.setPattern(this.pattern);
        this.popupCreator = new PopupCreator();
        this.popupCreator.setBindable(this.bindable);
        this.popupCreator.setCompletions(mod.getSuggestionCompletions());
        this.popupCreator.setModeller(mod);
        this.popupCreator.setPattern(this.pattern);
        this.isAll0WithLabel = isAll0WithLabel;
        this.readOnly = readOnly == null ? !this.connectives.getCompletions().containsFactType(this.pattern.getFactType()) : readOnly;
        this.layout.setWidget(0, 0, this.getPatternLabel());
        FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
        formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_BOTTOM);
        formatter.setStyleName(0, 0, "modeller-fact-TypeHeader");
        List sortedConst = this.sortConstraints(this.pattern.getFieldConstraints());
        this.pattern.setFieldConstraints(sortedConst);
        this.drawConstraints(sortedConst);
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        if (this.bindable) {
            this.layout.addStyleName("modeller-fact-pattern-Widget");
        }
        this.initWidget((Widget)this.layout);
    }

    private void drawConstraints(List<FieldConstraint> sortedConst) {
        DirtyableFlexTable table = new DirtyableFlexTable();
        this.layout.setWidget(1, 0, (Widget)table);
        ArrayList parents = new ArrayList();
        for (int i = 0; i < sortedConst.size(); ++i) {
            this.traverseSingleFieldConstraints(sortedConst, table, parents, i);
            int currentRow = i;
            ImageButton clear = new ImageButton(images.deleteItemSmall());
            clear.setTitle(this.constants.RemoveThisWholeRestriction());
            clear.addClickHandler(this.createClickHandlerForClearImageButton(currentRow));
            if (this.readOnly) continue;
            table.setWidget(currentRow, 5, (Widget)clear);
        }
    }

    private ClickHandler createClickHandlerForClearImageButton(int currentRow) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void traverseSingleFieldConstraints(List<FieldConstraint> sortedConst, DirtyableFlexTable table, List<FieldConstraint> parents, int i) {
        int tabs = -1;
        FieldConstraint current = sortedConst.get(i);
        if (current instanceof SingleFieldConstraint) {
            SingleFieldConstraint single = (SingleFieldConstraint)current;
            FieldConstraint parent = single.getParent();
            for (int j = 0; j < parents.size(); ++j) {
                FieldConstraint storedParent = parents.get(j);
                if (storedParent == null || !storedParent.equals(parent)) continue;
                tabs = j + 1;
                this.traverseForRemoval(parents, j);
                parents.add(current);
                break;
            }
            if (tabs < 0) {
                tabs = 0;
                parents.add(current);
            }
        }
        this.renderFieldConstraint(table, i, current, true, tabs);
    }

    private void traverseForRemoval(List<FieldConstraint> parents, int j) {
        for (int k = j + 1; k < parents.size(); ++k) {
            parents.remove(j + 1);
        }
    }

    private List<FieldConstraint> sortConstraints(FieldConstraint[] constraints) {
        ArrayList<FieldConstraint> sortedConst = new ArrayList<FieldConstraint>(constraints.length);
        for (int i = 0; i < constraints.length; ++i) {
            FieldConstraint current = constraints[i];
            if (current instanceof SingleFieldConstraint) {
                SingleFieldConstraint single = (SingleFieldConstraint)current;
                int index = sortedConst.indexOf(single.getParent());
                if (single.getParent() == null) {
                    sortedConst.add((FieldConstraint)single);
                    continue;
                }
                if (index >= 0) {
                    sortedConst.add(index + 1, (FieldConstraint)single);
                    continue;
                }
                this.insertSingleFieldConstraint(single, sortedConst);
                continue;
            }
            sortedConst.add(current);
        }
        return sortedConst;
    }

    private void insertSingleFieldConstraint(SingleFieldConstraint fieldConst, List<FieldConstraint> sortedConst) {
        if (fieldConst.getParent() instanceof SingleFieldConstraint) {
            this.insertSingleFieldConstraint((SingleFieldConstraint)fieldConst.getParent(), sortedConst);
        }
        sortedConst.add((FieldConstraint)fieldConst);
    }

    private void renderFieldConstraint(DirtyableFlexTable inner, int row, FieldConstraint constraint, boolean showBinding, int tabs) {
        if (constraint instanceof SingleFieldConstraint) {
            this.renderSingleFieldConstraint(this.getModeller(), inner, row, (SingleFieldConstraint)constraint, showBinding, tabs);
        } else if (constraint instanceof CompositeFieldConstraint) {
            inner.setWidget(row, 1, this.compositeFieldConstraintEditor((CompositeFieldConstraint)constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
            inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        }
    }

    private Widget compositeFieldConstraintEditor(CompositeFieldConstraint constraint) {
        FlexTable t = new FlexTable();
        String desc = null;
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        desc = constraint.compositeJunctionType.equals("&&") ? this.constants.AllOf() + ":" : this.constants.AnyOf() + ":";
        t.setWidget(0, 0, (Widget)new ClickableLabel(desc, (ClickHandler)click, !this.readOnly));
        t.getFlexCellFormatter().setColSpan(0, 0, 2);
        FieldConstraint[] nested = constraint.constraints;
        DirtyableFlexTable inner = new DirtyableFlexTable();
        inner.setStyleName("modeller-inner-nested-Constraints");
        if (nested != null) {
            for (int i = 0; i < nested.length; ++i) {
                this.renderFieldConstraint(inner, i, nested[i], false, 0);
                int currentRow = i;
                ImageButton clear = new ImageButton(images.deleteItemSmall());
                clear.setTitle(this.constants.RemoveThisNestedRestriction());
                clear.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                if (this.readOnly) continue;
                inner.setWidget(i, 5, (Widget)clear);
            }
        }
        t.setWidget(1, 1, (Widget)inner);
        t.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        return t;
    }

    private void renderSingleFieldConstraint(RuleModeller modeller, DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, boolean showBinding, int tabs) {
        boolean col = true;
        inner.setWidget(row, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (constraint.getConstraintValueType() != 5) {
            HorizontalPanel ebContainer = null;
            if (constraint instanceof SingleFieldConstraintEBLeftSide) {
                ebContainer = this.expressionBuilderLS((SingleFieldConstraintEBLeftSide)constraint, showBinding, tabs * 20);
                inner.setWidget(row, 1, (Widget)ebContainer);
            } else {
                inner.setWidget(row, 1, this.fieldLabel(constraint, showBinding, tabs * 20));
            }
            inner.setWidget(row, 3, this.valueEditor(constraint, constraint.getFieldType()));
            inner.setWidget(row, 2, this.operatorDropDown(constraint, inner, row, 3));
            inner.setWidget(row, 4, this.connectives.connectives(constraint, constraint.getFieldType()));
            if (ebContainer != null && ebContainer.getWidgetCount() > 0 && ebContainer.getWidget(0) instanceof ExpressionBuilder) {
                this.associateExpressionWithChangeHandler(inner, row, constraint, 1, ebContainer);
            }
            if (!this.readOnly) {
                inner.setWidget(row, 5, (Widget)this.createaAddConnectiveImageButton(modeller, constraint));
            }
        } else if (constraint.getConstraintValueType() == 5) {
            inner.setWidget(row, 1, this.predicateEditor(constraint));
            inner.getFlexCellFormatter().setColSpan(row, 1, 5);
        }
    }

    private Image createaAddConnectiveImageButton(RuleModeller modeller, SingleFieldConstraint constraint) {
        ImageButton addConnective = new ImageButton(images.addConnective());
        addConnective.setTitle(this.constants.AddMoreOptionsToThisFieldsValues());
        addConnective.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return addConnective;
    }

    private void associateExpressionWithChangeHandler(DirtyableFlexTable inner, int row, SingleFieldConstraint constraint, int col, HorizontalPanel ebContainer) {
        ExpressionBuilder eb = (ExpressionBuilder)ebContainer.getWidget(0);
        eb.addExpressionTypeChangeHandler((ExpressionTypeChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget predicateEditor(SingleFieldConstraint c) {
        HorizontalPanel pred = new HorizontalPanel();
        pred.setWidth("100%");
        Image img = new Image(images.functionAssets());
        img.setTitle(this.constants.FormulaBooleanTip());
        pred.add((Widget)img);
        if (c.getValue() == null) {
            c.setValue("");
        }
        TextBox box = new TextBox();
        box.setText(c.getValue());
        if (!this.readOnly) {
            box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            box.setWidth("100%");
            pred.add((Widget)box);
        } else {
            pred.add((Widget)new SmallLabel(c.getValue()));
        }
        return pred;
    }

    private Widget getPatternLabel() {
        String desc;
        String patternName;
        7 click = new /* Unavailable Anonymous Inner Class!! */;
        String string = patternName = this.pattern.getBoundName() != null ? this.pattern.getFactType() + " <b>[" + this.pattern.getBoundName() + "]</b>" : this.pattern.getFactType();
        if (this.isAll0WithLabel) {
            desc = this.constants.All0with(patternName);
        } else {
            desc = this.pattern.constraintList != null && this.pattern.constraintList.constraints.length > 0 ? this.constants.ThereIsAAn0With(patternName) : this.constants.ThereIsAAn0(patternName);
            desc = this.anA(desc, patternName);
        }
        return new ClickableLabel(desc, (ClickHandler)click, !this.readOnly);
    }

    private String anA(String desc, String patternName) {
        if (desc.startsWith("There is a/an")) {
            String vowel = patternName.substring(0, 1);
            if (vowel.equalsIgnoreCase("A") || vowel.equalsIgnoreCase("E") || vowel.equalsIgnoreCase("I") || vowel.equalsIgnoreCase("O") || vowel.equalsIgnoreCase("U")) {
                return desc.replace("There is a/an", "There is an");
            }
            return desc.replace("There is a/an", "There is a");
        }
        return desc;
    }

    private Widget valueEditor(SingleFieldConstraint c, String factType) {
        ConstraintValueEditor constraintValueEditor = new ConstraintValueEditor(this.pattern, c.getFieldName(), (BaseSingleFieldConstraint)c, this.getModeller(), c.getFieldType(), this.readOnly);
        constraintValueEditor.setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        return constraintValueEditor;
    }

    private Widget operatorDropDown(SingleFieldConstraint c, String type) {
        return this.operatorDropDown(c, type, null, -1, -1);
    }

    private Widget operatorDropDown(SingleFieldConstraint c, DirtyableFlexTable inner, int row, int col) {
        return this.operatorDropDown(c, this.connectives.getCompletions().getFieldType(this.pattern.getFactType(), c.getFieldName()), inner, row, col);
    }

    private Widget operatorDropDown(SingleFieldConstraint c, String type, DirtyableFlexTable inner, int row, int col) {
        if (!this.readOnly) {
            String[] ops = this.connectives.getCompletions().getOperatorCompletions(type);
            ListBox box = new ListBox();
            box.addItem(this.constants.pleaseChoose(), "");
            for (int i = 0; i < ops.length; ++i) {
                String op = ops[i];
                box.addItem(HumanReadable.getOperatorDisplayName((String)op), op);
                if (!op.equals(c.getOperator())) continue;
                if (HumanReadable.getOperatorDisplayName((String)op).equals(this.constants.isEqualToNull()) || HumanReadable.getOperatorDisplayName((String)op).equals(this.constants.isNotEqualToNull())) {
                    inner.getWidget(row, col).setVisible(false);
                    ((ConstraintValueEditor)inner.getWidget(row, col)).getConstraint().setValue("");
                }
                box.setSelectedIndex(i + 1);
            }
            box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            return box;
        }
        SmallLabel sl = new SmallLabel("<b>" + (c.getOperator() == null ? this.constants.pleaseChoose() : HumanReadable.getOperatorDisplayName((String)c.getOperator())) + "</b>");
        return sl;
    }

    private HorizontalPanel expressionBuilderLS(SingleFieldConstraintEBLeftSide con, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding && !this.readOnly) {
                ab.add((Widget)new ExpressionBuilder(this.getModeller(), con.getExpressionLeftSide()));
            } else {
                ab.add((Widget)new SmallLabel(con.getExpressionLeftSide().getText()));
            }
        } else {
            ab.add((Widget)new ExpressionBuilder(this.getModeller(), con.getExpressionLeftSide()));
        }
        return ab;
    }

    private Widget fieldLabel(SingleFieldConstraint con, boolean showBinding, int padding) {
        HorizontalPanel ab = new HorizontalPanel();
        ab.setStyleName("modeller-field-Label");
        if (!con.isBound()) {
            if (this.bindable && showBinding && !this.readOnly) {
                10 click = new /* Unavailable Anonymous Inner Class!! */;
                ImageButton bind = new ImageButton(images.editTiny(), this.constants.GiveFieldVarName());
                bind.addClickHandler((ClickHandler)click);
                ClickableLabel cl = new ClickableLabel(con.getFieldName(), (ClickHandler)click, !this.readOnly);
                DOM.setStyleAttribute((Element)cl.getElement(), (String)"marginLeft", (String)("" + padding + "pt"));
                ab.add((Widget)cl);
            } else {
                ab.add((Widget)new SmallLabel(con.getFieldName()));
            }
        } else {
            ab.add((Widget)new SmallLabel(con.getFieldName()));
            ab.add((Widget)new SmallLabel(" <b>[" + con.getFieldBinding() + "]</b>"));
        }
        return ab;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    static /* synthetic */ Constants access$000(FactPatternWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ FactPattern access$100(FactPatternWidget x0) {
        return x0.pattern;
    }

    static /* synthetic */ PopupCreator access$200(FactPatternWidget x0) {
        return x0.popupCreator;
    }

    static /* synthetic */ Widget access$300(FactPatternWidget x0, SingleFieldConstraint x1, String x2) {
        return x0.operatorDropDown(x1, x2);
    }

    static /* synthetic */ Connectives access$400(FactPatternWidget x0) {
        return x0.connectives;
    }
}

