/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataCellFactory;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataCellValueFactory;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataColumn;
import org.drools.guvnor.client.modeldriven.ui.TemplateDataHeaderWidget;
import org.drools.guvnor.client.util.DateConverter;
import org.drools.guvnor.client.util.GWTDateConverter;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.HasColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.HasRows;
import org.drools.guvnor.client.widgets.decoratedgrid.VerticalDecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.VerticalDecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.TemplateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDataTableWidget
extends Composite
implements HasRows,
HasColumns<TemplateDataColumn> {
    protected DecoratedGridWidget<TemplateDataColumn> widget;
    protected TemplateDataCellFactory cellFactory;
    protected TemplateDataCellValueFactory cellValueFactory;
    protected SuggestionCompletionEngine sce;

    public TemplateDataTableWidget(SuggestionCompletionEngine sce) {
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.sce = sce;
        this.widget = new VerticalDecoratedGridWidget();
        TemplateDataHeaderWidget header = new TemplateDataHeaderWidget(this.widget);
        VerticalDecoratedGridSidebarWidget sidebar = new VerticalDecoratedGridSidebarWidget(this.widget, (HasRows)this);
        this.widget.setHeaderWidget((DecoratedGridHeaderWidget)header);
        this.widget.setSidebarWidget((DecoratedGridSidebarWidget)sidebar);
        this.cellFactory = new TemplateDataCellFactory(sce, this.widget.getGridWidget());
        this.cellValueFactory = new TemplateDataCellValueFactory(sce);
        TemplateDataCellValueFactory.injectDateConvertor((DateConverter)GWTDateConverter.getInstance());
        this.initWidget((Widget)this.widget);
    }

    public void addColumn(TemplateDataColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.addColumn(modelColumn, true);
    }

    public void appendRow() {
        List rowData = this.makeRowData();
        this.widget.insertRowBefore(null, rowData);
    }

    public void deleteColumn(TemplateDataColumn modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.deleteColumn(col);
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.widget.deleteRow(row);
    }

    public void insertRowBefore(DynamicDataRow rowBefore) {
        if (rowBefore == null) {
            throw new IllegalArgumentException("rowBefore cannot be null");
        }
        List rowData = this.makeRowData();
        this.widget.insertRowBefore(rowBefore, rowData);
    }

    public void scrapeData(TemplateModel model) {
        model.clearRows();
        DynamicData data = this.widget.getGridWidget().getData().getFlattenedData();
        List columns = this.widget.getGridWidget().getColumns();
        int columnCount = columns.size();
        for (DynamicDataRow row : data) {
            String[] rowData = new String[columnCount];
            for (int iCol = 0; iCol < columnCount; ++iCol) {
                String serialisedValue;
                CellValue cv = row.get(iCol);
                DynamicColumn column = (DynamicColumn)columns.get(iCol);
                rowData[iCol] = serialisedValue = this.cellValueFactory.convertValueToString((TemplateDataColumn)column.getModelColumn(), cv);
            }
            model.addRow(rowData);
        }
    }

    public void setColumnVisibility(TemplateDataColumn modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.setColumnVisibility(col.getColumnIndex(), isVisible);
    }

    public void setModel(TemplateModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        TemplateModel.InterpolationVariable[] vars = model.getInterpolationVariablesList();
        if (vars.length == 0) {
            return;
        }
        for (TemplateModel.InterpolationVariable var : vars) {
            this.addColumn(new TemplateDataColumn(var.getVarName(), var.getDataType(), var.getFactType(), var.getFactField()), false);
        }
        String[][] data = model.getTableAsArray();
        List columns = this.widget.getGridWidget().getColumns();
        for (int iRow = 0; iRow < data.length; ++iRow) {
            ArrayList<CellValue> row = new ArrayList<CellValue>();
            String[] rowData = data[iRow];
            for (int iCol = 0; iCol < columns.size(); ++iCol) {
                TemplateDataColumn col = (TemplateDataColumn)((DynamicColumn)columns.get(iCol)).getModelColumn();
                String initialValue = rowData[iCol];
                if (initialValue != null && initialValue.equals("")) {
                    initialValue = null;
                }
                CellValue cv = this.cellValueFactory.makeCellValue(col, iRow, iCol, initialValue);
                row.add(cv);
            }
            this.widget.insertRowBefore(null, row);
        }
        this.widget.getHeaderWidget().redraw();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    private void addColumn(TemplateDataColumn modelColumn, boolean bRedraw) {
        int index = this.widget.getGridWidget().getColumns().size();
        this.insertColumnBefore(modelColumn, index, bRedraw);
    }

    private DynamicColumn<TemplateDataColumn> getDynamicColumn(TemplateDataColumn modelCol) {
        DynamicColumn column = null;
        List columns = this.widget.getGridWidget().getColumns();
        for (DynamicColumn dc : columns) {
            if (!((TemplateDataColumn)dc.getModelColumn()).equals(modelCol)) continue;
            column = dc;
            break;
        }
        return column;
    }

    private void insertColumnBefore(TemplateDataColumn modelColumn, int index, boolean bRedraw) {
        DynamicColumn column = new DynamicColumn((Object)modelColumn, this.cellFactory.getCell(modelColumn), index);
        column.setVisible(true);
        List columnData = this.makeColumnData(modelColumn, index);
        if (index < this.widget.getGridWidget().getColumns().size()) {
            DynamicColumn columnBefore = (DynamicColumn)this.widget.getGridWidget().getColumns().get(index);
            this.widget.insertColumnBefore(columnBefore, column, columnData, bRedraw);
        } else {
            this.widget.appendColumn(column, columnData, bRedraw);
        }
    }

    private List<CellValue<? extends Comparable<?>>> makeColumnData(TemplateDataColumn column, int colIndex) {
        int dataSize = this.widget.getGridWidget().getData().size();
        ArrayList columnData = new ArrayList();
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            CellValue cv = this.cellValueFactory.makeCellValue((Object)column, iRow, colIndex);
            columnData.add(cv);
        }
        return columnData;
    }

    private List<CellValue<? extends Comparable<?>>> makeRowData() {
        ArrayList row = new ArrayList();
        List columns = this.widget.getGridWidget().getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            TemplateDataColumn col = (TemplateDataColumn)((DynamicColumn)columns.get(iCol)).getModelColumn();
            CellValue cv = this.cellValueFactory.makeCellValue((Object)col, 0, iCol);
            row.add(cv);
        }
        return row;
    }
}

