/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.DependencyWidget;
import org.drools.guvnor.client.packages.OpenPackageCommand;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.packages.PackageEditor;
import org.drools.guvnor.client.packages.PackageHeaderWidget;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.ruleeditor.toolbar.PackageActionToolbarButtonsConfigurationProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class PackageEditor
extends PrettyFormLayout {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private PackageConfigData conf;
    private ActionToolbar actionToolBar;
    private boolean isHistoricalReadOnly = false;
    private Command closeCommand;
    private Command refreshPackageListCommand;
    private OpenPackageCommand openPackageCommand;
    private HorizontalPanel packageConfigurationValidationResult = new HorizontalPanel();

    public PackageEditor(PackageConfigData data, Command closeCommand, Command refreshPackageList, OpenPackageCommand openPackageCommand) {
        this(data, false, closeCommand, refreshPackageList, openPackageCommand);
    }

    public PackageEditor(PackageConfigData data, boolean historicalReadOnly, Command closeCommand, Command refreshPackageList, OpenPackageCommand openPackageCommand) {
        this.conf = data;
        this.isHistoricalReadOnly = historicalReadOnly;
        this.closeCommand = closeCommand;
        this.refreshPackageListCommand = refreshPackageList;
        this.openPackageCommand = openPackageCommand;
        this.setWidth("100%");
        this.refreshWidgets();
    }

    private void refreshWidgets() {
        this.clear();
        this.actionToolBar = new ActionToolbar(this.getConfiguration(), this.conf.state);
        if (this.isHistoricalReadOnly) {
            this.actionToolBar.setVisible(false);
        } else {
            this.actionToolBar.setSaveChangesCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.actionToolBar.setArchiveCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.actionToolBar.setCopyCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.actionToolBar.setRenameCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.actionToolBar.setChangeStatusCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
            this.actionToolBar.setViewSourceCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.startSection(this.constants.ConfigurationSection());
        this.packageConfigurationValidationResult.clear();
        this.addRow((Widget)this.packageConfigurationValidationResult);
        this.addAttribute(this.constants.Configuration(), this.header());
        if (!this.isHistoricalReadOnly) {
            this.addAttribute(this.constants.CategoryRules(), this.getAddCatRules());
        }
        this.addAttribute("", this.getShowCatRules());
        if (!this.conf.isSnapshot && !this.isHistoricalReadOnly) {
            Button save = new Button(this.constants.ValidateConfiguration());
            save.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.addAttribute("", (Widget)save);
        }
        this.endSection();
        if (this.isHistoricalReadOnly) {
            this.startSection(this.constants.Dependencies());
            this.addRow((Widget)new DependencyWidget(this.conf, this.isHistoricalReadOnly));
            this.endSection();
        }
        if (!this.conf.isSnapshot && !this.isHistoricalReadOnly) {
            this.startSection(this.constants.BuildAndValidate());
            this.addRow((Widget)new PackageBuilderWidget(this.conf));
            this.endSection();
        }
        this.startSection(this.constants.InformationAndImportantURLs());
        Button buildSource = new Button(this.constants.ShowPackageSource());
        buildSource.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HTML html0 = new HTML("<a href='" + PackageEditor.getDocumentationDownload((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor.getDocumentationDownload((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.URLForDocumention(), this.createHPanel((Widget)html0, this.constants.URLDocumentionDescription()));
        HTML html = new HTML("<a href='" + this.getPackageSourceURL(this.conf) + "' target='_blank'>" + this.getPackageSourceURL(this.conf) + "</a>");
        this.addAttribute(this.constants.URLForPackageSource(), this.createHPanel((Widget)html, this.constants.URLSourceDescription()));
        HTML html2 = new HTML("<a href='" + this.getPackageBinaryURL(this.conf) + "' target='_blank'>" + this.getPackageBinaryURL(this.conf) + "</a>");
        this.addAttribute(this.constants.URLForPackageBinary(), this.createHPanel((Widget)html2, this.constants.UseThisUrlInTheRuntimeAgentToFetchAPreCompiledBinary()));
        HTML html3 = new HTML("<a href='" + PackageEditor.getScenarios((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor.getScenarios((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.URLForRunningTests(), this.createHPanel((Widget)html3, this.constants.URLRunTestsRemote()));
        HTML html4 = new HTML("<a href='" + PackageEditor.getChangeset((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor.getChangeset((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.ChangeSet(), this.createHPanel((Widget)html4, this.constants.URLToChangeSetForDeploymentAgents()));
        HTML html5 = new HTML("<a href='" + PackageEditor.getModelDownload((PackageConfigData)this.conf) + "' target='_blank'>" + PackageEditor.getModelDownload((PackageConfigData)this.conf) + "</a>");
        this.addAttribute(this.constants.ModelSet(), this.createHPanel((Widget)html5, this.constants.URLToDownloadModelSet()));
        Tree springContextTree = new Tree();
        TreeItem rootItem = new TreeItem("");
        springContextTree.addItem(rootItem);
        int rowNumber = this.addAttribute(this.constants.SpringContext() + ":", (Widget)springContextTree);
        9 callBack = new /* Unavailable Anonymous Inner Class!! */;
        RepositoryServiceFactory.getAssetService().listAssetsWithPackageName(this.conf.name, new String[]{"springContext"}, 0, -1, "rulelist", (AsyncCallback)callBack);
        this.endSection();
    }

    private Widget createHPanel(Widget widget, String popUpText) {
        HorizontalPanel hPanel = new HorizontalPanel();
        hPanel.add(widget);
        hPanel.add((Widget)new InfoPopup(this.constants.Tip(), popUpText));
        return hPanel;
    }

    public ActionToolbar getActionToolbar() {
        return this.actionToolBar;
    }

    private Widget getShowCatRules() {
        if (this.conf.catRules != null && this.conf.catRules.size() > 0) {
            VerticalPanel vp = new VerticalPanel();
            for (Map.Entry entry : this.conf.catRules.entrySet()) {
                HorizontalPanel hp = new HorizontalPanel();
                String m = this.constants.AllRulesForCategory0WillNowExtendTheRule1((String)entry.getValue(), (String)entry.getKey());
                hp.add((Widget)new SmallLabel(m));
                hp.add((Widget)this.getRemoveCatRulesIcon((String)entry.getKey()));
                vp.add((Widget)hp);
            }
            return vp;
        }
        return new HTML("&nbsp;&nbsp;");
    }

    private Image getRemoveCatRulesIcon(String rule) {
        Image remove = new Image(images.deleteItemSmall());
        remove.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return remove;
    }

    private Widget getAddCatRules() {
        ImageButton add = new ImageButton(images.edit());
        add.setTitle(this.constants.AddCatRuleToThePackage());
        add.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)add);
        hp.add((Widget)new InfoPopup(this.constants.CategoryParentRules(), this.constants.CatRulesInfo()));
        return hp;
    }

    private void addToCatRules(String category, String rule) {
        if (null != category && null != rule) {
            if (this.conf.catRules == null) {
                this.conf.catRules = new HashMap();
            }
            this.conf.catRules.put(rule, category);
        }
    }

    protected void showCatRuleSelector(Widget w) {
        FormStylePopup pop = new FormStylePopup(images.config(), this.constants.AddACategoryRuleToThePackage());
        Button addbutton = new Button(this.constants.OK());
        TextBox ruleName = new TextBox();
        CategoryExplorerWidget exw = new CategoryExplorerWidget((CategorySelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ruleName.setVisibleLength(15);
        addbutton.setTitle(this.constants.CreateCategoryRule());
        addbutton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.addAttribute(this.constants.AllTheRulesInFollowingCategory(), (Widget)exw);
        pop.addAttribute(this.constants.WillExtendTheFollowingRuleCalled(), (Widget)ruleName);
        pop.addAttribute("", (Widget)addbutton);
        pop.show();
    }

    private String getDateString(Date d) {
        if (d != null) {
            return DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(d);
        }
        return "";
    }

    private void showValidatePackageConfigurationResult(ValidatedResponse validatedResponse) {
        this.packageConfigurationValidationResult.clear();
        if (validatedResponse != null && validatedResponse.hasErrors) {
            Image img = new Image(images.warning());
            this.packageConfigurationValidationResult.add((Widget)img);
            HTML msg = new HTML("<b>" + this.constants.ThereWereErrorsValidatingThisPackageConfiguration() + "</b>");
            this.packageConfigurationValidationResult.add((Widget)msg);
            Button show = new Button(this.constants.ViewErrors());
            show.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.packageConfigurationValidationResult.add((Widget)show);
        } else {
            Image img = new Image(images.greenTick());
            this.packageConfigurationValidationResult.add((Widget)img);
            HTML msg = new HTML("<b>" + this.constants.PackageValidatedSuccessfully() + "</b>");
            this.packageConfigurationValidationResult.add((Widget)msg);
        }
    }

    static String getDocumentationDownload(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf) + "/documentation.pdf";
    }

    static String getSourceDownload(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf) + ".drl";
    }

    static String getBinaryDownload(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf);
    }

    static String getScenarios(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf) + "/SCENARIOS";
    }

    static String getChangeset(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf) + "/ChangeSet.xml";
    }

    public static String getModelDownload(PackageConfigData conf) {
        return PackageEditor.makeLink((PackageConfigData)conf) + "/MODEL";
    }

    static String getSpringContextDownload(PackageConfigData conf, String name) {
        return PackageEditor.makeLink((PackageConfigData)conf) + "/SpringContext/" + name;
    }

    static String getVersionFeed(PackageConfigData conf) {
        String hurl = PackageEditor.getRESTBaseURL() + "packages/" + conf.name + "/versions";
        return hurl;
    }

    String getPackageSourceURL(PackageConfigData conf) {
        String url = this.isHistoricalReadOnly ? PackageEditor.getRESTBaseURL() + "packages/" + conf.name + "/versions/" + conf.versionNumber + "/source" : PackageEditor.getRESTBaseURL() + "packages/" + conf.name + "/source";
        return url;
    }

    String getPackageBinaryURL(PackageConfigData conf) {
        String url = this.isHistoricalReadOnly ? PackageEditor.getRESTBaseURL() + "packages/" + conf.name + "/versions/" + conf.versionNumber + "/binary" : PackageEditor.getRESTBaseURL() + "packages/" + conf.name + "/binary";
        return url;
    }

    static String getRESTBaseURL() {
        String url = GWT.getModuleBaseURL();
        return url.replaceFirst("org.drools.guvnor.Guvnor", "rest");
    }

    public static String makeLink(PackageConfigData conf) {
        String hurl = GWT.getModuleBaseURL() + "package/" + conf.name;
        hurl = !conf.isSnapshot ? hurl + "/" + "LATEST" : hurl + "/" + conf.snapshotName;
        String uri = hurl;
        return uri;
    }

    protected void showStatusChanger() {
        StatusChangePopup pop = new StatusChangePopup(this.conf.uuid, true);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void doRename() {
        FormStylePopup pop = new FormStylePopup(images.newWiz(), this.constants.RenameThePackage());
        pop.addRow((Widget)new HTML(this.constants.RenamePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(this.constants.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void completedRenaming(String newAssetUUID) {
        Window.alert((String)this.constants.PackageRenamedSuccessfully());
        this.refreshPackageListCommand.execute();
        if (this.closeCommand != null) {
            this.closeCommand.execute();
        }
        if (this.openPackageCommand != null) {
            this.openPackageCommand.open(newAssetUUID, this.refreshPackageListCommand);
        }
    }

    private void doCopy() {
        FormStylePopup pop = new FormStylePopup(images.newWiz(), this.constants.CopyThePackage());
        pop.addRow((Widget)new HTML(this.constants.CopyThePackageTip()));
        TextBox name = new TextBox();
        pop.addAttribute(this.constants.NewPackageNameIs(), (Widget)name);
        Button ok = new Button(this.constants.OK());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void completedCopying(String newAssetUUID) {
        Window.alert((String)this.constants.PackageCopiedSuccessfully());
        this.refreshPackageListCommand.execute();
        if (this.openPackageCommand != null) {
            this.openPackageCommand.open(newAssetUUID, this.refreshPackageListCommand);
        }
    }

    private void doSave(Command refresh) {
        LoadingPopup.showMessage((String)this.constants.SavingPackageConfigurationPleaseWait());
        RepositoryServiceFactory.getPackageService().savePackage(this.conf, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doValidatePackageConfiguration(Command refresh) {
        HorizontalPanel busy = new HorizontalPanel();
        busy.add((Widget)new Label(this.constants.ValidatingAndBuildingPackagePleaseWait()));
        busy.add((Widget)new Image(images.redAnime()));
        this.packageConfigurationValidationResult.add((Widget)busy);
        RepositoryServiceFactory.getPackageService().validatePackageConfiguration(this.conf, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void reload() {
        LoadingPopup.showMessage((String)this.constants.RefreshingPackageData());
        RepositoryServiceFactory.getPackageService().loadPackageConfig(this.conf.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget header() {
        return new PackageHeaderWidget(this.conf, this.isHistoricalReadOnly);
    }

    private ActionToolbarButtonsConfigurationProvider getConfiguration() {
        return new PackageActionToolbarButtonsConfigurationProvider();
    }

    private void doArchive() {
        this.conf.archived = true;
        21 ref = new /* Unavailable Anonymous Inner Class!! */;
        this.doSave((Command)ref);
    }

    static /* synthetic */ void access$000(PackageEditor x0, Command x1) {
        x0.doSave(x1);
    }

    static /* synthetic */ void access$100(PackageEditor x0) {
        x0.doArchive();
    }

    static /* synthetic */ void access$200(PackageEditor x0) {
        x0.doCopy();
    }

    static /* synthetic */ void access$300(PackageEditor x0) {
        x0.doRename();
    }

    static /* synthetic */ PackageConfigData access$400(PackageEditor x0) {
        return x0.conf;
    }

    static /* synthetic */ void access$500(PackageEditor x0, Command x1) {
        x0.doValidatePackageConfiguration(x1);
    }

    static /* synthetic */ Constants access$600(PackageEditor x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$700(PackageEditor x0) {
        x0.refreshWidgets();
    }

    static /* synthetic */ void access$800(PackageEditor x0, String x1, String x2) {
        x0.addToCatRules(x1, x2);
    }

    static /* synthetic */ ActionToolbar access$900(PackageEditor x0) {
        return x0.actionToolBar;
    }

    static /* synthetic */ void access$1000(PackageEditor x0, String x1) {
        x0.completedRenaming(x1);
    }

    static /* synthetic */ void access$1100(PackageEditor x0, String x1) {
        x0.completedCopying(x1);
    }

    static /* synthetic */ void access$1200(PackageEditor x0, ValidatedResponse x1) {
        x0.showValidatePackageConfigurationResult(x1);
    }

    static /* synthetic */ PackageConfigData access$402(PackageEditor x0, PackageConfigData x1) {
        x0.conf = x1;
        return x0.conf;
    }

    static /* synthetic */ Command access$1300(PackageEditor x0) {
        return x0.closeCommand;
    }

    static /* synthetic */ Command access$1400(PackageEditor x0) {
        return x0.refreshPackageListCommand;
    }
}

