/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.categorynav.CategoryExplorerWidget;
import org.drools.guvnor.client.categorynav.CategorySelectHandler;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.GlobalAreaAssetSelector;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.ruleeditor.NewAssetWizard;
import org.drools.guvnor.client.rulelist.OpenItemCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class NewAssetWizard
extends FormStylePopup {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private TextBox name = new TextBox();
    private TextArea description = new TextArea();
    private String initialCategory;
    private ListBox formatChooser = this.getFormatChooser();
    RadioButton createInPackageButton = new RadioButton("creatinpackagegroup", this.constants.CreateInPackage());
    RadioButton createInGlobalButton = new RadioButton("creatinpackagegroup", this.constants.CreateInGlobalArea());
    private RulePackageSelector packageSelector = new RulePackageSelector();
    private RulePackageSelector importedPackageSelector = new RulePackageSelector();
    private GlobalAreaAssetSelector globalAreaAssetSelector;
    private OpenItemCommand afterCreate;
    private boolean showCategories;
    private String format;
    private final NewAssetFormStyleLayout newAssetLayout = new NewAssetFormStyleLayout(this, null);
    private final ImportAssetFormStyleLayout importAssetLayout = new ImportAssetFormStyleLayout(this, null);

    public NewAssetWizard(OpenItemCommand afterCreate, boolean showCategories, String format, String title) {
        super(images.newWiz(), title);
        this.showCategories = showCategories;
        this.format = format;
        this.afterCreate = afterCreate;
        RadioButton newPackage = new RadioButton("layoutgroup", this.constants.CreateNewAsset());
        newPackage.setValue(Boolean.valueOf(true));
        RadioButton importPackage = new RadioButton("layoutgroup", this.constants.CreateLinkedAsset());
        this.newAssetLayout.setVisible(true);
        this.createClickHandlerForNewPackageButton(newPackage);
        this.importAssetLayout.setVisible(false);
        this.createClickHandlerForImportPackageButton(importPackage);
        this.addAttribute("", (Widget)this.createVerticalPanelFor(newPackage, importPackage));
        this.addRow((Widget)this.newAssetLayout);
        this.addRow((Widget)this.importAssetLayout);
        this.newAssetLayout.addAttribute(this.constants.NameColon(), (Widget)this.name);
        this.setAfterShowCommand();
        if (showCategories) {
            this.newAssetLayout.addAttribute(this.constants.InitialCategory(), this.getCatChooser());
        }
        this.handleLayoutForFormat(format);
        this.createInPackageButton.setValue(Boolean.valueOf(true));
        this.newAssetLayout.buildNewAssetFormStyleLayout();
        this.globalAreaAssetSelector = new GlobalAreaAssetSelector(format);
        this.importAssetLayout.buildImportAssetLayout();
    }

    private Button createOkButtonAndClickHandler() {
        Button ok = new Button(this.constants.OK());
        ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return ok;
    }

    private HorizontalPanel createHorizontalePanelFor() {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)this.createInPackageButton);
        hp.add((Widget)this.packageSelector);
        return hp;
    }

    private void handleLayoutForFormat(String format) {
        if (format == null) {
            this.newAssetLayout.addAttribute(this.constants.TypeFormatOfRule(), (Widget)this.formatChooser);
        } else if ("*".equals(format)) {
            TextBox fmt = new TextBox();
            this.newAssetLayout.addAttribute(this.constants.FileExtensionTypeFormat(), (Widget)fmt);
            fmt.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void setAfterShowCommand() {
        this.setAfterShow((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private VerticalPanel createVerticalPanelFor(RadioButton newPackage, RadioButton importPackage) {
        VerticalPanel ab = new VerticalPanel();
        ab.add((Widget)newPackage);
        ab.add((Widget)importPackage);
        return ab;
    }

    private void createClickHandlerForImportPackageButton(RadioButton importPackage) {
        importPackage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createClickHandlerForNewPackageButton(RadioButton newPackage) {
        newPackage.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget getCatChooser() {
        CategoryExplorerWidget w = new CategoryExplorerWidget((CategorySelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ScrollPanel scroll = new ScrollPanel((Widget)w);
        scroll.setAlwaysShowScrollBars(true);
        scroll.setSize("300px", "130px");
        return scroll;
    }

    private ListBox getFormatChooser() {
        ListBox box = new ListBox();
        box.addItem(this.constants.BusinessRuleGuidedEditor(), "brl");
        box.addItem(this.constants.DSLBusinessRuleTextEditor(), "dslr");
        box.addItem(this.constants.DRLRuleTechnicalRuleTextEditor(), "drl");
        box.addItem(this.constants.DecisionTableSpreadsheet(), "xls");
        box.addItem(this.constants.DecisionTableWebGuidedEditor(), "gdst");
        box.setSelectedIndex(0);
        return box;
    }

    void ok() {
        if (this.showCategories && this.initialCategory == null) {
            Window.alert((String)this.constants.YouHaveToPickAnInitialCategory());
            return;
        }
        if (!NewAssetWizard.validatePathPerJSR170((String)this.name.getText())) {
            return;
        }
        if ("*".equals(this.getFormat())) {
            Window.alert((String)this.constants.PleaseEnterAFormatFileType());
            return;
        }
        String selectedPackage = this.createInGlobalButton.getValue() != false ? "globalArea" : this.packageSelector.getSelectedPackage();
        LoadingPopup.showMessage((String)this.constants.PleaseWaitDotDotDot());
        RepositoryServiceFactory.getService().createNewRule(this.name.getText(), this.description.getText(), this.initialCategory, selectedPackage, this.getFormat(), (AsyncCallback)this.createGenericCallbackForOk());
    }

    void importOK() {
        LoadingPopup.showMessage((String)this.constants.PleaseWaitDotDotDot());
        RepositoryServiceFactory.getService().createNewImportedRule(this.globalAreaAssetSelector.getSelectedAsset(), this.importedPackageSelector.getSelectedPackage(), (AsyncCallback)this.createGenericCallbackForOk());
    }

    private GenericCallback<String> createGenericCallbackForOk() {
        7 cb = new /* Unavailable Anonymous Inner Class!! */;
        return cb;
    }

    private String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        return this.formatChooser.getValue(this.formatChooser.getSelectedIndex());
    }

    protected void openEditor(String uuid) {
        this.afterCreate.open(uuid);
    }

    public static boolean validatePathPerJSR170(String jsrPath) {
        int len;
        int n = len = jsrPath == null ? 0 : jsrPath.trim().length();
        if (len == 0) {
            Window.alert((String)((Constants)GWT.create(Constants.class)).emptyNameIsNotAllowed());
            return false;
        }
        for (int pos = 0; pos < len; ++pos) {
            char c = jsrPath.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': 
                case '*': 
                case '/': 
                case ':': 
                case '[': 
                case ']': {
                    Window.alert((String)((Constants)GWT.create(Constants.class)).NonValidJCRName(jsrPath, c));
                    return false;
                }
            }
        }
        return true;
    }

    static /* synthetic */ Constants access$200(NewAssetWizard x0) {
        return x0.constants;
    }

    static /* synthetic */ GlobalAreaAssetSelector access$300(NewAssetWizard x0) {
        return x0.globalAreaAssetSelector;
    }

    static /* synthetic */ RulePackageSelector access$400(NewAssetWizard x0) {
        return x0.importedPackageSelector;
    }

    static /* synthetic */ HorizontalPanel access$500(NewAssetWizard x0) {
        return x0.createHorizontalePanelFor();
    }

    static /* synthetic */ String access$600(NewAssetWizard x0) {
        return x0.format;
    }

    static /* synthetic */ TextArea access$700(NewAssetWizard x0) {
        return x0.description;
    }

    static /* synthetic */ Button access$800(NewAssetWizard x0) {
        return x0.createOkButtonAndClickHandler();
    }

    static /* synthetic */ String access$602(NewAssetWizard x0, String x1) {
        x0.format = x1;
        return x0.format;
    }

    static /* synthetic */ TextBox access$900(NewAssetWizard x0) {
        return x0.name;
    }

    static /* synthetic */ NewAssetFormStyleLayout access$1000(NewAssetWizard x0) {
        return x0.newAssetLayout;
    }

    static /* synthetic */ ImportAssetFormStyleLayout access$1100(NewAssetWizard x0) {
        return x0.importAssetLayout;
    }

    static /* synthetic */ String access$1202(NewAssetWizard x0, String x1) {
        x0.initialCategory = x1;
        return x0.initialCategory;
    }
}

