/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.packages.ArtifactEditor;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.RuleViewerSettings;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.toolbar.ActionToolbarButtonsConfigurationProvider;
import org.drools.guvnor.client.rulelist.OpenItemCommand;

public class RuleViewerWrapper
extends GuvnorEditor {
    private ArtifactEditor artifactEditor;
    private RuleViewer ruleViewer;
    private ActionToolbar actionToolBar;
    private RuleAsset asset;
    private boolean isHistoricalReadOnly = false;
    private final RuleViewerSettings ruleViewerSettings;
    private final OpenItemCommand openItemCommand;
    private Command closeCommand;
    private Command archiveCommand;
    private Command checkedInCommand;
    ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider;

    public RuleViewerWrapper(RuleAsset asset, OpenItemCommand openItemCommand, Command closeCommand, Command checkedInCommand, Command archiveCommand) {
        this(asset, openItemCommand, closeCommand, checkedInCommand, archiveCommand, false, null, null);
    }

    public RuleViewerWrapper(RuleAsset asset, OpenItemCommand event, Command closeCommand, Command checkedInCommand, Command archiveCommand, boolean isHistoricalReadOnly, ActionToolbarButtonsConfigurationProvider actionToolbarButtonsConfigurationProvider, RuleViewerSettings ruleViewerSettings) {
        this.asset = asset;
        this.isHistoricalReadOnly = isHistoricalReadOnly;
        this.openItemCommand = event;
        this.ruleViewerSettings = ruleViewerSettings;
        this.closeCommand = closeCommand;
        this.checkedInCommand = checkedInCommand;
        this.archiveCommand = archiveCommand;
        this.refreshWidgets();
        this.setWidth("100%");
    }

    private void refreshWidgets() {
        this.artifactEditor = new ArtifactEditor((Artifact)this.asset, this.isHistoricalReadOnly);
        this.ruleViewer = new RuleViewer(this.asset, this.openItemCommand, this.closeCommand, this.checkedInCommand, this.archiveCommand, this.isHistoricalReadOnly, this.actionToolbarButtonsConfigurationProvider, this.ruleViewerSettings);
        this.actionToolBar = this.ruleViewer.getActionToolbar();
        VerticalPanel vp = new VerticalPanel();
        vp.add((Widget)this.actionToolBar);
        TabPanel tPanel = new TabPanel();
        tPanel.setWidth("100%");
        ScrollPanel pnl = new ScrollPanel();
        pnl.add((Widget)this.artifactEditor);
        tPanel.add((Widget)pnl, "Attributes");
        pnl = new ScrollPanel();
        pnl.add((Widget)this.ruleViewer);
        tPanel.add((Widget)pnl, "Edit");
        tPanel.selectTab(1);
        vp.add((Widget)tPanel);
        this.initWidget((Widget)vp);
    }
}

