/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.Images;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.TableDataRow;

public class VersionChooser
extends Composite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private String packageUUID;
    private String assetName;
    private ListBox versionChooser;
    private List<TableDataRow> versionInfo = new ArrayList();
    private String currentVersion;

    public VersionChooser(String currentVersion, String pacakgeUUID, String assetName, Command ref) {
        this.packageUUID = pacakgeUUID;
        this.assetName = assetName;
        this.currentVersion = currentVersion;
        VerticalPanel verticalPanel = new VerticalPanel();
        this.versionChooser = new ListBox();
        this.loadHistoryData();
        verticalPanel.add((Widget)this.versionChooser);
        Button open = new Button("View selected version");
        open.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        verticalPanel.add((Widget)open);
        this.initWidget((Widget)verticalPanel);
    }

    protected void loadHistoryData() {
        RepositoryServiceFactory.getAssetService().loadAssetHistory(this.packageUUID, this.assetName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getSelectedVersionUUID() {
        if (this.versionChooser != null) {
            return this.versionChooser.getValue(this.versionChooser.getSelectedIndex());
        }
        return null;
    }

    private void selectCurrentVersion(String currentVersion) {
        for (int i = 0; i < this.versionInfo.size(); ++i) {
            TableDataRow row = (TableDataRow)this.versionInfo.get(i);
            if (!row.values[0].equals(currentVersion)) continue;
            this.versionChooser.setSelectedIndex(i);
            break;
        }
    }

    public String getSelectedVersionName() {
        TableDataRow t;
        if (this.versionChooser != null && (t = (TableDataRow)this.versionInfo.get(this.versionChooser.getSelectedIndex())) != null) {
            return t.values[0];
        }
        return null;
    }

    private void showVersion(String versionUUID) {
        LoadingPopup.showMessage((String)this.constants.LoadingVersionFromHistory());
        RepositoryServiceFactory.getAssetService().loadRuleAsset(versionUUID, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ ListBox access$000(VersionChooser x0) {
        return x0.versionChooser;
    }

    static /* synthetic */ Constants access$100(VersionChooser x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$200(VersionChooser x0, String x1) {
        x0.showVersion(x1);
    }

    static /* synthetic */ List access$300(VersionChooser x0) {
        return x0.versionInfo;
    }

    static /* synthetic */ String access$400(VersionChooser x0) {
        return x0.currentVersion;
    }

    static /* synthetic */ void access$500(VersionChooser x0, String x1) {
        x0.selectCurrentVersion(x1);
    }

    static /* synthetic */ Images access$600() {
        return images;
    }
}

