/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rulefloweditor;

import java.util.ArrayList;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.client.rulefloweditor.ActionNode;
import org.drools.guvnor.client.rulefloweditor.CompositeNode;
import org.drools.guvnor.client.rulefloweditor.ElementContainerNode;
import org.drools.guvnor.client.rulefloweditor.ElementContainerTransferNode;
import org.drools.guvnor.client.rulefloweditor.EmailNode;
import org.drools.guvnor.client.rulefloweditor.EndNode;
import org.drools.guvnor.client.rulefloweditor.EventNode;
import org.drools.guvnor.client.rulefloweditor.FaultNode;
import org.drools.guvnor.client.rulefloweditor.ForEachNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskTransferNode;
import org.drools.guvnor.client.rulefloweditor.JoinNode;
import org.drools.guvnor.client.rulefloweditor.LogNode;
import org.drools.guvnor.client.rulefloweditor.MileStoneNode;
import org.drools.guvnor.client.rulefloweditor.RuleFlowBaseNode;
import org.drools.guvnor.client.rulefloweditor.RuleSetNode;
import org.drools.guvnor.client.rulefloweditor.SplitNode;
import org.drools.guvnor.client.rulefloweditor.SplitTransferNode;
import org.drools.guvnor.client.rulefloweditor.StartNode;
import org.drools.guvnor.client.rulefloweditor.SubProcessNode;
import org.drools.guvnor.client.rulefloweditor.TimerNode;
import org.drools.guvnor.client.rulefloweditor.TransferNode;
import org.drools.guvnor.client.rulefloweditor.WorkItemNode;
import org.drools.guvnor.client.rulefloweditor.WorkItemTransferNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransferRuleFlowNodeFactory {
    public static TransferNode createNode(RuleFlowBaseNode node) {
        TransferNode tn;
        if (node instanceof StartNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.START);
        } else if (node instanceof HumanTaskNode) {
            tn = TransferRuleFlowNodeFactory.createHumanTask((HumanTaskNode)((HumanTaskNode)node));
        } else if (node instanceof JoinNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.JOIN);
        } else if (node instanceof SubProcessNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.SUB_PROCESS);
        } else if (node instanceof MileStoneNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.MILESTONE);
        } else if (node instanceof TimerNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.TIMER);
        } else if (node instanceof ActionNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.ACTION_NODE);
        } else if (node instanceof WorkItemNode) {
            tn = TransferRuleFlowNodeFactory.createWorkItemNode((WorkItemNode)((WorkItemNode)node));
        } else if (node instanceof RuleSetNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.RULESET);
        } else if (node instanceof SplitNode) {
            tn = TransferRuleFlowNodeFactory.createSplit((SplitNode)((SplitNode)node));
        } else if (node instanceof ForEachNode) {
            tn = TransferRuleFlowNodeFactory.ElementContainerTransferNode((ElementContainerNode)((ForEachNode)node));
            tn.setType(TransferNode.Type.FOR_EACH);
        } else if (node instanceof FaultNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.FAULT);
        } else if (node instanceof EventNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.EVENT);
        } else if (node instanceof CompositeNode) {
            tn = TransferRuleFlowNodeFactory.ElementContainerTransferNode((ElementContainerNode)((CompositeNode)node));
            tn.setType(TransferNode.Type.COMPOSITE);
        } else if (node instanceof EndNode) {
            tn = new TransferNode();
            tn.setType(TransferNode.Type.END);
        } else {
            throw new IllegalArgumentException("Unkown node type " + node);
        }
        tn.setId(node.getId());
        return tn;
    }

    private static TransferNode ElementContainerTransferNode(ElementContainerNode node) {
        ElementContainerTransferNode fetn = new ElementContainerTransferNode();
        ArrayList<TransferNode> baseNodes = new ArrayList<TransferNode>();
        for (RuleFlowBaseNode subNode : node.getNodes().values()) {
            baseNodes.add(TransferRuleFlowNodeFactory.createNode((RuleFlowBaseNode)subNode));
        }
        RuleFlowContentModel model = new RuleFlowContentModel();
        model.setNodes(baseNodes);
        fetn.setContentModel(model);
        return fetn;
    }

    private static WorkItemTransferNode createWorkItemNode(WorkItemNode node) {
        WorkItemTransferNode tn = null;
        if (node instanceof EmailNode) {
            tn = new WorkItemTransferNode();
            tn.setWorkName("Email");
        } else if (node instanceof LogNode) {
            tn = new WorkItemTransferNode();
            tn.setWorkName("Log");
        }
        tn.setParameters(node.attributes);
        return tn;
    }

    private static SplitTransferNode createSplit(SplitNode node) {
        SplitTransferNode splitNode = new SplitTransferNode();
        splitNode.setSplitType(node.type);
        splitNode.setConstraints(node.constraints);
        return splitNode;
    }

    private static TransferNode createHumanTask(HumanTaskNode node) {
        HumanTaskTransferNode n = new HumanTaskTransferNode();
        n.setParameters(node.getParameters());
        return n;
    }
}

