/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.decoratedgrid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.resources.DecisionTableResources;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.ColumnResizeHandler;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSystemControlledColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.MergableGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.RowGroupingChangeHandler;
import org.drools.guvnor.client.widgets.decoratedgrid.SelectedCellChangeHandler;
import org.drools.guvnor.client.widgets.decoratedgrid.SortConfiguration;
import org.drools.guvnor.client.widgets.decoratedgrid.data.DynamicDataRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecoratedGridWidget<T>
extends Composite {
    protected Panel mainPanel = this.getMainPanel();
    protected Panel bodyPanel = this.getBodyPanel();
    protected ScrollPanel scrollPanel;
    protected MergableGridWidget<T> gridWidget = this.getGridWidget();
    protected DecoratedGridHeaderWidget<T> headerWidget;
    protected DecoratedGridSidebarWidget<T> sidebarWidget;
    protected HasSystemControlledColumns hasSystemControlledColumns;
    protected int height;
    protected int width;
    protected static final DecisionTableResources resource = (DecisionTableResources)GWT.create(DecisionTableResources.class);
    protected static final DecisionTableResources.DecisionTableStyle style = resource.cellTableStyle();

    public DecoratedGridWidget() {
        if (this.mainPanel == null) {
            throw new IllegalArgumentException("mainPanel cannot be null");
        }
        if (this.bodyPanel == null) {
            throw new IllegalArgumentException("bodyPanel cannot be null");
        }
        if (this.gridWidget == null) {
            throw new IllegalArgumentException("gridWidget cannot be null");
        }
        this.scrollPanel = new ScrollPanel();
        this.scrollPanel.add((Widget)this.gridWidget);
        this.scrollPanel.addScrollHandler(this.getScrollHandler());
        this.initWidget((Widget)this.mainPanel);
        this.gridWidget.addSelectedCellChangeHandler((SelectedCellChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void appendColumn(DynamicColumn<T> column, List<CellValue<? extends Comparable<?>>> columnData, boolean bRedraw) {
        this.insertColumnBefore(null, column, columnData, bRedraw);
    }

    public void assertDimensions() {
        this.headerWidget.setWidth(this.scrollPanel.getElement().getClientWidth() + "px");
        this.sidebarWidget.setHeight(this.scrollPanel.getElement().getClientHeight() + "px");
    }

    public void deleteColumn(DynamicColumn<T> column) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null.");
        }
        this.gridWidget.deleteColumn(column, true);
        this.headerWidget.redraw();
        this.assertDimensions();
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.sidebarWidget.deleteSelector(row);
        this.gridWidget.deleteRow(row);
        this.assertDimensions();
    }

    public abstract Panel getBodyPanel();

    public abstract MergableGridWidget<T> getGridWidget();

    public DecoratedGridHeaderWidget<T> getHeaderWidget() {
        return this.headerWidget;
    }

    public abstract Panel getMainPanel();

    public abstract ScrollHandler getScrollHandler();

    public DecoratedGridSidebarWidget<T> getSidebarWidget() {
        return this.sidebarWidget;
    }

    public void insertColumnBefore(DynamicColumn<T> columnBefore, DynamicColumn<T> newColumn, List<CellValue<? extends Comparable<?>>> columnData, boolean bRedraw) {
        if (newColumn == null) {
            throw new IllegalArgumentException("newColumn cannot be null");
        }
        if (columnData == null) {
            throw new IllegalArgumentException("columnData cannot be null");
        }
        this.gridWidget.insertColumnBefore(columnBefore, newColumn, columnData, bRedraw);
        if (bRedraw) {
            this.headerWidget.redraw();
            this.assertDimensions();
        }
    }

    public void insertRowBefore(DynamicDataRow rowBefore, List<CellValue<? extends Comparable<?>>> rowData) {
        if (rowData == null) {
            throw new IllegalArgumentException("rowData cannot be null");
        }
        DynamicDataRow row = this.gridWidget.insertRowBefore(rowBefore, rowData);
        this.sidebarWidget.insertSelector(row);
        this.assertDimensions();
    }

    public void redrawSystemControlledColumns() {
        List columns = this.gridWidget.getColumns();
        for (DynamicColumn col : columns) {
            if (!col.isSystemControlled()) continue;
            this.gridWidget.redrawColumn(col.getColumnIndex());
        }
    }

    public void setColumnVisibility(int index, boolean isVisible) {
        List columns = this.gridWidget.getColumns();
        if (index < 0 || index > columns.size()) {
            throw new IllegalArgumentException("Column index must be greater than zero and less than then number of declared columns.");
        }
        if (isVisible && !((DynamicColumn)columns.get(index)).isVisible()) {
            ((DynamicColumn)columns.get(index)).setVisible(isVisible);
            this.gridWidget.getData().setColumnVisibility(index, isVisible);
            this.gridWidget.showColumn(index);
            this.headerWidget.redraw();
        } else if (!isVisible && ((DynamicColumn)columns.get(index)).isVisible()) {
            ((DynamicColumn)columns.get(index)).setVisible(isVisible);
            this.gridWidget.getData().setColumnVisibility(index, isVisible);
            this.gridWidget.hideColumn(index);
            this.headerWidget.redraw();
        }
    }

    public void setHasSystemControlledColumns(HasSystemControlledColumns hasSystemControlledColumns) {
        this.hasSystemControlledColumns = hasSystemControlledColumns;
    }

    public void setHeaderWidget(DecoratedGridHeaderWidget<T> headerWidget) {
        if (headerWidget == null) {
            throw new IllegalArgumentException("headerWidget cannot be null");
        }
        this.headerWidget = headerWidget;
        headerWidget.addColumnResizeHandler((ColumnResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.headerWidget.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.bodyPanel.add(headerWidget);
        this.bodyPanel.add((Widget)this.scrollPanel);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.height = height;
        this.setHeight(height);
        this.setWidth(width);
    }

    public void setSidebarWidget(DecoratedGridSidebarWidget<T> sidebarWidget) {
        if (sidebarWidget == null) {
            throw new IllegalArgumentException("sidebarWidget cannot be null");
        }
        this.sidebarWidget = sidebarWidget;
        this.headerWidget.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.gridWidget.addRowGroupingChangeHandler((RowGroupingChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mainPanel.add(sidebarWidget);
        this.mainPanel.add((Widget)this.bodyPanel);
    }

    public void sort() {
        ArrayList<SortConfiguration> sortConfig = new ArrayList<SortConfiguration>();
        List columns = this.gridWidget.getColumns();
        for (DynamicColumn column : columns) {
            SortConfiguration sc = column.getSortConfiguration();
            if (sc.getSortIndex() == -1) continue;
            sortConfig.add(sc);
        }
        this.gridWidget.getData().sort(sortConfig);
        this.gridWidget.redraw();
        this.sidebarWidget.redraw();
    }

    private void cellSelected(MergableGridWidget.CellSelectionDetail ce) {
        if (ce.getOffsetX() < this.scrollPanel.getHorizontalScrollPosition()) {
            this.scrollPanel.setHorizontalScrollPosition(ce.getOffsetX());
        }
        int scrollWidth = this.scrollPanel.getElement().getClientWidth();
        if (ce.getOffsetX() + ce.getWidth() > scrollWidth + this.scrollPanel.getHorizontalScrollPosition()) {
            int delta = ce.getOffsetX() + ce.getWidth() - this.scrollPanel.getHorizontalScrollPosition() - scrollWidth;
            this.scrollPanel.setHorizontalScrollPosition(this.scrollPanel.getHorizontalScrollPosition() + delta);
        }
        if (ce.getOffsetY() < this.scrollPanel.getScrollPosition()) {
            this.scrollPanel.setScrollPosition(ce.getOffsetY());
        }
        int scrollHeight = this.scrollPanel.getElement().getClientHeight();
        if (ce.getOffsetY() + ce.getHeight() > scrollHeight + this.scrollPanel.getScrollPosition()) {
            int delta = ce.getOffsetY() + ce.getHeight() - this.scrollPanel.getScrollPosition() - scrollHeight;
            this.scrollPanel.setScrollPosition(this.scrollPanel.getScrollPosition() + delta);
        }
    }

    private void setHeight(int height) {
        this.mainPanel.setHeight(height + "px");
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setWidth(int width) {
        this.mainPanel.setWidth(width + "px");
        this.scrollPanel.setWidth(width - style.sidebarWidth() + "px");
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(DecoratedGridWidget x0, MergableGridWidget.CellSelectionDetail x1) {
        x0.cellSelected(x1);
    }
}

