/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class GuvnorSimplePager
extends SimplePager {
    private int pageSize = 10;

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        super.setPageSize(pageSize);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void nextPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() + this.getPageSize());
        }
    }

    public void previousPage() {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            this.setPageStart(range.getStart() - this.getPageSize());
        }
    }

    public void setPageStart(int index) {
        if (this.getDisplay() != null) {
            Range range = this.getDisplay().getVisibleRange();
            int displayPageSize = this.getPageSize();
            if (this.isRangeLimited() && this.getDisplay().isRowCountExact()) {
                displayPageSize = Math.min(this.getPageSize(), this.getDisplay().getRowCount() - index);
            }
            if ((index = Math.max(0, index)) != range.getStart()) {
                this.getDisplay().setVisibleRange(index, displayPageSize);
            }
        }
    }

    protected String createText() {
        NumberFormat formatter = NumberFormat.getFormat((String)"#,###");
        HasRows display = this.getDisplay();
        Range range = display.getVisibleRange();
        int pageStart = range.getStart() + 1;
        int pageSize = range.getLength();
        int dataSize = display.getRowCount();
        int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
        endIndex = Math.max(pageStart, endIndex);
        boolean exact = display.isRowCountExact();
        if (dataSize == 0) {
            return "0 of 0";
        }
        if (pageStart == endIndex) {
            return formatter.format((double)pageStart) + " of " + formatter.format((double)dataSize);
        }
        return formatter.format((double)pageStart) + "-" + formatter.format((double)endIndex) + (exact ? " of " : " of over ") + formatter.format((double)dataSize);
    }
}

