/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.drools.ClockType;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.event.AgendaEventListener;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.PackageService;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.ScenarioResultSummary;
import org.drools.guvnor.client.rpc.ScenarioRunResult;
import org.drools.guvnor.client.rpc.SingleScenarioResult;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.rpc.ValidatedResponse;
import org.drools.guvnor.server.PackageFilter;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryPackageOperations;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.AuditLogReporter;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.cache.RuleBaseCache;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.security.PackageUUIDType;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.PackageIterator;
import org.drools.repository.RepositoryFilter;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.runtime.rule.ConsequenceException;
import org.drools.testframework.RuleCoverageListener;
import org.drools.testframework.ScenarioRunner;
import org.drools.util.CompositeClassLoader;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.security.Restrict;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.security.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.drools.guvnor.client.rpc.PackageService")
@AutoCreate
public class RepositoryPackageService
implements PackageService {
    @In
    private RulesRepository repository;
    private static final long serialVersionUID = 901123L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetService.class);
    private ServiceSecurity serviceSecurity = new ServiceSecurity();
    private RepositoryPackageOperations repositoryPackageOperations = new RepositoryPackageOperations();
    private RepositoryAssetOperations repositoryAssetOperations = new RepositoryAssetOperations();

    @Create
    public void create() {
        this.repositoryPackageOperations.setRulesRepository(this.getRulesRepository());
        this.repositoryAssetOperations.setRulesRepository(this.getRulesRepository());
    }

    public void setRulesRepository(RulesRepository repository) {
        this.repository = repository;
        this.create();
    }

    public RulesRepository getRulesRepository() {
        return this.repository;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages() {
        return this.listPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listPackages(String workspace) {
        PackageFilter pf = new PackageFilter();
        return this.repositoryPackageOperations.listPackages(false, workspace, (RepositoryFilter)pf);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages() {
        return this.listArchivedPackages(null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData[] listArchivedPackages(String workspace) {
        PackageFilter pf = new PackageFilter();
        return this.repositoryPackageOperations.listPackages(true, workspace, (RepositoryFilter)pf);
    }

    public PackageConfigData loadGlobalPackage() {
        return this.repositoryPackageOperations.loadGlobalPackage();
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void rebuildPackages() throws SerializationException {
        PackageIterator pkit = this.getRulesRepository().listPackages();
        StringBuilder errs = new StringBuilder();
        while (pkit.hasNext()) {
            PackageItem pkg = (PackageItem)pkit.next();
            try {
                BuilderResult builderResult = this.buildPackage(pkg.getUUID(), true);
                if (builderResult == null) continue;
                errs.append("Unable to build package name [").append(pkg.getName()).append("]\n");
                StringBuilder buf = this.createStringBuilderFrom(builderResult);
                log.warn(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("An error occurred building package [" + pkg.getName() + "]\n");
                errs.append("An error occurred building package [").append(pkg.getName()).append("]\n");
            }
        }
        if (errs.toString().length() > 0) {
            // empty if block
        }
    }

    private StringBuilder createStringBuilderFrom(BuilderResult res) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.getLines().size(); ++i) {
            buf.append(((BuilderResultLine)res.getLines().get(i)).toString());
            buf.append('\n');
        }
        return buf;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String buildPackageSource(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(packageUUID);
        return this.repositoryPackageOperations.buildPackageSource(packageUUID);
    }

    @WebRemote
    public String copyPackage(String sourcePackageName, String destPackageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.copyPackage(sourcePackageName, destPackageName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void removePackage(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageAdmin(uuid);
        this.repositoryPackageOperations.removePackage(uuid);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String renamePackage(String uuid, String newName) {
        this.serviceSecurity.checkSecurityIsPackageAdmin(uuid);
        return this.repositoryPackageOperations.renamePackage(uuid, newName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public byte[] exportPackages(String packageName) {
        this.serviceSecurity.checkSecurityIsPackageNameTypeAdmin(packageName);
        return this.repositoryPackageOperations.exportPackages(packageName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void importPackages(byte[] byteArray, boolean importAsNew) {
        this.repositoryPackageOperations.importPackages(byteArray, importAsNew);
    }

    @WebRemote
    public String createPackage(String name, String description, String[] workspace) throws RulesRepositoryException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.createPackage(name, description, workspace);
    }

    @WebRemote
    public String createPackage(String name, String description) throws RulesRepositoryException {
        return this.createPackage(name, description, new String[0]);
    }

    @WebRemote
    public String createSubPackage(String name, String description, String parentNode) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryPackageOperations.createSubPackage(name, description, parentNode);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public PackageConfigData loadPackageConfig(String uuid) {
        PackageItem packageItem = this.getRulesRepository().loadPackageByUUID(uuid);
        this.serviceSecurity.checkSecurityNameTypePackageReadOnly(packageItem);
        return this.repositoryPackageOperations.loadPackageConfig(packageItem);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public ValidatedResponse validatePackageConfiguration(PackageConfigData data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(data.uuid);
        return this.repositoryPackageOperations.validatePackageConfiguration(data);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void savePackage(PackageConfigData data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(data.uuid);
        this.repositoryPackageOperations.savePackage(data);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force) throws SerializationException {
        return this.buildPackage(packageUUID, force, null, null, null, false, null, null, false, null);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BuilderResult buildPackage(String packageUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(packageUUID);
        return this.repositoryPackageOperations.buildPackage(packageUUID, force, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void createPackageSnapshot(String packageName, String snapshotName, boolean replaceExisting, String comment) {
        this.serviceSecurity.checkSecurityIsPackageNameTypeAdmin(packageName);
        this.repositoryPackageOperations.createPackageSnapshot(packageName, snapshotName, replaceExisting, comment);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void copyOrRemoveSnapshot(String packageName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageNameTypeAdmin(packageName);
        this.repositoryPackageOperations.copyOrRemoveSnapshot(packageName, snapshotName, delete, newSnapshotName);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listRulesInPackage(String packageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnly(packageName);
        return this.repositoryPackageOperations.listRulesInPackage(packageName);
    }

    @WebRemote
    public void rebuildSnapshots() throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        PackageIterator pkit = this.getRulesRepository().listPackages();
        while (pkit.hasNext()) {
            String[] snaps;
            PackageItem pkg = (PackageItem)pkit.next();
            for (String snapName : snaps = this.getRulesRepository().listPackageSnapshots(pkg.getName())) {
                PackageItem snap = this.getRulesRepository().loadPackageSnapshot(pkg.getName(), snapName);
                BuilderResult res = this.buildPackage(snap.getUUID(), true);
                if (res == null) continue;
                StringBuilder stringBuilder = this.createStringBuilderFrom(res);
                throw new DetailedSerializationException("Unable to rebuild snapshot [" + snapName, stringBuilder.toString() + "]");
            }
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SnapshotInfo[] listSnapshots(String packageName) {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(packageName);
        String[] snaps = this.getRulesRepository().listPackageSnapshots(packageName);
        SnapshotInfo[] res = new SnapshotInfo[snaps.length];
        for (int i = 0; i < snaps.length; ++i) {
            SnapshotInfo info;
            PackageItem snap = this.getRulesRepository().loadPackageSnapshot(packageName, snaps[i]);
            res[i] = info = new SnapshotInfo();
            info.comment = snap.getCheckinComment();
            info.name = snaps[i];
            info.uuid = snap.getUUID();
        }
        return res;
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public String[] listTypesInPackage(String packageUUID) throws SerializationException {
        if (Contexts.isSessionContextActive()) {
            Identity.instance().checkPermission((Object)new PackageUUIDType(packageUUID), "package.readonly");
        }
        PackageItem pkg = this.getRulesRepository().loadPackageByUUID(packageUUID);
        ArrayList res = new ArrayList();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar", "model.drl"});
        JarInputStream jis = null;
        try {
            String[] asset;
            while (it.hasNext()) {
                asset = it.next();
                if (asset.isArchived()) continue;
                if (asset.getFormat().equals("jar")) {
                    jis = this.typesForModel(res, (AssetItem)asset);
                    continue;
                }
                this.typesForOthers(res, (AssetItem)asset);
            }
            asset = res.toArray(new String[res.size()]);
            return asset;
        }
        catch (IOException e) {
            log.error("Unable to read the jar files in the package: " + e.getMessage());
            throw new DetailedSerializationException("Unable to read the jar files in the package.", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public void updateDependency(String uuid, String dependencyPath) {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(uuid);
        item.updateDependency(dependencyPath);
        item.checkin("Update dependency");
    }

    public String[] getDependencies(String uuid) {
        PackageItem item = this.getRulesRepository().loadPackageByUUID(uuid);
        return item.getDependencies();
    }

    private JarInputStream typesForModel(List<String> res, AssetItem asset) throws IOException {
        JarInputStream jis = new JarInputStream(asset.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            res.add(ModelContentHandler.convertPathToName((String)entry.getName()));
        }
        return jis;
    }

    private void typesForOthers(List<String> res, AssetItem asset) {
        DrlParser parser = new DrlParser();
        try {
            PackageDescr desc = parser.parse(asset.getContent());
            List types = desc.getTypeDeclarations();
            for (TypeDeclarationDescr typeDeclarationDescr : types) {
                res.add(typeDeclarationDescr.getTypeName());
            }
        }
        catch (DroolsParserException e) {
            log.error("An error occurred parsing rule: " + e.getMessage());
        }
    }

    @Restrict(value="#{identity.loggedIn}")
    public void installSampleRepository() throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        this.getRulesRepository().importRepository(this.getClass().getResourceAsStream("/mortgage-sample-repository.xml"));
        this.rebuildPackages();
        this.rebuildSnapshots();
    }

    public SnapshotDiffs compareSnapshots(String packageName, String firstSnapshotName, String secondSnapshotName) {
        return this.repositoryPackageOperations.compareSnapshots(packageName, firstSnapshotName, secondSnapshotName);
    }

    public SnapshotComparisonPageResponse compareSnapshots(SnapshotComparisonPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryPackageOperations.compareSnapshots(request);
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public SingleScenarioResult runScenario(String packageName, Scenario scenario) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(packageName);
        return this.runScenario(packageName, scenario, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleScenarioResult runScenario(String packageName, Scenario scenario, RuleCoverageListener coverage) throws SerializationException {
        SingleScenarioResult result;
        block6: {
            PackageItem item = this.getRulesRepository().loadPackage(packageName);
            result = null;
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            try {
                RuleBase rb = this.loadCacheRuleBase(item);
                CompositeClassLoader cl = ((InternalRuleBase)RuleBaseCache.getInstance().get(item.getUUID())).getRootClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                result = this.runScenario(scenario, item, (ClassLoader)cl, rb, coverage);
            }
            catch (Exception e) {
                if (!(e instanceof DetailedSerializationException)) break block6;
                DetailedSerializationException err = (DetailedSerializationException)e;
                result = new SingleScenarioResult();
                if (err.getErrs() != null) {
                    result.result = new ScenarioRunResult(err.getErrs(), null);
                    break block6;
                }
                throw err;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        }
        return result;
    }

    private RuleBase loadCacheRuleBase(PackageItem item) throws DetailedSerializationException {
        RuleBase rb = null;
        if (item.isBinaryUpToDate() && RuleBaseCache.getInstance().contains(item.getUUID())) {
            rb = RuleBaseCache.getInstance().get(item.getUUID());
        } else {
            List jars = BRMSPackageBuilder.getJars((PackageItem)item);
            MapBackedClassLoader buildCl = BRMSPackageBuilder.createClassLoader((List)jars);
            if (item.isBinaryUpToDate()) {
                rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                RuleBaseCache.getInstance().put(item.getUUID(), rb);
            } else {
                BuilderResult result = this.repositoryPackageOperations.buildPackage(item, false);
                if (result == null || result.getLines().size() == 0) {
                    rb = this.loadRuleBase(item, (ClassLoader)buildCl);
                    RuleBaseCache.getInstance().put(item.getUUID(), rb);
                } else {
                    throw new DetailedSerializationException("Build error", result.getLines());
                }
            }
        }
        return rb;
    }

    private RuleBase loadRuleBase(PackageItem item, ClassLoader cl) throws DetailedSerializationException {
        try {
            return this.deserKnowledgebase(item, cl);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load rule base.", (Throwable)e);
            throw new DetailedSerializationException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Unable to load rule base.", (Throwable)e);
            log.info("...but trying to rebuild binaries...");
            try {
                BuilderResult res = this.repositoryPackageOperations.buildPackage(item, true);
                if (res != null && res.getLines().size() > 0) {
                    log.error("There were errors when rebuilding the knowledgebase.");
                    throw new DetailedSerializationException("There were errors when rebuilding the knowledgebase.", "");
                }
            }
            catch (Exception e1) {
                log.error("Unable to rebuild the rulebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to rebuild the rulebase.", e.getMessage());
            }
            try {
                return this.deserKnowledgebase(item, cl);
            }
            catch (Exception e2) {
                log.error("Unable to reload knowledgebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to reload knowledgebase.", e.getMessage());
            }
        }
    }

    private RuleBase deserKnowledgebase(PackageItem item, ClassLoader cl) throws IOException, ClassNotFoundException {
        RuleBase rb = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(new ClassLoader[]{cl}));
        Package bin = (Package)DroolsStreamUtils.streamIn((byte[])item.getCompiledPackageBytes(), (ClassLoader)cl);
        rb.addPackage(bin);
        return rb;
    }

    private SingleScenarioResult runScenario(Scenario scenario, PackageItem item, ClassLoader cl, RuleBase rb, RuleCoverageListener coverage) throws DetailedSerializationException {
        Package bin = rb.getPackages()[0];
        Set imps = bin.getImports().keySet();
        HashSet allImps = new HashSet(imps);
        if (bin.getGlobals() != null) {
            for (String o : bin.getGlobals().keySet()) {
                allImps.add(bin.getGlobals().get(o));
            }
        }
        allImps.add(bin.getName() + ".*");
        ClassTypeResolver res = new ClassTypeResolver(allImps, cl);
        SessionConfiguration sessionConfiguration = new SessionConfiguration();
        sessionConfiguration.setClockType(ClockType.PSEUDO_CLOCK);
        sessionConfiguration.setKeepReference(false);
        InternalWorkingMemory workingMemory = (InternalWorkingMemory)rb.newStatefulSession(sessionConfiguration, null);
        if (coverage != null) {
            workingMemory.addEventListener((AgendaEventListener)coverage);
        }
        try {
            AuditLogReporter logger = new AuditLogReporter((WorkingMemory)workingMemory);
            new ScenarioRunner(scenario, (TypeResolver)res, workingMemory);
            SingleScenarioResult r = new SingleScenarioResult();
            r.auditLog = logger.buildReport();
            r.result = new ScenarioRunResult(null, scenario);
            return r;
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load a required class.", (Throwable)e);
            throw new DetailedSerializationException("Unable to load a required class.", e.getMessage());
        }
        catch (ConsequenceException e) {
            String messageShort = "There was an error executing the consequence of rule [" + e.getRule().getName() + "]";
            String messageLong = e.getMessage();
            if (e.getCause() != null) {
                messageLong = messageLong + "\nCAUSED BY " + e.getCause().getMessage();
            }
            log.error(messageShort + ": " + messageLong, (Throwable)e);
            throw new DetailedSerializationException(messageShort, messageLong);
        }
        catch (Exception e) {
            log.error("Unable to run the scenario.", (Throwable)e);
            throw new DetailedSerializationException("Unable to run the scenario.", e.getMessage());
        }
    }

    @WebRemote
    @Restrict(value="#{identity.loggedIn}")
    public BulkTestRunResult runScenariosInPackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloper(packageUUID);
        PackageItem item = this.getRulesRepository().loadPackageByUUID(packageUUID);
        return this.runScenariosInPackage(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkTestRunResult runScenariosInPackage(PackageItem item) throws DetailedSerializationException, SerializationException {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        MapBackedClassLoader cl = null;
        try {
            if (item.isBinaryUpToDate() && RuleBaseCache.getInstance().contains(item.getUUID())) {
                RuleBase rb = RuleBaseCache.getInstance().get(item.getUUID());
                AbstractRuleBase arb = (AbstractRuleBase)rb;
                cl = arb.getConfiguration().getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            } else {
                List jars = BRMSPackageBuilder.getJars((PackageItem)item);
                cl = BRMSPackageBuilder.createClassLoader((List)jars);
                Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                if (item.isBinaryUpToDate()) {
                    RuleBaseCache.getInstance().put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl));
                } else {
                    BuilderResult result = this.repositoryPackageOperations.buildPackage(item, false);
                    if (result == null || result.getLines().size() == 0) {
                        RuleBaseCache.getInstance().put(item.getUUID(), this.loadRuleBase(item, (ClassLoader)cl));
                    } else {
                        BulkTestRunResult bulkTestRunResult = new BulkTestRunResult(result, null, 0, null);
                        return bulkTestRunResult;
                    }
                }
            }
            AssetItemIterator it = item.listAssetsByFormat(new String[]{"scenario"});
            ArrayList<ScenarioResultSummary> resultSummaries = new ArrayList<ScenarioResultSummary>();
            RuleBase rb = RuleBaseCache.getInstance().get(item.getUUID());
            Package bin = rb.getPackages()[0];
            RuleCoverageListener coverage = new RuleCoverageListener(this.expectedRules(bin));
            while (it.hasNext()) {
                AssetItem as = it.next();
                if (as.getDisabled()) continue;
                RuleAsset asset = this.repositoryAssetOperations.loadAsset(as);
                Scenario sc = (Scenario)asset.content;
                this.runScenario(item.getName(), sc, coverage);
                int[] totals = sc.countFailuresTotal();
                resultSummaries.add(new ScenarioResultSummary(totals[0], totals[1], asset.name, asset.description, asset.uuid));
            }
            ScenarioResultSummary[] summaries = resultSummaries.toArray(new ScenarioResultSummary[resultSummaries.size()]);
            BulkTestRunResult bulkTestRunResult = new BulkTestRunResult(null, resultSummaries.toArray(summaries), coverage.getPercentCovered(), coverage.getUnfiredRules());
            return bulkTestRunResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    private HashSet<String> expectedRules(Package bin) {
        HashSet<String> h = new HashSet<String>();
        for (int i = 0; i < bin.getRules().length; ++i) {
            h.add(bin.getRules()[i].getName());
        }
        return h;
    }
}

