/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.lang.dsl.DSLMappingParseException;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionedAssetItemIterator;
import org.drools.rule.MapBackedClassLoader;
import org.drools.util.ChainedProperties;
import org.drools.xml.SemanticModule;
import org.jbpm.bpmn2.xml.BPMNDISemanticModule;
import org.jbpm.bpmn2.xml.BPMNSemanticModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class BRMSPackageBuilder
extends PackageBuilder {
    private List<DSLTokenizedMappingFile> dslFiles;
    private DefaultExpander expander;

    public static BRMSPackageBuilder getInstance(List<JarInputStream> classpath, Properties buildProps) {
        MapBackedClassLoader loader = BRMSPackageBuilder.createClassLoader(classpath);
        ChainedProperties chainedProperties = new ChainedProperties("packagebuilder.conf", BRMSPackageBuilder.class.getClassLoader(), false);
        Properties properties = new Properties();
        properties.setProperty("drools.dialect.java.compiler", chainedProperties.getProperty("drools.dialect.java.compiler", "ECLIPSE"));
        properties.putAll((Map<?, ?>)buildProps);
        PackageBuilderConfiguration pkgConf = new PackageBuilderConfiguration(properties, new ClassLoader[]{loader});
        pkgConf.setAllowMultipleNamespaces(false);
        pkgConf.addSemanticModule((SemanticModule)new BPMNSemanticModule());
        pkgConf.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
        return new BRMSPackageBuilder(pkgConf);
    }

    public static MapBackedClassLoader createClassLoader(List<JarInputStream> classpath) {
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        if (parentClassLoader == null) {
            parentClassLoader = BRMSPackageBuilder.class.getClassLoader();
        }
        ClassLoader p = parentClassLoader;
        MapBackedClassLoader loader = (MapBackedClassLoader)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        try {
            for (JarInputStream jis : classpath) {
                JarEntry entry = null;
                byte[] buf = new byte[1024];
                int len = 0;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (entry.isDirectory() || entry.getName().endsWith(".java")) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = jis.read(buf)) >= 0) {
                        out.write(buf, 0, len);
                    }
                    loader.addResource(entry.getName(), out.toByteArray());
                }
            }
        }
        catch (IOException e) {
            throw new RulesRepositoryException((Throwable)e);
        }
        return loader;
    }

    private BRMSPackageBuilder(PackageBuilderConfiguration config) {
        super(config);
    }

    public BRMSPackageBuilder() {
        super(new PackageBuilderConfiguration());
    }

    public void clearErrors() {
        super.resetErrors();
    }

    public void setDSLFiles(List<DSLTokenizedMappingFile> files) {
        this.dslFiles = files;
    }

    public List<DSLTokenizedMappingFile> getDSLMappingFiles() {
        return Collections.unmodifiableList(this.dslFiles);
    }

    public static List<DSLTokenizedMappingFile> getDSLMappingFiles(PackageItem pkg, DSLErrorEvent err) {
        ArrayList<DSLTokenizedMappingFile> result = new ArrayList<DSLTokenizedMappingFile>();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"dsl"});
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (it.hasNext()) {
            AssetItem item = it.next();
            if (item.getDisabled()) continue;
            String dslData = item.getContent();
            DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
            try {
                if (file.parseAndLoad((Reader)new StringReader(dslData))) {
                    result.add(file);
                    continue;
                }
                for (DSLMappingParseException e : file.getErrors()) {
                    err.recordError(item, "Line " + e.getLine() + " : " + e.getMessage());
                }
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
        return result;
    }

    public static List<JarInputStream> getJars(PackageItem pkg) {
        ArrayList<JarInputStream> result = new ArrayList<JarInputStream>();
        AssetItemIterator ait = pkg.listAssetsByFormat(new String[]{"jar"});
        ((VersionedAssetItemIterator)ait).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (ait.hasNext()) {
            AssetItem item = ait.next();
            if (item.getBinaryContentAttachment() == null) continue;
            try {
                result.add(new JarInputStream(item.getBinaryContentAttachment(), false));
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
        return result;
    }

    public boolean hasDSL() {
        return this.dslFiles != null && this.dslFiles.size() > 0;
    }

    public DefaultExpander getDSLExpander() {
        if (this.expander == null) {
            this.expander = new DefaultExpander();
            for (DSLTokenizedMappingFile file : this.dslFiles) {
                this.expander.addDSLMapping(file.getMapping());
            }
        }
        return this.expander;
    }
}

