/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentAssemblyError;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.ContentManager;
import org.drools.guvnor.server.contenthandler.ICompilable;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.BuiltInSelector;
import org.drools.guvnor.server.selector.SelectorManager;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.lang.descr.PackageDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;
import org.drools.repository.VersionableItem;
import org.drools.repository.VersionedAssetItemIterator;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentPackageAssembler {
    private static final LoggingHelper log = LoggingHelper.getLogger(ContentPackageAssembler.class);
    private PackageItem packageItem;
    private List<ContentAssemblyError> errors = new ArrayList();
    BRMSPackageBuilder builder;
    private String customSelectorName;
    private String buildMode;
    private String statusOperator;
    private String statusDescriptionValue;
    private boolean enableStatusSelector;
    private String categoryOperator;
    private String categoryValue;
    private boolean enableCategorySelector;

    public ContentPackageAssembler(PackageItem pkg) {
        this(pkg, true);
    }

    public ContentPackageAssembler(PackageItem pkg, boolean compile) {
        this(pkg, compile, null, null, null, false, null, null, false, null);
    }

    public ContentPackageAssembler(PackageItem assetPackage, boolean compile, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String categoryValue, boolean enableCategorySelector, String selectorConfigName) {
        this.packageItem = assetPackage;
        this.customSelectorName = selectorConfigName;
        this.buildMode = buildMode;
        this.statusOperator = statusOperator;
        this.statusDescriptionValue = statusDescriptionValue;
        this.enableStatusSelector = enableStatusSelector;
        this.categoryOperator = categoryOperator;
        this.categoryValue = categoryValue;
        this.enableCategorySelector = enableCategorySelector;
        this.createBuilder();
        if (compile && this.preparePackage()) {
            this.buildPackage();
        }
    }

    public ContentPackageAssembler(AssetItem assetToBuild) {
        this.packageItem = assetToBuild.getPackage();
        this.createBuilder();
        if (this.preparePackage()) {
            this.buildAsset(assetToBuild);
        }
    }

    public ContentPackageAssembler(RuleAsset asset, PackageItem packageItem) {
        this.packageItem = packageItem;
        this.createBuilder();
        if (this.preparePackage()) {
            this.buildAsset(asset);
        }
    }

    public void createBuilder() {
        try {
            Properties ps = this.loadConfProperties(this.packageItem);
            ps.setProperty("drools.defaultPackageName", this.packageItem.getName());
            this.builder = BRMSPackageBuilder.getInstance((List)BRMSPackageBuilder.getJars((PackageItem)this.packageItem), (Properties)ps);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("Unable to load configuration properties for package.", (Throwable)e);
        }
    }

    Properties loadConfProperties(PackageItem pkg) throws IOException {
        Properties bigHappyProperties = new Properties();
        AssetItemIterator iter = pkg.listAssetsByFormat(new String[]{"properties", "conf"});
        ((VersionedAssetItemIterator)iter).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (iter.hasNext()) {
            AssetItem conf = iter.next();
            conf.getContent();
            Properties properties = new Properties();
            properties.load(conf.getBinaryContentAttachment());
            bigHappyProperties.putAll((Map<?, ?>)properties);
        }
        return bigHappyProperties;
    }

    private void buildPackage() {
        AssetSelector selector = null;
        if ("customSelector".equals(this.buildMode)) {
            selector = SelectorManager.getInstance().getSelector(this.customSelectorName);
        } else if ("builtInSelector".equals(this.buildMode)) {
            selector = (BuiltInSelector)SelectorManager.getInstance().getSelector("BuiltInSelector");
            ((BuiltInSelector)selector).setStatusOperator(this.statusOperator);
            ((BuiltInSelector)selector).setStatus(this.statusDescriptionValue);
            ((BuiltInSelector)selector).setEnableStatusSelector(this.enableStatusSelector);
            ((BuiltInSelector)selector).setCategory(this.categoryValue);
            ((BuiltInSelector)selector).setCategoryOperator(this.categoryOperator);
            ((BuiltInSelector)selector).setEnableCategorySelector(this.enableCategorySelector);
        } else {
            selector = SelectorManager.getInstance().getSelector(null);
        }
        if (selector == null) {
            this.errors.add(new ContentAssemblyError((VersionableItem)this.packageItem, "The selector named " + this.customSelectorName + " is not available."));
            return;
        }
        StringBuilder includedAssets = new StringBuilder("Following assets have been included in package build: ");
        AssetItemIterator drls = this.packageItem.listAssetsByFormat(new String[]{"drl"});
        ((VersionedAssetItemIterator)drls).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (drls.hasNext()) {
            AssetItem asset = (AssetItem)drls.next();
            if (asset.isArchived() || !selector.isAssetAllowed(asset)) continue;
            this.buildAsset(asset);
            includedAssets.append(asset.getName() + ", ");
        }
        Iterator it = this.packageItem.getAssets();
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (asset.getFormat().equals("drl") || asset.isArchived() || !selector.isAssetAllowed(asset)) continue;
            this.buildAsset(asset);
            includedAssets.append(asset.getName() + ", ");
        }
        log.info(includedAssets.toString());
    }

    private void buildAsset(AssetItem asset) {
        ContentHandler contentHandler = ContentManager.getHandler((String)asset.getFormat());
        if (contentHandler instanceof ICompilable && !asset.getDisabled()) {
            try {
                ((ICompilable)contentHandler).compile(this.builder, asset, new ErrorLogger(this));
                if (this.builder.hasErrors()) {
                    this.recordBuilderErrors((VersionableItem)asset);
                    this.builder.clearErrors();
                }
            }
            catch (DroolsParserException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
    }

    private void buildAsset(RuleAsset asset) {
        ContentHandler contentHandler = ContentManager.getHandler((String)asset.metaData.format);
        if (contentHandler instanceof ICompilable && !asset.metaData.disabled) {
            try {
                ((ICompilable)contentHandler).compile(this.builder, asset, new ErrorLogger(this));
                if (this.builder.hasErrors()) {
                    this.recordBuilderErrors(asset);
                    this.builder.clearErrors();
                }
            }
            catch (DroolsParserException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
            catch (IOException e) {
                throw new RulesRepositoryException((Throwable)e);
            }
        }
    }

    private boolean preparePackage() {
        AssetItem func;
        this.builder.addPackage(new PackageDescr(this.packageItem.getName()));
        this.loadDeclaredTypes();
        this.addDrl(DroolsHeader.getDroolsHeader((PackageItem)this.packageItem));
        if (this.builder.hasErrors()) {
            this.recordBuilderErrors((VersionableItem)this.packageItem);
            return false;
        }
        this.loadDSLFiles();
        AssetItemIterator it = this.packageItem.listAssetsByFormat(new String[]{"function"});
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        StringBuilder stringBuilder = new StringBuilder();
        while (it.hasNext()) {
            func = it.next();
            if (func.getDisabled()) continue;
            stringBuilder.append(func.getContent());
        }
        this.addDrl(stringBuilder.toString());
        if (this.builder.hasErrors()) {
            this.builder.clearErrors();
            it = this.packageItem.listAssetsByFormat(new String[]{"function"});
            ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
            while (it.hasNext()) {
                func = it.next();
                if (func.getDisabled()) continue;
                this.addDrl(func.getContent());
                if (!this.builder.hasErrors()) continue;
                this.recordBuilderErrors((VersionableItem)func);
                this.builder.clearErrors();
            }
        }
        return this.errors.size() == 0;
    }

    private void loadDeclaredTypes() {
        AssetItemIterator it = this.packageItem.listAssetsByFormat(new String[]{"model.drl"});
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (it.hasNext()) {
            AssetItem as = it.next();
            if (as.getDisabled()) continue;
            try {
                String content = as.getContent();
                if (!this.nonEmpty(content)) continue;
                this.builder.addPackageFromDrl((Reader)new StringReader(as.getContent()));
            }
            catch (DroolsParserException e) {
                this.errors.add(new ContentAssemblyError((VersionableItem)as, "Parser exception: " + e.getMessage()));
            }
            catch (IOException e) {
                this.errors.add(new ContentAssemblyError((VersionableItem)as, "IOException: " + e.getMessage()));
            }
        }
    }

    private boolean nonEmpty(String content) {
        return content != null && content.trim().length() > 0;
    }

    private void loadDSLFiles() {
        this.builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)this.packageItem, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean isPackageConfigurationInError() {
        if (this.errors.size() > 0) {
            return ((ContentAssemblyError)this.errors.get(0)).isPackageItem();
        }
        return false;
    }

    private void addDrl(String drl) {
        if ("".equals(drl.trim())) {
            return;
        }
        try {
            this.builder.addPackageFromDrl((Reader)new StringReader(drl));
        }
        catch (DroolsParserException e) {
            throw new RulesRepositoryException("Unexpected error when parsing package.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RulesRepositoryException("IO Exception occurred when parsing package.", (Throwable)e);
        }
    }

    private void recordBuilderErrors(VersionableItem asset) {
        DroolsError[] errs = this.builder.getErrors().getErrors();
        for (int i = 0; i < errs.length; ++i) {
            this.errors.add(new ContentAssemblyError(asset, errs[i].getMessage()));
        }
    }

    private void recordBuilderErrors(RuleAsset asset) {
        DroolsError[] errs = this.builder.getErrors().getErrors();
        for (int i = 0; i < errs.length; ++i) {
            this.errors.add(new ContentAssemblyError(asset, errs[i].getMessage()));
        }
    }

    public Package getBinaryPackage() {
        if (this.hasErrors()) {
            throw new IllegalStateException("There is no package available, as there were errors.");
        }
        return this.builder.getPackage();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ContentAssemblyError> getErrors() {
        return this.errors;
    }

    public BRMSPackageBuilder getBuilder() {
        return this.builder;
    }

    public String getDRL() {
        StringBuilder src = new StringBuilder();
        src.append("package " + this.packageItem.getName() + "\n");
        src.append(DroolsHeader.getDroolsHeader((PackageItem)this.packageItem) + "\n\n");
        this.builder.setDSLFiles(BRMSPackageBuilder.getDSLMappingFiles((PackageItem)this.packageItem, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */));
        AssetItemIterator it = this.packageItem.listAssetsByFormat(new String[]{"function", "model.drl"});
        ((VersionedAssetItemIterator)it).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (it.hasNext()) {
            AssetItem func = it.next();
            if (func.isArchived() || func.getDisabled()) continue;
            src.append(func.getContent()).append("\n\n");
        }
        Iterator iter = this.packageItem.getAssets();
        ((VersionedAssetItemIterator)iter).setReturnAssetsWithVersionsSpecifiedByDependencies(true);
        while (iter.hasNext()) {
            AssetItem asset = (AssetItem)iter.next();
            if (asset.isArchived() || asset.getDisabled()) continue;
            ContentHandler handler = ContentManager.getHandler((String)asset.getFormat());
            if (handler.isRuleAsset()) {
                IRuleAsset ruleAsset = (IRuleAsset)handler;
                ruleAsset.assembleDRL(this.builder, asset, src);
            }
            src.append("\n\n");
        }
        return src.toString();
    }

    static /* synthetic */ List access$000(ContentPackageAssembler x0) {
        return x0.errors;
    }
}

