/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.drools.guvnor.client.rpc.CategoryPageRow;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRuleListPageRowBuilder {
    public List<CategoryPageRow> createRows(PageRequest pageRequest, Iterator<AssetItem> iterator) {
        ArrayList<CategoryPageRow> rowList = new ArrayList<CategoryPageRow>();
        while (iterator.hasNext()) {
            AssetItem assetItem = iterator.next();
            rowList.add(this.makeCategoryPageRow(assetItem));
        }
        return rowList;
    }

    private CategoryPageRow makeCategoryPageRow(AssetItem assetItem) {
        CategoryPageRow row = new CategoryPageRow();
        row.setUuid(assetItem.getUUID());
        row.setFormat(assetItem.getFormat());
        row.setName(assetItem.getName());
        row.setDescription(assetItem.getDescription());
        row.setAbbreviatedDescription(StringUtils.abbreviate((String)assetItem.getDescription(), (int)80));
        row.setLastModified(assetItem.getLastModified().getTime());
        row.setStateName(assetItem.getState().getName());
        row.setPackageName(assetItem.getPackageName());
        return row;
    }
}

