/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.PermissionsPageRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionPageRowBuilder {
    public List<PermissionsPageRow> createRows(PageRequest pageRequest, Map<String, List<String>> permissions) {
        int rowMinNumber = pageRequest.getStartRowIndex();
        int rowMaxNumber = pageRequest.getPageSize() == null ? permissions.size() : rowMinNumber + pageRequest.getPageSize();
        int resultsSize = pageRequest.getPageSize() == null ? permissions.size() : pageRequest.getPageSize().intValue();
        ArrayList<PermissionsPageRow> rowList = new ArrayList<PermissionsPageRow>(resultsSize);
        Iterator<String> mapItr = permissions.keySet().iterator();
        for (int rowNumber = 0; mapItr.hasNext() && rowNumber < rowMaxNumber; ++rowNumber) {
            String userName = mapItr.next();
            if (rowNumber < rowMinNumber) continue;
            List<String> userPermissions = permissions.get(userName);
            PermissionsPageRow row = new PermissionsPageRow();
            row.setUserName(userName);
            row.setUserPermissions(userPermissions);
            rowList.add(row);
        }
        return rowList;
    }
}

