/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder.pagerow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.guvnor.client.rpc.PageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.server.AssetItemFilter;
import org.drools.guvnor.server.util.QueryPageRowCreator;
import org.drools.repository.AssetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickFindPageRowBuilder {
    public List<QueryPageRow> createRows(PageRequest pageRequest, Iterator<AssetItem> iterator) {
        int skipped = 0;
        Integer pageSize = pageRequest.getPageSize();
        int startRowIndex = pageRequest.getStartRowIndex();
        AssetItemFilter filter = new AssetItemFilter();
        ArrayList<QueryPageRow> rowList = new ArrayList<QueryPageRow>();
        while (iterator.hasNext() && (pageSize == null || rowList.size() < pageSize)) {
            AssetItem assetItem = iterator.next();
            if (!filter.accept((Object)assetItem, "package.readonly")) continue;
            if (skipped >= startRowIndex) {
                rowList.add(QueryPageRowCreator.makeQueryPageRow((AssetItem)assetItem));
            }
            ++skipped;
        }
        return rowList;
    }
}

